/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.json.mappings;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Splitter;
import com.google.common.collect.ComparisonChain;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.calrissian.mango.domain.Attribute;
import org.calrissian.mango.domain.Pair;
import org.calrissian.mango.json.mappings.JsonMetadata;
import org.calrissian.mango.json.mappings.JsonUtil;
import org.calrissian.mango.json.mappings.ObjectJsonNode;
import org.calrissian.mango.json.mappings.ValueJsonNode;

public class JsonAttributeMappings {
    private static final String NESTING_DELIM = "_$";
    private static final Pair<Integer, Integer> DEFAULT_PAIR = new Pair((Object)-1, (Object)-1);
    private static final Splitter SPLITTER = Splitter.on((String)"_$");

    private JsonAttributeMappings() {
    }

    public static Collection<Attribute> fromJson(ObjectNode object) throws IOException {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        JsonAttributeMappings.convertJsonObject(attributes, (JsonNode)object, "", 0, new HashMap<String, String>());
        return attributes;
    }

    public static Collection<Attribute> fromJson(String json, ObjectMapper objectMapper) throws IOException {
        Objects.requireNonNull(json);
        JsonNode object = objectMapper.readTree(json);
        if (object.isObject()) {
            return JsonAttributeMappings.fromJson((ObjectNode)object);
        }
        throw new IllegalArgumentException("Error parsing json or input was not json object");
    }

    public static Collection<Attribute> fromMap(Map<String, Object> map) {
        Objects.requireNonNull(map);
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        JsonAttributeMappings.convertObject(attributes, map, "", 0, new HashMap<String, String>());
        return attributes;
    }

    public static String toJsonString(Collection<Attribute> attributeCollection, ObjectMapper objectMapper) throws JsonProcessingException {
        return objectMapper.writeValueAsString(JsonAttributeMappings.toObject(attributeCollection));
    }

    public static Map<String, Object> toObject(Collection<Attribute> attributeCollection) {
        Objects.requireNonNull(attributeCollection);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(attributeCollection);
        Collections.sort(attributes, new FlattenedLevelsComparator());
        ObjectJsonNode root = new ObjectJsonNode();
        for (Attribute attribute : attributes) {
            List keys = SPLITTER.splitToList((CharSequence)attribute.getKey());
            Map<Integer, Integer> levelsIndices = JsonMetadata.levelsToIndices(attribute.getMetadata());
            String[] adjustedKeys = new String[keys.size() + levelsIndices.size()];
            int count = 0;
            for (int i = 0; i < adjustedKeys.length; ++i) {
                if (levelsIndices.containsKey(i)) {
                    adjustedKeys[i] = "[]";
                    continue;
                }
                adjustedKeys[i] = (String)keys.get(count);
                ++count;
            }
            root.visit(adjustedKeys, 0, levelsIndices, new ValueJsonNode(attribute.getValue()));
        }
        return root.toObject();
    }

    private static void convertJsonObject(Collection<Attribute> attributes, JsonNode object, String intialKey, int nestedLevel, Map<String, String> metadata) {
        Iterator fields = object.fields();
        while (fields.hasNext()) {
            String key;
            Map.Entry entry = (Map.Entry)fields.next();
            String string = key = intialKey.equals("") ? (String)entry.getKey() : intialKey + NESTING_DELIM + (String)entry.getKey();
            if (((JsonNode)entry.getValue()).isNull()) continue;
            if (((JsonNode)entry.getValue()).isObject()) {
                JsonAttributeMappings.convertJsonObject(attributes, (JsonNode)entry.getValue(), key, nestedLevel + 1, metadata);
                continue;
            }
            if (((JsonNode)entry.getValue()).isArray()) {
                JsonAttributeMappings.convertJsonArray(attributes, (JsonNode)entry.getValue(), key, nestedLevel + 1, metadata);
                continue;
            }
            attributes.add(new Attribute(key, JsonUtil.nodeToObject((JsonNode)entry.getValue()), metadata));
        }
    }

    private static void convertJsonArray(Collection<Attribute> attributes, JsonNode jsonArray, String intialKey, int nestedLevel, Map<String, String> metadata) {
        HashMap<String, String> map = new HashMap<String, String>(metadata);
        for (int i = 0; i < jsonArray.size(); ++i) {
            String key;
            JsonNode obj = jsonArray.get(i);
            JsonMetadata.setArrayIndex(map, nestedLevel, i);
            String string = key = intialKey.equals("") ? "" : intialKey;
            if (obj.isNull()) continue;
            if (obj.isObject()) {
                JsonAttributeMappings.convertJsonObject(attributes, obj, key, nestedLevel + 1, map);
                continue;
            }
            if (obj.isArray()) {
                JsonAttributeMappings.convertJsonArray(attributes, obj, key, nestedLevel + 1, map);
                continue;
            }
            attributes.add(new Attribute(key, JsonUtil.nodeToObject(obj), map));
        }
    }

    private static void convertObject(Collection<Attribute> attributes, Map<String, Object> object, String intialKey, int nestedLevel, Map<String, String> metadata) {
        Set<Map.Entry<String, Object>> fields = object.entrySet();
        for (Map.Entry entry : fields) {
            String key;
            String string = key = intialKey.equals("") ? (String)entry.getKey() : intialKey + NESTING_DELIM + (String)entry.getKey();
            if (entry.getValue() == null) continue;
            if (entry.getValue() instanceof Map) {
                JsonAttributeMappings.convertObject(attributes, (Map)entry.getValue(), key, nestedLevel + 1, metadata);
                continue;
            }
            if (entry.getValue() instanceof Iterable) {
                JsonAttributeMappings.convertIterable(attributes, (Iterable)entry.getValue(), key, nestedLevel + 1, metadata);
                continue;
            }
            attributes.add(new Attribute(key, entry.getValue(), metadata));
        }
    }

    private static void convertIterable(Collection<Attribute> attributes, Iterable<Object> jsonArray, String intialKey, int nestedLevel, Map<String, String> metadata) {
        HashMap<String, String> map = new HashMap<String, String>(metadata);
        int count = 0;
        for (Object obj : jsonArray) {
            String key;
            JsonMetadata.setArrayIndex(map, nestedLevel, count);
            String string = key = intialKey.equals("") ? "" : intialKey;
            if (obj != null) {
                if (obj instanceof Map) {
                    JsonAttributeMappings.convertObject(attributes, (Map)obj, key, nestedLevel + 1, map);
                } else if (obj instanceof Iterable) {
                    JsonAttributeMappings.convertIterable(attributes, (Iterable)obj, key, nestedLevel + 1, map);
                } else {
                    attributes.add(new Attribute(key, obj, map));
                }
            }
            ++count;
        }
    }

    public static class FlattenedLevelsComparator
    implements Comparator<Attribute> {
        private Map<Attribute, Integer> levelsCache = new HashMap<Attribute, Integer>();

        private int getLevels(Attribute attribute) {
            Integer levels = this.levelsCache.get(attribute);
            if (levels == null) {
                levels = SPLITTER.splitToList((CharSequence)attribute.getKey()).size();
                levels = levels + JsonMetadata.levelsToIndices(attribute.getMetadata()).size();
                this.levelsCache.put(attribute, levels);
            }
            return levels;
        }

        @Override
        public int compare(Attribute attribute, Attribute attribute2) {
            int levels1 = this.getLevels(attribute);
            int levels2 = this.getLevels(attribute2);
            ComparisonChain comparisonChain = ComparisonChain.start();
            for (int i = 0; i < Math.max(levels1, levels2); ++i) {
                Pair pair1 = JsonMetadata.hasArrayIndex(attribute.getMetadata(), i) ? new Pair((Object)i, (Object)JsonMetadata.getArrayIndex(attribute.getMetadata(), i)) : DEFAULT_PAIR;
                Pair pair2 = JsonMetadata.hasArrayIndex(attribute2.getMetadata(), i) ? new Pair((Object)i, (Object)JsonMetadata.getArrayIndex(attribute2.getMetadata(), i)) : DEFAULT_PAIR;
                comparisonChain = comparisonChain.compare((Comparable)pair1.getOne(), (Comparable)pair2.getOne());
                comparisonChain = comparisonChain.compare((Comparable)pair1.getTwo(), (Comparable)pair2.getTwo());
            }
            comparisonChain = comparisonChain.compare(levels1, levels2).compare((Comparable)((Object)attribute.getKey()), (Comparable)((Object)attribute2.getKey()));
            return comparisonChain.result();
        }
    }
}

