/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.json.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.calrissian.mango.domain.Attribute;
import org.calrissian.mango.types.TypeRegistry;

public class AttributeSerializer
extends JsonSerializer<Attribute> {
    private final TypeRegistry<String> typeContext;

    public AttributeSerializer(TypeRegistry<String> typeContext) {
        this.typeContext = typeContext;
    }

    public void serialize(Attribute attribute, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("key", attribute.getKey());
        Object value = attribute.getValue();
        if (value != null) {
            String type = this.typeContext.getAlias(value);
            String val_str = (String)this.typeContext.encode(value);
            jsonGenerator.writeStringField("type", type);
            jsonGenerator.writeStringField("value", val_str);
            jsonGenerator.writeArrayFieldStart("metadata");
            Set entries = attribute.getMetadata().entrySet();
            for (Map.Entry objectEntry : entries) {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeObjectField("value", objectEntry.getValue());
                jsonGenerator.writeObjectField("key", objectEntry.getKey());
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndArray();
        }
        jsonGenerator.writeEndObject();
    }
}

