/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.restdoclet.example.spring;

import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/foo", "/bar"})
public class ExampleController {
    private static int count = 0;
    private static Map<String, String> userColors = new HashMap();

    @RequestMapping(value={"/add"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String postExample(@RequestParam int value) {
        return Integer.toString(count += value);
    }

    @RequestMapping(value={"/user/{name}/color"}, produces={"text/plain"})
    @ResponseBody
    public String getColor(@PathVariable(value="name") String userId, @RequestParam(required=false) boolean normalize) {
        if (!userColors.containsKey(userId)) {
            return "";
        }
        return normalize ? ((String)userColors.get(userId)).toLowerCase() : (String)userColors.get(userId);
    }

    @RequestMapping(value={"/user/{name}/color"}, method={RequestMethod.POST, RequestMethod.PUT}, consumes={"application/json"}, produces={"text/plain"})
    @ResponseBody
    public String setColor(@PathVariable(value="name") String userId, @RequestBody String value) {
        userColors.put(userId, value);
        return this.getColor(userId, false);
    }
}

