/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.assertions.bpmn;

import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.externaltask.ExternalTaskQuery;
import org.camunda.bpm.engine.history.HistoricActivityInstanceQuery;
import org.camunda.bpm.engine.history.HistoricCaseActivityInstanceQuery;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.repository.CaseDefinitionQuery;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.runtime.CaseExecutionQuery;
import org.camunda.bpm.engine.runtime.CaseInstanceQuery;
import org.camunda.bpm.engine.runtime.ExecutionQuery;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.task.TaskQuery;

public abstract class AbstractProcessAssert<S extends AbstractProcessAssert<S, A>, A>
extends AbstractAssert<S, A> {
    protected ProcessEngine engine;
    private static ThreadLocal<Map<Class<?>, AbstractProcessAssert<?, ?>>> lastAsserts = new ThreadLocal();

    protected AbstractProcessAssert(ProcessEngine engine, A actual, Class<?> selfType) {
        super(actual, selfType);
        this.engine = engine;
        AbstractProcessAssert.setLastAssert(selfType, this);
    }

    public A getActual() {
        return (A)this.actual;
    }

    protected A getExistingCurrent() {
        ((AbstractObjectAssert)Assertions.assertThat((Object)this.actual).overridingErrorMessage("Expecting assertion to be called on non-null object, but found it to be null!", new Object[0])).isNotNull();
        A current = this.getCurrent();
        ((AbstractObjectAssert)Assertions.assertThat(current).overridingErrorMessage("Expecting %s to be unfinished, but found that it already finished!", new Object[]{this.toString(this.actual)})).isNotNull();
        return current;
    }

    protected abstract A getCurrent();

    protected abstract String toString(A var1);

    public static void resetLastAsserts() {
        AbstractProcessAssert.getLastAsserts().clear();
    }

    protected static <S extends AbstractProcessAssert<?, ?>> S getLastAssert(Class<S> assertClass) {
        return (S)((Object)AbstractProcessAssert.getLastAsserts().get(assertClass));
    }

    private static void setLastAssert(Class<?> assertClass, AbstractProcessAssert<?, ?> assertInstance) {
        AbstractProcessAssert.getLastAsserts().put(assertClass, assertInstance);
    }

    private static Map<Class<?>, AbstractProcessAssert<?, ?>> getLastAsserts() {
        Map<Class<?>, AbstractProcessAssert<?, ?>> asserts = lastAsserts.get();
        if (asserts == null) {
            asserts = new HashMap();
            lastAsserts.set(asserts);
        }
        return asserts;
    }

    protected RepositoryService repositoryService() {
        return this.engine.getRepositoryService();
    }

    protected RuntimeService runtimeService() {
        return this.engine.getRuntimeService();
    }

    protected FormService formService() {
        return this.engine.getFormService();
    }

    protected TaskService taskService() {
        return this.engine.getTaskService();
    }

    protected HistoryService historyService() {
        return this.engine.getHistoryService();
    }

    protected ManagementService managementService() {
        return this.engine.getManagementService();
    }

    protected ExternalTaskService externalTaskService() {
        return this.engine.getExternalTaskService();
    }

    protected CaseService caseService() {
        return this.engine.getCaseService();
    }

    protected TaskQuery taskQuery() {
        return this.taskService().createTaskQuery();
    }

    protected JobQuery jobQuery() {
        return this.managementService().createJobQuery();
    }

    protected ProcessInstanceQuery processInstanceQuery() {
        return this.runtimeService().createProcessInstanceQuery();
    }

    protected ExecutionQuery executionQuery() {
        return this.runtimeService().createExecutionQuery();
    }

    protected HistoricActivityInstanceQuery historicActivityInstanceQuery() {
        return this.historyService().createHistoricActivityInstanceQuery();
    }

    protected HistoricProcessInstanceQuery historicProcessInstanceQuery() {
        return this.historyService().createHistoricProcessInstanceQuery();
    }

    protected HistoricVariableInstanceQuery historicVariableInstanceQuery() {
        return this.historyService().createHistoricVariableInstanceQuery();
    }

    protected ProcessDefinitionQuery processDefinitionQuery() {
        return this.repositoryService().createProcessDefinitionQuery();
    }

    protected ExternalTaskQuery externalTaskQuery() {
        return this.externalTaskService().createExternalTaskQuery();
    }

    protected CaseExecutionQuery caseExecutionQuery() {
        return this.caseService().createCaseExecutionQuery();
    }

    protected CaseDefinitionQuery caseDefinitionQuery() {
        return this.repositoryService().createCaseDefinitionQuery();
    }

    protected CaseInstanceQuery caseInstanceQuery() {
        return this.caseService().createCaseInstanceQuery();
    }

    protected HistoricCaseActivityInstanceQuery historicCaseActivityInstanceQuery() {
        return this.historyService().createHistoricCaseActivityInstanceQuery();
    }
}

