/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.assertions.bpmn;

import java.util.Date;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractDateAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ExecutionQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.test.assertions.bpmn.AbstractProcessAssert;

public class JobAssert
extends AbstractProcessAssert<JobAssert, Job> {
    protected JobAssert(ProcessEngine engine, Job actual) {
        super(engine, actual, JobAssert.class);
    }

    protected static JobAssert assertThat(ProcessEngine engine, Job actual) {
        return new JobAssert(engine, actual);
    }

    @Override
    protected Job getCurrent() {
        return (Job)this.jobQuery().jobId(((Job)this.actual).getId()).singleResult();
    }

    public JobAssert hasId(String expectedId) {
        Job current = (Job)this.getExistingCurrent();
        Assertions.assertThat((String)expectedId).isNotEmpty();
        String actualId = ((Job)this.actual).getId();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualId).overridingErrorMessage("Expecting %s to have id '%s', but found it to be '%s'", new Object[]{this.toString(current), expectedId, actualId})).isEqualTo((Object)expectedId);
        return this;
    }

    public JobAssert hasDueDate(Date expectedDueDate) {
        Job current = (Job)this.getExistingCurrent();
        Assertions.assertThat((Date)expectedDueDate).isNotNull();
        Date actualDuedate = current.getDuedate();
        ((AbstractDateAssert)Assertions.assertThat((Date)actualDuedate).overridingErrorMessage("Expecting %s to be due at '%s', but found it to be due at '%s'", new Object[]{this.toString(current), expectedDueDate, actualDuedate})).isEqualTo((Object)expectedDueDate);
        return this;
    }

    public JobAssert hasProcessInstanceId(String expectedProcessInstanceId) {
        Job current = (Job)this.getExistingCurrent();
        Assertions.assertThat((String)expectedProcessInstanceId).isNotNull();
        String actualProcessInstanceId = current.getProcessInstanceId();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualProcessInstanceId).overridingErrorMessage("Expecting %s to have process instance id '%s', but found it to be '%s'", new Object[]{this.toString(current), expectedProcessInstanceId, actualProcessInstanceId})).isEqualTo((Object)expectedProcessInstanceId);
        return this;
    }

    public JobAssert hasExecutionId(String expectedExecutionId) {
        Job current = (Job)this.getExistingCurrent();
        Assertions.assertThat((String)expectedExecutionId).isNotNull();
        String actualExecutionId = current.getExecutionId();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualExecutionId).overridingErrorMessage("Expecting %s to have execution id '%s', but found it to be '%s'", new Object[]{this.toString(current), expectedExecutionId, actualExecutionId})).isEqualTo((Object)expectedExecutionId);
        return this;
    }

    public JobAssert hasRetries(int expectedRetries) {
        Job current = (Job)this.getExistingCurrent();
        int actualRetries = current.getRetries();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualRetries).overridingErrorMessage("Expecting %s to have %s retries left, but found %s retries", new Object[]{this.toString(current), expectedRetries, actualRetries})).isEqualTo(expectedRetries);
        return this;
    }

    public JobAssert hasExceptionMessage() {
        Job current = (Job)this.getExistingCurrent();
        String actualExceptionMessage = current.getExceptionMessage();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualExceptionMessage).overridingErrorMessage("Expecting %s to have an exception message, but found it to be null or empty: '%s'", new Object[]{this.toString(current), actualExceptionMessage})).isNotEmpty();
        return this;
    }

    public JobAssert hasDeploymentId(String expectedDeploymentId) {
        Job current = (Job)this.getExistingCurrent();
        Assertions.assertThat((String)expectedDeploymentId).isNotNull();
        String actualDeploymentId = current.getDeploymentId();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualDeploymentId).overridingErrorMessage("Expecting %s to have deployment id '%s', but found it to be '%s'", new Object[]{this.toString(current), expectedDeploymentId, actualDeploymentId})).isEqualTo((Object)expectedDeploymentId);
        return this;
    }

    public JobAssert hasActivityId(String activityId) {
        Execution execution = (Execution)this.executionQuery().activityId(activityId).active().singleResult();
        Assertions.assertThat((String)activityId).isNotNull();
        String failureMessage = "Expecting %s to correspond to activity with id '%s', but did not find that to be true";
        ((AbstractObjectAssert)Assertions.assertThat((Object)execution).overridingErrorMessage(failureMessage, new Object[]{this.toString((Job)this.getExistingCurrent()), activityId})).isNotNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)execution.getId()).overridingErrorMessage(failureMessage, new Object[]{this.toString((Job)this.getExistingCurrent()), activityId})).isEqualTo((Object)((Job)this.actual).getExecutionId());
        return this;
    }

    @Override
    protected String toString(Job job) {
        return job != null ? String.format("%s {id='%s', processInstanceId='%s', executionId='%s'}", Job.class.getSimpleName(), job.getId(), job.getProcessInstanceId(), job.getExecutionId()) : null;
    }

    @Override
    protected JobQuery jobQuery() {
        return super.jobQuery().processInstanceId(((Job)this.actual).getProcessInstanceId());
    }

    @Override
    protected ExecutionQuery executionQuery() {
        return super.executionQuery().processInstanceId(((Job)this.actual).getProcessInstanceId());
    }
}

