/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.assertions.bpmn;

import java.util.Date;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractDateAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.assertions.bpmn.AbstractProcessAssert;

public class TaskAssert
extends AbstractProcessAssert<TaskAssert, Task> {
    protected TaskAssert(ProcessEngine engine, Task actual) {
        super(engine, actual, TaskAssert.class);
    }

    protected static TaskAssert assertThat(ProcessEngine engine, Task actual) {
        return new TaskAssert(engine, actual);
    }

    @Override
    protected Task getCurrent() {
        return (Task)this.taskQuery().taskId(((Task)this.actual).getId()).singleResult();
    }

    public TaskAssert isNotAssigned() {
        Task current = (Task)this.getExistingCurrent();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)current.getAssignee()).overridingErrorMessage("Expecting %s not to be assigned, but found it to be assigned to user '%s'!", new Object[]{this.toString(current), current.getAssignee()})).isNull();
        return this;
    }

    public TaskAssert isAssignedTo(String userId) {
        Task current = (Task)this.getExistingCurrent();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)current.getAssignee()).overridingErrorMessage("Expecting %s to be assigned to user '%s', but found it to be assigned to '%s'!", new Object[]{this.toString(current), userId, current.getAssignee()})).isEqualTo((Object)userId);
        return this;
    }

    public TaskAssert hasCandidateGroup(String candidateGroupId) {
        return this.hasCandidateGroup(candidateGroupId, true);
    }

    public TaskAssert hasCandidateGroupAssociated(String candidateGroupId) {
        return this.hasCandidateGroup(candidateGroupId, false);
    }

    private TaskAssert hasCandidateGroup(String candidateGroupId, boolean unassignedOnly) {
        Assertions.assertThat((String)candidateGroupId).isNotNull();
        Task current = (Task)this.getExistingCurrent();
        TaskQuery taskQuery = this.taskQuery().taskId(((Task)this.actual).getId()).taskCandidateGroup(candidateGroupId);
        if (unassignedOnly) {
            this.isNotAssigned();
        } else {
            taskQuery.includeAssignedTasks();
        }
        Task inGroup = (Task)taskQuery.singleResult();
        ((AbstractObjectAssert)Assertions.assertThat((Object)inGroup).overridingErrorMessage("Expecting %s to have candidate group '%s', but found it not to have that candidate group!", new Object[]{this.toString(current), candidateGroupId})).isNotNull();
        return this;
    }

    public TaskAssert hasCandidateUser(String candidateUserId) {
        return this.hasCandidateUser(candidateUserId, true);
    }

    public TaskAssert hasCandidateUserAssociated(String candidateUserId) {
        return this.hasCandidateUser(candidateUserId, false);
    }

    public TaskAssert hasCandidateUser(String candidateUserId, boolean unassignedOnly) {
        Assertions.assertThat((String)candidateUserId).isNotNull();
        Task current = (Task)this.getExistingCurrent();
        TaskQuery taskQuery = this.taskQuery().taskId(((Task)this.actual).getId()).taskCandidateUser(candidateUserId);
        if (unassignedOnly) {
            this.isNotAssigned();
        } else {
            taskQuery.includeAssignedTasks();
        }
        Task withUser = (Task)taskQuery.singleResult();
        ((AbstractObjectAssert)Assertions.assertThat((Object)withUser).overridingErrorMessage("Expecting %s to have candidate user '%s', but found it not to have that candidate user!", new Object[]{this.toString(current), candidateUserId})).isNotNull();
        return this;
    }

    public TaskAssert hasDueDate(Date dueDate) {
        Task current = (Task)this.getExistingCurrent();
        Assertions.assertThat((Date)dueDate).isNotNull();
        ((AbstractDateAssert)Assertions.assertThat((Date)current.getDueDate()).overridingErrorMessage("Expecting %s to be due at '%s', but found it to be due at '%s'!", new Object[]{this.toString(current), dueDate, current.getDueDate()})).isEqualTo((Object)dueDate);
        return this;
    }

    public TaskAssert hasDefinitionKey(String taskDefinitionKey) {
        Task current = (Task)this.getExistingCurrent();
        Assertions.assertThat((String)taskDefinitionKey).isNotNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)current.getTaskDefinitionKey()).overridingErrorMessage("Expecting %s to have definition key '%s', but found it to have '%s'!", new Object[]{this.toString(current), taskDefinitionKey, current.getTaskDefinitionKey()})).isEqualTo((Object)taskDefinitionKey);
        return this;
    }

    public TaskAssert hasFormKey(String formKey) {
        Task current = (Task)this.getExistingCurrent();
        String actualformKey = this.formService().getTaskFormKey(current.getProcessDefinitionId(), current.getTaskDefinitionKey());
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualformKey).overridingErrorMessage("Expecting %s to have a form key '%s', but found it to to have form key '%s'!", new Object[]{this.toString(current), formKey, actualformKey})).isEqualTo((Object)formKey);
        return this;
    }

    public TaskAssert hasId(String id) {
        Task current = (Task)this.getExistingCurrent();
        Assertions.assertThat((String)id).isNotNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)current.getId()).overridingErrorMessage("Expecting %s to have internal id '%s', but found it to be '%s'!", new Object[]{this.toString(current), id, current.getId()})).isEqualTo((Object)id);
        return this;
    }

    public TaskAssert hasName(String name) {
        Task current = (Task)this.getExistingCurrent();
        Assertions.assertThat((String)name).isNotNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)current.getName()).overridingErrorMessage("Expecting %s to have name '%s', but found it to be '%s'!", new Object[]{this.toString(current), name, current.getName()})).isEqualTo((Object)name);
        return this;
    }

    public TaskAssert hasDescription(String description) {
        Task current = (Task)this.getExistingCurrent();
        Assertions.assertThat((String)description).isNotNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)current.getDescription()).overridingErrorMessage("Expecting %s to have description '%s', but found it to be '%s'!", new Object[]{this.toString(current), description, current.getDescription()})).isEqualTo((Object)description);
        return this;
    }

    @Override
    protected String toString(Task task) {
        return task != null ? String.format("%s {id='%s', processInstanceId='%s', taskDefinitionKey='%s', name='%s'}", Task.class.getSimpleName(), task.getId(), task.getProcessInstanceId(), task.getTaskDefinitionKey(), task.getName()) : null;
    }

    @Override
    protected TaskQuery taskQuery() {
        return super.taskQuery().processInstanceId(((Task)this.actual).getProcessInstanceId());
    }
}

