/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.camunda.bpm.platform;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.camunda.bpm.platform.job_executor.JobAcquisitions;
import org.wildfly.swarm.config.camunda.bpm.platform.job_executor.JobAcquisitionsConsumer;
import org.wildfly.swarm.config.camunda.bpm.platform.job_executor.JobAcquisitionsSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=camunda-bpm-platform/job-executor=*")
@ResourceType(value="job-executor")
public class JobExecutor<T extends JobExecutor<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private JobExecutorResources subresources = new JobExecutorResources();
    @AttributeDocumentation(value="The core threads are also affected by keepalive timeout. Defaults to 'true'.")
    private Boolean allowCoreTimeout;
    @AttributeDocumentation(value="The minimal number of threads alive. Defaults to '3'.")
    private Integer coreThreads;
    @AttributeDocumentation(value="The max time an idle thread is kept alive. Defaults to '10' seconds. Unit is seconds.")
    private Integer keepaliveTime;
    @AttributeDocumentation(value="The max number of concurrently running threads. Defaults to '5'.")
    private Integer maxThreads;
    @AttributeDocumentation(value="The length of the thread pool queue. Defaults to '10'.")
    private Integer queueLength;
    @AttributeDocumentation(value="The name of the thread pool which is created as part of the job executor startup. Defaults to 'job-executor-tp'")
    private String threadPoolName;

    public JobExecutor(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public JobExecutorResources subresources() {
        return this.subresources;
    }

    public T jobAcquisitions(List<JobAcquisitions> value) {
        this.subresources.jobAcquisitions = value;
        return (T)this;
    }

    public T jobAcquisitions(JobAcquisitions value) {
        this.subresources.jobAcquisitions.add(value);
        return (T)this;
    }

    public T jobAcquisitions(String childKey, JobAcquisitionsConsumer consumer) {
        JobAcquisitions child = new JobAcquisitions(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.jobAcquisitions(child);
        return (T)this;
    }

    public T jobAcquisitions(String childKey) {
        this.jobAcquisitions(childKey, null);
        return (T)this;
    }

    public T jobAcquisitions(JobAcquisitionsSupplier supplier) {
        this.jobAcquisitions(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="allow-core-timeout")
    public Boolean allowCoreTimeout() {
        return this.allowCoreTimeout;
    }

    public T allowCoreTimeout(Boolean value) {
        Boolean oldValue = this.allowCoreTimeout;
        this.allowCoreTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("allowCoreTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="core-threads")
    public Integer coreThreads() {
        return this.coreThreads;
    }

    public T coreThreads(Integer value) {
        Integer oldValue = this.coreThreads;
        this.coreThreads = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("coreThreads", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="keepalive-time")
    public Integer keepaliveTime() {
        return this.keepaliveTime;
    }

    public T keepaliveTime(Integer value) {
        Integer oldValue = this.keepaliveTime;
        this.keepaliveTime = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("keepaliveTime", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-threads")
    public Integer maxThreads() {
        return this.maxThreads;
    }

    public T maxThreads(Integer value) {
        Integer oldValue = this.maxThreads;
        this.maxThreads = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxThreads", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="queue-length")
    public Integer queueLength() {
        return this.queueLength;
    }

    public T queueLength(Integer value) {
        Integer oldValue = this.queueLength;
        this.queueLength = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("queueLength", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="thread-pool-name")
    public String threadPoolName() {
        return this.threadPoolName;
    }

    public T threadPoolName(String value) {
        String oldValue = this.threadPoolName;
        this.threadPoolName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("threadPoolName", oldValue, value);
        }
        return (T)this;
    }

    public static class JobExecutorResources {
        @ResourceDocumentation(value="A job acquisition.")
        @SubresourceInfo(value="jobAcquisitions")
        private List<JobAcquisitions> jobAcquisitions = new ArrayList<JobAcquisitions>();

        @Subresource
        public List<JobAcquisitions> jobAcquisitions() {
            return this.jobAcquisitions;
        }

        public JobAcquisitions jobAcquisitions(String key) {
            return this.jobAcquisitions.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

