/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.camunda.bpm.platform;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=camunda-bpm-platform/process-engines=*")
@ResourceType(value="process-engines")
public class ProcessEngines<T extends ProcessEngines<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The process engine configuration class which should be used. Defaults to 'org.camunda.bpm.container.impl.jboss.config.ManagedJtaProcessEngineConfiguration'.")
    private String configuration;
    @AttributeDocumentation(value="The datasource which should be used for the process engine persistence.")
    private String datasource;
    @AttributeDocumentation(value="Marks the process engine as the default one. Only one process engine can be the default one.")
    private Boolean attributeDefault;
    @AttributeDocumentation(value="The history level used by the process engine. Defaults to 'audit'.")
    private String historyLevel;
    @AttributeDocumentation(value="The unique name of the process engine.")
    private String name;
    @AttributeDocumentation(value="Extend the process engine through various plugins.")
    private List<Map> plugins;
    @AttributeDocumentation(value="Customize the process engine through various properties.")
    private Map properties;

    public ProcessEngines(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="configuration")
    public String configuration() {
        return this.configuration;
    }

    public T configuration(String value) {
        String oldValue = this.configuration;
        this.configuration = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("configuration", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="datasource")
    public String datasource() {
        return this.datasource;
    }

    public T datasource(String value) {
        String oldValue = this.datasource;
        this.datasource = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("datasource", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default")
    public Boolean attributeDefault() {
        return this.attributeDefault;
    }

    public T attributeDefault(Boolean value) {
        Boolean oldValue = this.attributeDefault;
        this.attributeDefault = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("attributeDefault", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="history-level")
    public String historyLevel() {
        return this.historyLevel;
    }

    public T historyLevel(String value) {
        String oldValue = this.historyLevel;
        this.historyLevel = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("historyLevel", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="name")
    public String name() {
        return this.name;
    }

    public T name(String value) {
        String oldValue = this.name;
        this.name = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("name", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="plugins")
    public List<Map> plugins() {
        return this.plugins;
    }

    public T plugins(List<Map> value) {
        List<Map> oldValue = this.plugins;
        this.plugins = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("plugins", oldValue, value);
        }
        return (T)this;
    }

    public T plugin(Map value) {
        if (this.plugins == null) {
            this.plugins = new ArrayList<Map>();
        }
        this.plugins.add(value);
        return (T)this;
    }

    public T plugins(Map ... args) {
        this.plugins(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="properties")
    public Map properties() {
        return this.properties;
    }

    public T properties(Map value) {
        Map oldValue = this.properties;
        this.properties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("properties", oldValue, value);
        }
        return (T)this;
    }

    public T property(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(key, value);
        return (T)this;
    }
}

