/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.camunda.bpm.platform.JobExecutor;
import org.wildfly.swarm.config.camunda.bpm.platform.JobExecutorConsumer;
import org.wildfly.swarm.config.camunda.bpm.platform.JobExecutorSupplier;
import org.wildfly.swarm.config.camunda.bpm.platform.ProcessEngines;
import org.wildfly.swarm.config.camunda.bpm.platform.ProcessEnginesConsumer;
import org.wildfly.swarm.config.camunda.bpm.platform.ProcessEnginesSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=camunda-bpm-platform")
@ResourceType(value="subsystem")
@Implicit
public class CamundaBpmPlatform<T extends CamundaBpmPlatform<T>>
extends HashMap
implements Keyed {
    private String key = "camunda-bpm-platform";
    private PropertyChangeSupport pcs;
    private CamundaBpmPlatformResources subresources = new CamundaBpmPlatformResources();

    public CamundaBpmPlatform() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public CamundaBpmPlatformResources subresources() {
        return this.subresources;
    }

    public T jobExecutors(List<JobExecutor> value) {
        this.subresources.jobExecutors = value;
        return (T)this;
    }

    public T jobExecutor(JobExecutor value) {
        this.subresources.jobExecutors.add(value);
        return (T)this;
    }

    public T jobExecutor(String childKey, JobExecutorConsumer consumer) {
        JobExecutor child = new JobExecutor(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.jobExecutor(child);
        return (T)this;
    }

    public T jobExecutor(String childKey) {
        this.jobExecutor(childKey, null);
        return (T)this;
    }

    public T jobExecutor(JobExecutorSupplier supplier) {
        this.jobExecutor(supplier.get());
        return (T)this;
    }

    public T processEngines(List<ProcessEngines> value) {
        this.subresources.processEngines = value;
        return (T)this;
    }

    public T processEngines(ProcessEngines value) {
        this.subresources.processEngines.add(value);
        return (T)this;
    }

    public T processEngines(String childKey, ProcessEnginesConsumer consumer) {
        ProcessEngines child = new ProcessEngines(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.processEngines(child);
        return (T)this;
    }

    public T processEngines(String childKey) {
        this.processEngines(childKey, null);
        return (T)this;
    }

    public T processEngines(ProcessEnginesSupplier supplier) {
        this.processEngines(supplier.get());
        return (T)this;
    }

    public static class CamundaBpmPlatformResources {
        @ResourceDocumentation(value="Global job executor.")
        @SubresourceInfo(value="jobExecutor")
        private List<JobExecutor> jobExecutors = new ArrayList<JobExecutor>();
        @ResourceDocumentation(value="A process engine.")
        @SubresourceInfo(value="processEngines")
        private List<ProcessEngines> processEngines = new ArrayList<ProcessEngines>();

        @Subresource
        public List<JobExecutor> jobExecutors() {
            return this.jobExecutors;
        }

        public JobExecutor jobExecutor(String key) {
            return this.jobExecutors.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<ProcessEngines> processEngines() {
            return this.processEngines;
        }

        public ProcessEngines processEngines(String key) {
            return this.processEngines.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

