/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.camunda.bpm.rest.runtime;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.wildfly.swarm.bootstrap.env.ApplicationEnvironment;
import org.wildfly.swarm.bootstrap.env.FractionManifest;
import org.wildfly.swarm.spi.api.ArtifactLookup;

@ApplicationScoped
public class CamundaBpmRestProducer {
    public static final String MODULE = "org.wildfly.swarm.camunda.bpm.swarm.fraction.rest";
    @Inject
    ArtifactLookup lookup;

    @Produces
    Archive camundaBpmEngineRest() throws Exception {
        String deploymentName = "camunda-engine-rest.war";
        String group = "org.camunda.bpm";
        String artifact = "camunda-engine-rest";
        String classifier = "wildfly";
        String packaging = "war";
        String version = this.lookupVersion(group, artifact, packaging, classifier);
        String gav = group + ":" + artifact + ":" + packaging + ":" + classifier + ":" + version;
        JavaArchive deployment = this.lookup.artifact(gav, deploymentName);
        System.out.println("deployment " + deployment);
        return deployment;
    }

    private String lookupVersion(String group, String artifact, String packaging, String classifier) {
        FractionManifest fractionManifest = this.getFractionManifest();
        for (String dep : fractionManifest.getDependencies()) {
            String[] parts = dep.split(":");
            String depGroupId = parts[0];
            String depArtifactId = parts[1];
            String depPackaging = parts[2];
            String depVersion = null;
            String depClassifier = null;
            if (parts.length == 4) {
                depVersion = parts[3];
            } else {
                depClassifier = parts[3];
                depVersion = parts[4];
            }
            if (!group.equals(depGroupId) || !artifact.equals(depArtifactId) || !packaging.equals(depPackaging) || !classifier.equals(depClassifier)) continue;
            return depVersion;
        }
        throw new RuntimeException("Failed to lookup version.");
    }

    private FractionManifest getFractionManifest() {
        FractionManifest fractionManifest = ApplicationEnvironment.get().fractionManifests().stream().filter(mf -> MODULE.equals(mf.getModule())).findFirst().get();
        return fractionManifest;
    }
}

