/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cdi.test;

import jakarta.enterprise.inject.spi.BeanManager;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import org.camunda.bpm.BpmPlatform;
import org.camunda.bpm.container.RuntimeContainerDelegate;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.DecisionService;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.FilterService;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.cdi.BusinessProcess;
import org.camunda.bpm.engine.cdi.impl.util.ProgrammaticBeanLookup;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.util.LogUtil;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;

public abstract class CdiProcessEngineTestCase {
    protected Logger logger = Logger.getLogger(this.getClass().getName());
    @Rule
    public ProcessEngineRule processEngineRule = new ProcessEngineRule();
    protected BeanManager beanManager;
    protected ProcessEngine processEngine;
    protected FormService formService;
    protected HistoryService historyService;
    protected IdentityService identityService;
    protected ManagementService managementService;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected AuthorizationService authorizationService;
    protected FilterService filterService;
    protected ExternalTaskService externalTaskService;
    protected CaseService caseService;
    protected DecisionService decisionService;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addPackages(true, new String[]{"org.camunda.bpm.engine.cdi"})).addAsManifestResource("META-INF/beans.xml", "beans.xml");
    }

    @Before
    public void setUpCdiProcessEngineTestCase() throws Exception {
        if (BpmPlatform.getProcessEngineService().getDefaultProcessEngine() == null) {
            RuntimeContainerDelegate.INSTANCE.get().registerProcessEngine(this.processEngineRule.getProcessEngine());
        }
        this.beanManager = (BeanManager)ProgrammaticBeanLookup.lookup(BeanManager.class);
        this.processEngine = this.processEngineRule.getProcessEngine();
        this.processEngineConfiguration = (ProcessEngineConfigurationImpl)this.processEngineRule.getProcessEngine().getProcessEngineConfiguration();
        this.formService = this.processEngine.getFormService();
        this.historyService = this.processEngine.getHistoryService();
        this.identityService = this.processEngine.getIdentityService();
        this.managementService = this.processEngine.getManagementService();
        this.repositoryService = this.processEngine.getRepositoryService();
        this.runtimeService = this.processEngine.getRuntimeService();
        this.taskService = this.processEngine.getTaskService();
        this.authorizationService = this.processEngine.getAuthorizationService();
        this.filterService = this.processEngine.getFilterService();
        this.externalTaskService = this.processEngine.getExternalTaskService();
        this.caseService = this.processEngine.getCaseService();
        this.decisionService = this.processEngine.getDecisionService();
    }

    @After
    public void tearDownCdiProcessEngineTestCase() throws Exception {
        RuntimeContainerDelegate.INSTANCE.get().unregisterProcessEngine(this.processEngine);
        this.beanManager = null;
        this.processEngine = null;
        this.processEngineConfiguration = null;
        this.formService = null;
        this.historyService = null;
        this.identityService = null;
        this.managementService = null;
        this.repositoryService = null;
        this.runtimeService = null;
        this.taskService = null;
        this.authorizationService = null;
        this.filterService = null;
        this.externalTaskService = null;
        this.caseService = null;
        this.decisionService = null;
        this.processEngineRule = null;
    }

    protected void endConversationAndBeginNew(String processInstanceId) {
        this.getBeanInstance(BusinessProcess.class).associateExecutionById(processInstanceId);
    }

    protected <T> T getBeanInstance(Class<T> clazz) {
        return (T)ProgrammaticBeanLookup.lookup(clazz);
    }

    protected Object getBeanInstance(String name) {
        return ProgrammaticBeanLookup.lookup((String)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForJobExecutorToProcessAllJobs(long maxMillisToWait, long intervalMillis) {
        JobExecutor jobExecutor = this.processEngineConfiguration.getJobExecutor();
        jobExecutor.start();
        try {
            Timer timer = new Timer();
            InteruptTask task = new InteruptTask(Thread.currentThread());
            timer.schedule((TimerTask)task, maxMillisToWait);
            boolean areJobsAvailable = true;
            try {
                while (areJobsAvailable && !task.isTimeLimitExceeded()) {
                    Thread.sleep(intervalMillis);
                    areJobsAvailable = this.areJobsAvailable();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                timer.cancel();
            }
            if (areJobsAvailable) {
                throw new ProcessEngineException("time limit of " + maxMillisToWait + " was exceeded");
            }
        }
        finally {
            jobExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForJobExecutorOnCondition(long maxMillisToWait, long intervalMillis, Callable<Boolean> condition) {
        JobExecutor jobExecutor = this.processEngineConfiguration.getJobExecutor();
        jobExecutor.start();
        try {
            Timer timer = new Timer();
            InteruptTask task = new InteruptTask(Thread.currentThread());
            timer.schedule((TimerTask)task, maxMillisToWait);
            boolean conditionIsViolated = true;
            try {
                while (conditionIsViolated) {
                    Thread.sleep(intervalMillis);
                    conditionIsViolated = condition.call() == false;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                throw new ProcessEngineException("Exception while waiting on condition: " + e.getMessage(), (Throwable)e);
            }
            finally {
                timer.cancel();
            }
            if (conditionIsViolated) {
                throw new ProcessEngineException("time limit of " + maxMillisToWait + " was exceeded");
            }
        }
        finally {
            jobExecutor.shutdown();
        }
    }

    public boolean areJobsAvailable() {
        return !this.managementService.createJobQuery().executable().list().isEmpty();
    }

    static {
        LogUtil.readJavaUtilLoggingConfigFromClasspath();
    }

    private static class InteruptTask
    extends TimerTask {
        protected boolean timeLimitExceeded = false;
        protected Thread thread;

        public InteruptTask(Thread thread) {
            this.thread = thread;
        }

        public boolean isTimeLimitExceeded() {
            return this.timeLimitExceeded;
        }

        @Override
        public void run() {
            this.timeLimitExceeded = true;
            this.thread.interrupt();
        }
    }
}

