/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cdi.impl.context;

import jakarta.inject.Inject;
import java.util.Map;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.cdi.ProcessEngineCdiException;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.impl.VariableMapImpl;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class ScopedAssociation {
    @Inject
    private RuntimeService runtimeService;
    @Inject
    private TaskService taskService;
    protected VariableMap cachedVariables = new VariableMapImpl();
    protected VariableMap cachedVariablesLocal = new VariableMapImpl();
    protected Execution execution;
    protected Task task;

    public Execution getExecution() {
        return this.execution;
    }

    public void setExecution(Execution execution) {
        this.execution = execution;
    }

    public Task getTask() {
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public <T extends TypedValue> T getVariable(String variableName) {
        TypedValue value = this.cachedVariables.getValueTyped(variableName);
        if (value == null && this.execution != null) {
            value = this.runtimeService.getVariableTyped(this.execution.getId(), variableName);
            this.cachedVariables.put((Object)variableName, (Object)value);
        }
        return (T)value;
    }

    public void setVariable(String variableName, Object value) {
        this.cachedVariables.put((Object)variableName, value);
    }

    public VariableMap getCachedVariables() {
        return this.cachedVariables;
    }

    public <T extends TypedValue> T getVariableLocal(String variableName) {
        TypedValue value = this.cachedVariablesLocal.getValueTyped(variableName);
        if (value == null) {
            if (this.task != null) {
                value = this.taskService.getVariableLocalTyped(this.task.getId(), variableName);
                this.cachedVariablesLocal.put((Object)variableName, (Object)value);
            } else if (this.execution != null) {
                value = this.runtimeService.getVariableLocalTyped(this.execution.getId(), variableName);
                this.cachedVariablesLocal.put((Object)variableName, (Object)value);
            }
        }
        return (T)value;
    }

    public void setVariableLocal(String variableName, Object value) {
        if (this.execution == null && this.task == null) {
            throw new ProcessEngineCdiException("Cannot set a local cached variable: neither a Task nor an Execution is associated.");
        }
        this.cachedVariablesLocal.put((Object)variableName, value);
    }

    public VariableMap getCachedVariablesLocal() {
        return this.cachedVariablesLocal;
    }

    public void flushVariableCache() {
        if (this.task != null) {
            this.taskService.setVariablesLocal(this.task.getId(), (Map)this.cachedVariablesLocal);
            this.taskService.setVariables(this.task.getId(), (Map)this.cachedVariables);
        } else if (this.execution != null) {
            this.runtimeService.setVariablesLocal(this.execution.getId(), (Map)this.cachedVariablesLocal);
            this.runtimeService.setVariables(this.execution.getId(), (Map)this.cachedVariables);
        } else {
            throw new ProcessEngineCdiException("Cannot flush variable cache: neither a Task nor an Execution is associated.");
        }
        this.cachedVariables.clear();
        this.cachedVariablesLocal.clear();
    }
}

