/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cdi.impl;

import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.cdi.BusinessProcess;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.context.VariableContext;
import org.camunda.bpm.engine.variable.value.TypedValue;

abstract class AbstractVariableMap
implements VariableMap {
    @Inject
    protected BusinessProcess businessProcess;

    AbstractVariableMap() {
    }

    protected abstract Object getVariable(String var1);

    protected abstract <T extends TypedValue> T getVariableTyped(String var1);

    protected abstract void setVariable(String var1, Object var2);

    public Object get(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("This map does not support 'null' keys.");
        }
        return this.getVariable(key.toString());
    }

    public <T> T getValue(String name, Class<T> type) {
        Object object = this.get(name);
        if (object == null) {
            return null;
        }
        if (type.isAssignableFrom(object.getClass())) {
            return (T)object;
        }
        throw new ClassCastException("Cannot cast variable named '" + name + "' with value '" + object + "' to type '" + type + "'.");
    }

    public <T extends TypedValue> T getValueTyped(String name) {
        if (name == null) {
            throw new IllegalArgumentException("This map does not support 'null' keys.");
        }
        return this.getVariableTyped(name);
    }

    public Object put(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("This map does not support 'null' keys.");
        }
        Object variableBefore = this.getVariable(key);
        this.setVariable(key, value);
        return variableBefore;
    }

    public void putAll(Map<? extends String, ? extends Object> m) {
        for (Map.Entry<? extends String, ? extends Object> newEntry : m.entrySet()) {
            this.setVariable(newEntry.getKey(), newEntry.getValue());
        }
    }

    public VariableMap putValue(String name, Object value) {
        this.put(name, value);
        return this;
    }

    public VariableMap putValueTyped(String name, TypedValue value) {
        if (name == null) {
            throw new IllegalArgumentException("This map does not support 'null' names.");
        }
        this.setVariable(name, value);
        return this;
    }

    public int size() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".size() is not supported.");
    }

    public boolean isEmpty() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".isEmpty() is not supported.");
    }

    public boolean containsKey(Object key) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".containsKey() is not supported.");
    }

    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".containsValue() is not supported.");
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".remove is unsupported. Use " + this.getClass().getName() + ".put(key, null)");
    }

    public void clear() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".clear() is not supported.");
    }

    public Set<String> keySet() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".keySet() is not supported.");
    }

    public Collection<Object> values() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".values() is not supported.");
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".entrySet() is not supported.");
    }

    public VariableContext asVariableContext() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".asVariableContext() is not supported.");
    }
}

