/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cdi.impl.event;

import jakarta.enterprise.util.AnnotationLiteral;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.cdi.BusinessProcessEvent;
import org.camunda.bpm.engine.cdi.BusinessProcessEventType;
import org.camunda.bpm.engine.cdi.annotation.event.AssignTaskLiteral;
import org.camunda.bpm.engine.cdi.annotation.event.BusinessProcessDefinitionLiteral;
import org.camunda.bpm.engine.cdi.annotation.event.CompleteTaskLiteral;
import org.camunda.bpm.engine.cdi.annotation.event.CreateTaskLiteral;
import org.camunda.bpm.engine.cdi.annotation.event.DeleteTaskLiteral;
import org.camunda.bpm.engine.cdi.annotation.event.EndActivityLiteral;
import org.camunda.bpm.engine.cdi.annotation.event.StartActivityLiteral;
import org.camunda.bpm.engine.cdi.annotation.event.TakeTransitionLiteral;
import org.camunda.bpm.engine.cdi.impl.event.CdiBusinessProcessEvent;
import org.camunda.bpm.engine.cdi.impl.util.ProgrammaticBeanLookup;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.context.ExecutionContext;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public abstract class AbstractCdiEventListener
implements TaskListener,
ExecutionListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(AbstractCdiEventListener.class.getName());

    protected abstract void fireEvent(BusinessProcessEvent var1, Annotation[] var2);

    public void notify(DelegateExecution execution) throws Exception {
        if (!this.testCdiSetup()) {
            return;
        }
        BusinessProcessEvent event = this.createEvent(execution);
        Annotation[] qualifiers = this.getQualifiers(event);
        this.fireEvent(event, qualifiers);
    }

    public void notify(DelegateTask task) {
        if (!this.testCdiSetup()) {
            return;
        }
        BusinessProcessEvent event = this.createEvent(task);
        Annotation[] qualifiers = this.getQualifiers(event);
        this.fireEvent(event, qualifiers);
    }

    private boolean testCdiSetup() {
        try {
            ProgrammaticBeanLookup.lookup(ProcessEngine.class);
        }
        catch (Exception e) {
            LOGGER.fine("CDI was not setup correctly");
            return false;
        }
        return true;
    }

    protected BusinessProcessEvent createEvent(DelegateExecution execution) {
        ProcessDefinitionEntity processDefinition = Context.getExecutionContext().getProcessDefinition();
        String eventName = execution.getEventName();
        BusinessProcessEventType type = null;
        if ("start".equals(eventName)) {
            type = BusinessProcessEventType.START_ACTIVITY;
        } else if ("end".equals(eventName)) {
            type = BusinessProcessEventType.END_ACTIVITY;
        } else if ("take".equals(eventName)) {
            type = BusinessProcessEventType.TAKE;
        }
        return new CdiBusinessProcessEvent(execution.getCurrentActivityId(), execution.getCurrentTransitionId(), (ProcessDefinition)processDefinition, execution, type, ClockUtil.getCurrentTime());
    }

    protected BusinessProcessEvent createEvent(DelegateTask task) {
        ExecutionContext executionContext = Context.getExecutionContext();
        ProcessDefinitionEntity processDefinition = null;
        if (executionContext != null) {
            processDefinition = executionContext.getProcessDefinition();
        }
        String eventName = task.getEventName();
        BusinessProcessEventType type = null;
        if ("create".equals(eventName)) {
            type = BusinessProcessEventType.CREATE_TASK;
        } else if ("assignment".equals(eventName)) {
            type = BusinessProcessEventType.ASSIGN_TASK;
        } else if ("complete".equals(eventName)) {
            type = BusinessProcessEventType.COMPLETE_TASK;
        } else if ("update".equals(eventName)) {
            type = BusinessProcessEventType.UPDATE_TASK;
        } else if ("delete".equals(eventName)) {
            type = BusinessProcessEventType.DELETE_TASK;
        }
        return new CdiBusinessProcessEvent(task, processDefinition, type, ClockUtil.getCurrentTime());
    }

    protected Annotation[] getQualifiers(BusinessProcessEvent event) {
        ProcessDefinition processDefinition = event.getProcessDefinition();
        ArrayList<AnnotationLiteral> annotations = new ArrayList<AnnotationLiteral>();
        if (processDefinition != null) {
            annotations.add(new BusinessProcessDefinitionLiteral(processDefinition.getKey()));
        }
        if (event.getType() == BusinessProcessEventType.TAKE) {
            annotations.add(new TakeTransitionLiteral(event.getTransitionName()));
        } else if (event.getType() == BusinessProcessEventType.START_ACTIVITY) {
            annotations.add(new StartActivityLiteral(event.getActivityId()));
        } else if (event.getType() == BusinessProcessEventType.END_ACTIVITY) {
            annotations.add(new EndActivityLiteral(event.getActivityId()));
        } else if (event.getType() == BusinessProcessEventType.CREATE_TASK) {
            annotations.add(new CreateTaskLiteral(event.getTaskDefinitionKey()));
        } else if (event.getType() == BusinessProcessEventType.ASSIGN_TASK) {
            annotations.add(new AssignTaskLiteral(event.getTaskDefinitionKey()));
        } else if (event.getType() == BusinessProcessEventType.COMPLETE_TASK) {
            annotations.add(new CompleteTaskLiteral(event.getTaskDefinitionKey()));
        } else if (event.getType() == BusinessProcessEventType.DELETE_TASK) {
            annotations.add(new DeleteTaskLiteral(event.getTaskDefinitionKey()));
        }
        return annotations.toArray(new Annotation[annotations.size()]);
    }
}

