/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cdi.test.api.annotation;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.camunda.bpm.engine.cdi.BusinessProcess;
import org.camunda.bpm.engine.cdi.annotation.ExecutionIdLiteral;
import org.camunda.bpm.engine.cdi.test.CdiProcessEngineTestCase;
import org.camunda.bpm.engine.test.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class ExecutionIdTest
extends CdiProcessEngineTestCase {
    @Test
    @Deployment
    public void testExecutionIdInjectableByName() {
        this.getBeanInstance(BusinessProcess.class).startProcessByKey("keyOfTheProcess");
        String processInstanceId = (String)this.getBeanInstance("processInstanceId");
        Assert.assertNotNull((Object)processInstanceId);
        String executionId = (String)this.getBeanInstance("executionId");
        Assert.assertNotNull((Object)executionId);
        Assert.assertEquals((Object)processInstanceId, (Object)executionId);
    }

    @Test
    @Deployment
    public void testExecutionIdInjectableByQualifier() {
        this.getBeanInstance(BusinessProcess.class).startProcessByKey("keyOfTheProcess");
        Set beans = this.beanManager.getBeans(String.class, new Annotation[]{new ExecutionIdLiteral()});
        Bean bean = this.beanManager.resolve(beans);
        CreationalContext ctx = this.beanManager.createCreationalContext((Contextual)bean);
        String executionId = (String)this.beanManager.getReference(bean, String.class, ctx);
        Assert.assertNotNull((Object)executionId);
        String processInstanceId = (String)this.getBeanInstance("processInstanceId");
        Assert.assertNotNull((Object)processInstanceId);
        Assert.assertEquals((Object)processInstanceId, (Object)executionId);
    }
}

