/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cdi;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.Conversation;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.cdi.ProcessEngineCdiException;
import org.camunda.bpm.engine.cdi.impl.context.ContextAssociationManager;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;

@Named
public class BusinessProcess
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    private ProcessEngine processEngine;
    @Inject
    private ContextAssociationManager associationManager;
    @Inject
    private Instance<Conversation> conversationInstance;

    public ProcessInstance startProcessById(String processDefinitionId) {
        this.assertCommandContextNotActive();
        ProcessInstance instance = this.processEngine.getRuntimeService().startProcessInstanceById(processDefinitionId, this.getAndClearVariableCache());
        if (!instance.isEnded()) {
            this.setExecution((Execution)instance);
        }
        return instance;
    }

    public ProcessInstance startProcessById(String processDefinitionId, String businessKey) {
        this.assertCommandContextNotActive();
        ProcessInstance instance = this.processEngine.getRuntimeService().startProcessInstanceById(processDefinitionId, businessKey, this.getAndClearVariableCache());
        if (!instance.isEnded()) {
            this.setExecution((Execution)instance);
        }
        return instance;
    }

    public ProcessInstance startProcessById(String processDefinitionId, Map<String, Object> variables) {
        this.assertCommandContextNotActive();
        Map<String, Object> cachedVariables = this.getAndClearVariableCache();
        cachedVariables.putAll(variables);
        ProcessInstance instance = this.processEngine.getRuntimeService().startProcessInstanceById(processDefinitionId, cachedVariables);
        if (!instance.isEnded()) {
            this.setExecution((Execution)instance);
        }
        return instance;
    }

    public ProcessInstance startProcessById(String processDefinitionId, String businessKey, Map<String, Object> variables) {
        this.assertCommandContextNotActive();
        Map<String, Object> cachedVariables = this.getAndClearVariableCache();
        cachedVariables.putAll(variables);
        ProcessInstance instance = this.processEngine.getRuntimeService().startProcessInstanceById(processDefinitionId, businessKey, cachedVariables);
        if (!instance.isEnded()) {
            this.setExecution((Execution)instance);
        }
        return instance;
    }

    public ProcessInstance startProcessByKey(String key) {
        this.assertCommandContextNotActive();
        ProcessInstance instance = this.processEngine.getRuntimeService().startProcessInstanceByKey(key, this.getAndClearVariableCache());
        if (!instance.isEnded()) {
            this.setExecution((Execution)instance);
        }
        return instance;
    }

    public ProcessInstance startProcessByKey(String key, String businessKey) {
        this.assertCommandContextNotActive();
        ProcessInstance instance = this.processEngine.getRuntimeService().startProcessInstanceByKey(key, businessKey, this.getAndClearVariableCache());
        if (!instance.isEnded()) {
            this.setExecution((Execution)instance);
        }
        return instance;
    }

    public ProcessInstance startProcessByKey(String key, Map<String, Object> variables) {
        this.assertCommandContextNotActive();
        Map<String, Object> cachedVariables = this.getAndClearVariableCache();
        cachedVariables.putAll(variables);
        ProcessInstance instance = this.processEngine.getRuntimeService().startProcessInstanceByKey(key, cachedVariables);
        if (!instance.isEnded()) {
            this.setExecution((Execution)instance);
        }
        return instance;
    }

    public ProcessInstance startProcessByKey(String key, String businessKey, Map<String, Object> variables) {
        this.assertCommandContextNotActive();
        Map<String, Object> cachedVariables = this.getAndClearVariableCache();
        cachedVariables.putAll(variables);
        ProcessInstance instance = this.processEngine.getRuntimeService().startProcessInstanceByKey(key, businessKey, cachedVariables);
        if (!instance.isEnded()) {
            this.setExecution((Execution)instance);
        }
        return instance;
    }

    public ProcessInstance startProcessByMessage(String messageName) {
        this.assertCommandContextNotActive();
        Map<String, Object> cachedVariables = this.getAndClearVariableCache();
        ProcessInstance instance = this.processEngine.getRuntimeService().startProcessInstanceByMessage(messageName, cachedVariables);
        if (!instance.isEnded()) {
            this.setExecution((Execution)instance);
        }
        return instance;
    }

    public ProcessInstance startProcessByMessage(String messageName, Map<String, Object> processVariables) {
        this.assertCommandContextNotActive();
        Map<String, Object> cachedVariables = this.getAndClearVariableCache();
        cachedVariables.putAll(processVariables);
        ProcessInstance instance = this.processEngine.getRuntimeService().startProcessInstanceByMessage(messageName, cachedVariables);
        if (!instance.isEnded()) {
            this.setExecution((Execution)instance);
        }
        return instance;
    }

    public ProcessInstance startProcessByMessage(String messageName, String businessKey, Map<String, Object> processVariables) {
        this.assertCommandContextNotActive();
        Map<String, Object> cachedVariables = this.getAndClearVariableCache();
        cachedVariables.putAll(processVariables);
        ProcessInstance instance = this.processEngine.getRuntimeService().startProcessInstanceByMessage(messageName, businessKey, cachedVariables);
        if (!instance.isEnded()) {
            this.setExecution((Execution)instance);
        }
        return instance;
    }

    public void associateExecutionById(String executionId) {
        Execution execution = (Execution)this.processEngine.getRuntimeService().createExecutionQuery().executionId(executionId).singleResult();
        if (execution == null) {
            throw new ProcessEngineCdiException("Cannot associate execution by id: no execution with id '" + executionId + "' found.");
        }
        this.associationManager.setExecution(execution);
    }

    public boolean isAssociated() {
        return this.associationManager.getExecutionId() != null;
    }

    public void signalExecution() {
        this.assertExecutionAssociated();
        this.processEngine.getRuntimeService().setVariablesLocal(this.associationManager.getExecutionId(), this.getAndClearVariableLocalCache());
        this.processEngine.getRuntimeService().signal(this.associationManager.getExecutionId(), this.getAndClearVariableCache());
        this.associationManager.disAssociate();
    }

    public void signalExecution(boolean endConversation) {
        this.signalExecution();
        if (endConversation) {
            ((Conversation)this.conversationInstance.get()).end();
        }
    }

    public Task startTask(String taskId) {
        Task currentTask = this.associationManager.getTask();
        if (currentTask != null && currentTask.getId().equals(taskId)) {
            return currentTask;
        }
        Task task = (Task)this.processEngine.getTaskService().createTaskQuery().taskId(taskId).singleResult();
        if (task == null) {
            throw new ProcessEngineCdiException("Cannot resume task with id '" + taskId + "', no such task.");
        }
        this.associationManager.setTask(task);
        this.associateExecutionById(task.getExecutionId());
        return task;
    }

    public Task startTask(String taskId, boolean beginConversation) {
        Conversation conversation;
        if (beginConversation && (conversation = (Conversation)this.conversationInstance.get()).isTransient()) {
            conversation.begin();
        }
        return this.startTask(taskId);
    }

    public void completeTask() {
        this.assertTaskAssociated();
        this.processEngine.getTaskService().setVariablesLocal(this.getTask().getId(), this.getAndClearVariableLocalCache());
        this.processEngine.getTaskService().complete(this.getTask().getId(), this.getAndClearVariableCache());
        this.associationManager.disAssociate();
    }

    public void completeTask(boolean endConversation) {
        this.completeTask();
        if (endConversation) {
            ((Conversation)this.conversationInstance.get()).end();
        }
    }

    public boolean isTaskAssociated() {
        return this.associationManager.getTask() != null;
    }

    public void saveTask() {
        this.assertCommandContextNotActive();
        this.assertTaskAssociated();
        Task task = this.getTask();
        this.processEngine.getTaskService().saveTask(task);
    }

    public void stopTask() {
        this.assertCommandContextNotActive();
        this.assertTaskAssociated();
        this.associationManager.setTask(null);
    }

    public void stopTask(boolean endConversation) {
        this.stopTask();
        if (endConversation) {
            ((Conversation)this.conversationInstance.get()).end();
        }
    }

    public <T> T getVariable(String variableName) {
        Object variable = this.associationManager.getVariable(variableName);
        if (variable == null) {
            return null;
        }
        return (T)variable;
    }

    public void setVariable(String variableName, Object value) {
        this.associationManager.setVariable(variableName, value);
    }

    public Map<String, Object> getAndClearVariableCache() {
        Map<String, Object> cachedVariables = this.associationManager.getCachedVariables();
        HashMap<String, Object> copy = new HashMap<String, Object>(cachedVariables);
        cachedVariables.clear();
        return copy;
    }

    public Map<String, Object> getVariableCache() {
        return new HashMap<String, Object>(this.associationManager.getCachedVariables());
    }

    public <T> T getVariableLocal(String variableName) {
        Object variable = this.associationManager.getVariableLocal(variableName);
        if (variable == null) {
            return null;
        }
        return (T)variable;
    }

    public void setVariableLocal(String variableName, Object value) {
        this.associationManager.setVariableLocal(variableName, value);
    }

    public Map<String, Object> getAndClearVariableLocalCache() {
        Map<String, Object> cachedVariablesLocal = this.associationManager.getCachedVariablesLocal();
        HashMap<String, Object> copy = new HashMap<String, Object>(cachedVariablesLocal);
        cachedVariablesLocal.clear();
        return copy;
    }

    public Map<String, Object> getVariableLocalCache() {
        return new HashMap<String, Object>(this.associationManager.getCachedVariablesLocal());
    }

    public void flushVariableCache() {
        this.associationManager.flushVariableCache();
    }

    public void setTask(Task task) {
        this.startTask(task.getId());
    }

    public void setTaskId(String taskId) {
        this.startTask(taskId);
    }

    public void setExecution(Execution execution) {
        this.associateExecutionById(execution.getId());
    }

    protected void setExecutionId(String executionId) {
        this.associateExecutionById(executionId);
    }

    public String getProcessInstanceId() {
        Execution execution = this.associationManager.getExecution();
        return execution != null ? execution.getProcessInstanceId() : null;
    }

    public String getTaskId() {
        Task task = this.getTask();
        return task != null ? task.getId() : null;
    }

    public Task getTask() {
        return this.associationManager.getTask();
    }

    public Execution getExecution() {
        return this.associationManager.getExecution();
    }

    public String getExecutionId() {
        Execution e = this.getExecution();
        return e != null ? e.getId() : null;
    }

    public ProcessInstance getProcessInstance() {
        Execution execution = this.getExecution();
        if (execution != null && !execution.getProcessInstanceId().equals(execution.getId())) {
            return (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(execution.getProcessInstanceId()).singleResult();
        }
        return (ProcessInstance)execution;
    }

    protected void assertExecutionAssociated() {
        if (this.associationManager.getExecution() == null) {
            throw new ProcessEngineCdiException("No execution associated. Call busniessProcess.associateExecutionById() or businessProcess.startTask() first.");
        }
    }

    protected void assertTaskAssociated() {
        if (this.associationManager.getTask() == null) {
            throw new ProcessEngineCdiException("No task associated. Call businessProcess.startTask() first.");
        }
    }

    protected void assertCommandContextNotActive() {
        if (Context.getCommandContext() != null) {
            throw new ProcessEngineCdiException("Cannot use this method of the BusinessProcess bean from an active command context.");
        }
    }
}

