/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cdi.impl;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.camunda.bpm.engine.cdi.BusinessProcess;

public class ProcessVariableLocalMap
implements Map<String, Object> {
    @Inject
    private BusinessProcess businessProcess;

    @Override
    public Object get(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("This map does not support 'null' keys.");
        }
        return this.businessProcess.getVariableLocal(key.toString());
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("This map does not support 'null' keys.");
        }
        Object variableBefore = this.businessProcess.getVariableLocal(key);
        this.businessProcess.setVariableLocal(key, value);
        return variableBefore;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        for (Map.Entry<? extends String, ? extends Object> newEntry : m.entrySet()) {
            this.businessProcess.setVariableLocal(newEntry.getKey(), newEntry.getValue());
        }
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException(ProcessVariableLocalMap.class.getName() + ".size() is not supported.");
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException(ProcessVariableLocalMap.class.getName() + ".isEmpty() is not supported.");
    }

    @Override
    public boolean containsKey(Object key) {
        throw new UnsupportedOperationException(ProcessVariableLocalMap.class.getName() + ".containsKey() is not supported.");
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException(ProcessVariableLocalMap.class.getName() + ".containsValue() is not supported.");
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException(ProcessVariableLocalMap.class.getName() + ".remove() is unsupported. Use ProcessVariableMap.put(key, null)");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(ProcessVariableLocalMap.class.getName() + ".clear() is not supported.");
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException(ProcessVariableLocalMap.class.getName() + ".keySet() is not supported.");
    }

    @Override
    public Collection<Object> values() {
        throw new UnsupportedOperationException(ProcessVariableLocalMap.class.getName() + ".values() is not supported.");
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        throw new UnsupportedOperationException(ProcessVariableLocalMap.class.getName() + ".entrySet() is not supported.");
    }
}

