/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cdi.impl.context;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.cdi.ProcessEngineCdiException;
import org.camunda.bpm.engine.cdi.impl.context.ContextAssociationManager;
import org.camunda.bpm.engine.cdi.impl.util.ProgrammaticBeanLookup;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.context.ExecutionContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.task.Task;

public class DefaultContextAssociationManager
implements ContextAssociationManager,
Serializable {
    private static final Logger log = Logger.getLogger(DefaultContextAssociationManager.class.getName());
    @Inject
    private BeanManager beanManager;

    protected Class<? extends ScopedAssociation> getBroadestActiveContext() {
        for (Class<? extends ScopedAssociation> scopeType : this.getAvailableScopedAssociationClasses()) {
            Annotation scopeAnnotation;
            Annotation annotation = scopeAnnotation = scopeType.getAnnotations().length > 0 ? scopeType.getAnnotations()[0] : null;
            if (scopeAnnotation == null || !this.beanManager.isScope(scopeAnnotation.annotationType())) {
                throw new ProcessEngineException("ScopedAssociation must carry exactly one annotation and it must be a @Scope annotation");
            }
            try {
                this.beanManager.getContext(scopeAnnotation.annotationType());
                return scopeType;
            }
            catch (ContextNotActiveException e) {
                log.finest("Context " + scopeAnnotation.annotationType() + " not active.");
            }
        }
        throw new ProcessEngineException("Could not determine an active context to associate the current process instance / task instance with.");
    }

    protected List<Class<? extends ScopedAssociation>> getAvailableScopedAssociationClasses() {
        ArrayList<Class<? extends ScopedAssociation>> scopeTypes = new ArrayList<Class<? extends ScopedAssociation>>();
        scopeTypes.add(ConversationScopedAssociation.class);
        scopeTypes.add(RequestScopedAssociation.class);
        return scopeTypes;
    }

    protected ScopedAssociation getScopedAssociation() {
        return ProgrammaticBeanLookup.lookup(this.getBroadestActiveContext(), this.beanManager);
    }

    @Override
    public void setExecution(Execution execution) {
        if (execution == null) {
            throw new ProcessEngineCdiException("Cannot associate with execution: null");
        }
        this.ensureCommandContextNotActive();
        ScopedAssociation scopedAssociation = this.getScopedAssociation();
        Execution associatedExecution = scopedAssociation.getExecution();
        if (associatedExecution != null && !associatedExecution.getId().equals(execution.getId())) {
            throw new ProcessEngineCdiException("Cannot associate " + execution + ", already associated with " + associatedExecution + ". Disassociate first!");
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Associating " + execution + " (@" + scopedAssociation.getClass().getAnnotations()[0].annotationType().getSimpleName() + ")");
        }
        scopedAssociation.setExecution(execution);
    }

    @Override
    public void disAssociate() {
        this.ensureCommandContextNotActive();
        ScopedAssociation scopedAssociation = this.getScopedAssociation();
        if (scopedAssociation.getExecution() == null) {
            throw new ProcessEngineException("Cannot dissasociate execution, no " + scopedAssociation.getClass().getAnnotations()[0].annotationType().getSimpleName() + " execution associated. ");
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Disassociating");
        }
        scopedAssociation.setExecution(null);
        scopedAssociation.setTask(null);
    }

    @Override
    public String getExecutionId() {
        Execution execution = this.getExecution();
        if (execution != null) {
            return execution.getId();
        }
        return null;
    }

    @Override
    public Execution getExecution() {
        ExecutionEntity execution = this.getExecutionFromContext();
        if (execution != null) {
            return execution;
        }
        return this.getScopedAssociation().getExecution();
    }

    @Override
    public Object getVariable(String variableName) {
        ExecutionEntity execution = this.getExecutionFromContext();
        if (execution != null) {
            return execution.getVariable(variableName);
        }
        return this.getScopedAssociation().getVariable(variableName);
    }

    @Override
    public void setVariable(String variableName, Object value) {
        ExecutionEntity execution = this.getExecutionFromContext();
        if (execution != null) {
            execution.setVariable(variableName, value);
            execution.getVariable(variableName);
        } else {
            this.getScopedAssociation().setVariable(variableName, value);
        }
    }

    @Override
    public Object getVariableLocal(String variableName) {
        ExecutionEntity execution = this.getExecutionFromContext();
        if (execution != null) {
            return execution.getVariableLocal(variableName);
        }
        return this.getScopedAssociation().getVariableLocal(variableName);
    }

    @Override
    public void setVariableLocal(String variableName, Object value) {
        ExecutionEntity execution = this.getExecutionFromContext();
        if (execution != null) {
            execution.setVariableLocal(variableName, value);
            execution.getVariableLocal(variableName);
        } else {
            this.getScopedAssociation().setVariableLocal(variableName, value);
        }
    }

    protected ExecutionEntity getExecutionFromContext() {
        ExecutionContext executionContext;
        if (Context.getCommandContext() != null && (executionContext = Context.getExecutionContext()) != null) {
            return executionContext.getExecution();
        }
        return null;
    }

    @Override
    public Task getTask() {
        this.ensureCommandContextNotActive();
        return this.getScopedAssociation().getTask();
    }

    @Override
    public void setTask(Task task) {
        this.ensureCommandContextNotActive();
        this.getScopedAssociation().setTask(task);
    }

    @Override
    public Map<String, Object> getCachedVariables() {
        this.ensureCommandContextNotActive();
        return this.getScopedAssociation().getCachedVariables();
    }

    @Override
    public Map<String, Object> getCachedVariablesLocal() {
        this.ensureCommandContextNotActive();
        return this.getScopedAssociation().getCachedVariablesLocal();
    }

    @Override
    public void flushVariableCache() {
        this.ensureCommandContextNotActive();
        this.getScopedAssociation().flushVariableCache();
    }

    protected void ensureCommandContextNotActive() {
        if (Context.getCommandContext() != null) {
            throw new ProcessEngineCdiException("Cannot work with scoped associations inside command context.");
        }
    }

    @RequestScoped
    protected static class RequestScopedAssociation
    extends ScopedAssociation
    implements Serializable {
        protected RequestScopedAssociation() {
        }
    }

    @ConversationScoped
    protected static class ConversationScopedAssociation
    extends ScopedAssociation
    implements Serializable {
        protected ConversationScopedAssociation() {
        }
    }

    protected static class ScopedAssociation {
        @Inject
        private RuntimeService runtimeService;
        @Inject
        private TaskService taskService;
        protected Map<String, Object> cachedVariables = new HashMap<String, Object>();
        protected Map<String, Object> cachedVariablesLocal = new HashMap<String, Object>();
        protected Execution execution;
        protected Task task;

        protected ScopedAssociation() {
        }

        public Execution getExecution() {
            return this.execution;
        }

        public void setExecution(Execution execution) {
            this.execution = execution;
        }

        public Task getTask() {
            return this.task;
        }

        public void setTask(Task task) {
            this.task = task;
        }

        public <T> T getVariable(String variableName) {
            Object value = this.cachedVariables.get(variableName);
            if (value == null && this.execution != null) {
                value = this.runtimeService.getVariable(this.execution.getId(), variableName);
                this.cachedVariables.put(variableName, value);
            }
            return (T)value;
        }

        public void setVariable(String variableName, Object value) {
            this.cachedVariables.put(variableName, value);
        }

        public Map<String, Object> getCachedVariables() {
            return this.cachedVariables;
        }

        public <T> T getVariableLocal(String variableName) {
            Object value = this.cachedVariablesLocal.get(variableName);
            if (value == null && this.execution != null) {
                value = this.runtimeService.getVariableLocal(this.execution.getId(), variableName);
                this.cachedVariablesLocal.put(variableName, value);
            }
            return (T)value;
        }

        public void setVariableLocal(String variableName, Object value) {
            if (this.execution == null && this.task == null) {
                throw new ProcessEngineCdiException("Cannot set a local cached variable: neither a Task nor an Execution is associated.");
            }
            this.cachedVariablesLocal.put(variableName, value);
        }

        public Map<String, Object> getCachedVariablesLocal() {
            return this.cachedVariablesLocal;
        }

        public void flushVariableCache() {
            if (this.task != null) {
                this.taskService.setVariablesLocal(this.task.getId(), this.cachedVariablesLocal);
                this.taskService.setVariables(this.task.getId(), this.cachedVariables);
            } else if (this.execution != null) {
                this.runtimeService.setVariablesLocal(this.execution.getId(), this.cachedVariablesLocal);
                this.runtimeService.setVariables(this.execution.getId(), this.cachedVariables);
            } else {
                throw new ProcessEngineCdiException("Cannot flush variable cache: neither a Task nor an Execution is associated.");
            }
            this.cachedVariables.clear();
            this.cachedVariablesLocal.clear();
        }
    }
}

