/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cdi.impl.event;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.BeanManager;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.cdi.BusinessProcessEvent;
import org.camunda.bpm.engine.cdi.BusinessProcessEventType;
import org.camunda.bpm.engine.cdi.annotation.event.BusinessProcessDefinitionLiteral;
import org.camunda.bpm.engine.cdi.annotation.event.EndActivityLiteral;
import org.camunda.bpm.engine.cdi.annotation.event.StartActivityLiteral;
import org.camunda.bpm.engine.cdi.annotation.event.TakeTransitionLiteral;
import org.camunda.bpm.engine.cdi.impl.event.CdiBusinessProcessEvent;
import org.camunda.bpm.engine.cdi.impl.util.BeanManagerLookup;
import org.camunda.bpm.engine.cdi.impl.util.ProgrammaticBeanLookup;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class CdiExecutionListener
implements ExecutionListener,
Serializable {
    private static final long serialVersionUID = 1L;

    public void notify(DelegateExecution execution) throws Exception {
        try {
            ProgrammaticBeanLookup.lookup(ProcessEngine.class);
        }
        catch (Exception e) {
            return;
        }
        BusinessProcessEvent event = this.createEvent(execution);
        Annotation[] qualifiers = this.getQualifiers(event);
        this.getBeanManager().fireEvent((Object)event, qualifiers);
    }

    protected BusinessProcessEvent createEvent(DelegateExecution execution) {
        ProcessDefinitionEntity processDefinition = Context.getExecutionContext().getProcessDefinition();
        String eventName = execution.getEventName();
        BusinessProcessEventType type = null;
        if ("start".equals(eventName)) {
            type = BusinessProcessEventType.START_ACTIVITY;
        } else if ("end".equals(eventName)) {
            type = BusinessProcessEventType.END_ACTIVITY;
        } else if ("take".equals(eventName)) {
            type = BusinessProcessEventType.TAKE;
        }
        return new CdiBusinessProcessEvent(execution.getCurrentActivityId(), execution.getCurrentTransitionId(), (ProcessDefinition)processDefinition, execution, type, ClockUtil.getCurrentTime());
    }

    protected BeanManager getBeanManager() {
        BeanManager bm = BeanManagerLookup.getBeanManager();
        if (bm == null) {
            throw new ProcessEngineException("No cdi bean manager avaiable, cannot publish event.");
        }
        return bm;
    }

    protected Annotation[] getQualifiers(BusinessProcessEvent event) {
        BusinessProcessDefinitionLiteral businessProcessQualifier = new BusinessProcessDefinitionLiteral(event.getProcessDefinition().getKey());
        if (event.getType() == BusinessProcessEventType.TAKE) {
            return new Annotation[]{businessProcessQualifier, new TakeTransitionLiteral(event.getTransitionName())};
        }
        if (event.getType() == BusinessProcessEventType.START_ACTIVITY) {
            return new Annotation[]{businessProcessQualifier, new StartActivityLiteral(event.getActivityId())};
        }
        if (event.getType() == BusinessProcessEventType.END_ACTIVITY) {
            return new Annotation[]{businessProcessQualifier, new EndActivityLiteral(event.getActivityId())};
        }
        return new Annotation[0];
    }
}

