/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cdi.jsf;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.inject.Instance;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.cdi.BusinessProcess;
import org.camunda.bpm.engine.repository.ProcessDefinition;

@ConversationScoped
@Named(value="camunda.taskForm")
public class TaskForm
implements Serializable {
    private static Logger log = Logger.getLogger(TaskForm.class.getName());
    private static final long serialVersionUID = 1L;
    protected String url;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    @Inject
    protected BusinessProcess businessProcess;
    @Inject
    protected RepositoryService repositoryService;
    @Inject
    protected Instance<Conversation> conversationInstance;

    @Deprecated
    public void startTask(String taskId, String callbackUrl) {
        if (taskId == null || callbackUrl == null) {
            if (FacesContext.getCurrentInstance().isPostback()) {
                return;
            }
            log.log(Level.INFO, "Called startTask method without proper parameter (taskId='" + taskId + "'; callbackUrl='" + callbackUrl + "') even if it seems we are not called by an AJAX Postback. Are you using the camunda.taskForm bean correctly?");
            return;
        }
        this.url = callbackUrl;
        this.businessProcess.startTask(taskId, true);
    }

    public void startTaskForm() {
        Map requestParameterMap = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap();
        String taskId = (String)requestParameterMap.get("taskId");
        String callbackUrl = (String)requestParameterMap.get("callbackUrl");
        if (taskId == null || callbackUrl == null) {
            if (FacesContext.getCurrentInstance().isPostback()) {
                return;
            }
            log.log(Level.INFO, "Called startTask method without proper parameter (taskId='" + taskId + "'; callbackUrl='" + callbackUrl + "') even if it seems we are not called by an AJAX Postback. Are you using the camunda.taskForm bean correctly?");
            return;
        }
        this.url = callbackUrl;
        this.businessProcess.startTask(taskId, true);
    }

    public void completeTask() throws IOException {
        this.businessProcess.completeTask(true);
        FacesContext.getCurrentInstance().getExternalContext().redirect(this.url);
    }

    private void beginConversation() {
        if (((Conversation)this.conversationInstance.get()).isTransient()) {
            ((Conversation)this.conversationInstance.get()).begin();
        }
    }

    @Deprecated
    public void startProcessInstanceByIdForm(String processDefinitionId, String callbackUrl) {
        this.url = callbackUrl;
        this.processDefinitionId = processDefinitionId;
        this.beginConversation();
    }

    public void startProcessInstanceByIdForm() {
        String callbackUrl;
        if (FacesContext.getCurrentInstance().isPostback()) {
            return;
        }
        Map requestParameterMap = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap();
        String processDefinitionId = (String)requestParameterMap.get("processDefinitionId");
        this.url = callbackUrl = (String)requestParameterMap.get("callbackUrl");
        this.processDefinitionId = processDefinitionId;
        this.beginConversation();
    }

    @Deprecated
    public void startProcessInstanceByKeyForm(String processDefinitionKey, String callbackUrl) {
        this.url = callbackUrl;
        this.processDefinitionKey = processDefinitionKey;
        this.beginConversation();
    }

    public void startProcessInstanceByKeyForm() {
        String callbackUrl;
        if (FacesContext.getCurrentInstance().isPostback()) {
            return;
        }
        Map requestParameterMap = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap();
        String processDefinitionKey = (String)requestParameterMap.get("processDefinitionKey");
        this.url = callbackUrl = (String)requestParameterMap.get("callbackUrl");
        this.processDefinitionKey = processDefinitionKey;
        this.beginConversation();
    }

    public void completeProcessInstanceForm() throws IOException {
        if (this.processDefinitionId != null) {
            this.businessProcess.startProcessById(this.processDefinitionId);
            this.processDefinitionId = null;
        } else {
            this.businessProcess.startProcessByKey(this.processDefinitionKey);
            this.processDefinitionKey = null;
        }
        ((Conversation)this.conversationInstance.get()).end();
        FacesContext.getCurrentInstance().getExternalContext().redirect(this.url);
    }

    public ProcessDefinition getProcessDefinition() {
        if (this.processDefinitionId != null) {
            return (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(this.processDefinitionId).singleResult();
        }
        return (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(this.processDefinitionKey).latestVersion().singleResult();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

