/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cdi.impl.event;

import java.util.Date;
import org.camunda.bpm.engine.cdi.BusinessProcessEvent;
import org.camunda.bpm.engine.cdi.BusinessProcessEventType;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class CdiBusinessProcessEvent
implements BusinessProcessEvent {
    protected final String activityId;
    protected final ProcessDefinition processDefinition;
    protected final String transitionName;
    protected final String processInstanceId;
    protected final String executionId;
    protected final BusinessProcessEventType type;
    protected final Date timeStamp;

    public CdiBusinessProcessEvent(String activityId, String transitionName, ProcessDefinition processDefinition, DelegateExecution execution, BusinessProcessEventType type, Date timeStamp) {
        this.activityId = activityId;
        this.transitionName = transitionName;
        this.processInstanceId = execution.getProcessInstanceId();
        this.executionId = execution.getId();
        this.type = type;
        this.timeStamp = timeStamp;
        this.processDefinition = processDefinition;
    }

    @Override
    public ProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    @Override
    public String getActivityId() {
        return this.activityId;
    }

    @Override
    public String getTransitionName() {
        return this.transitionName;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    @Override
    public BusinessProcessEventType getType() {
        return this.type;
    }

    @Override
    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public String toString() {
        return "Event '" + this.processDefinition.getKey() + "' ['" + this.type + "', " + (this.type == BusinessProcessEventType.TAKE ? this.transitionName : this.activityId) + "]";
    }
}

