/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cdi.test.impl.util;

import org.camunda.bpm.BpmPlatform;
import org.camunda.bpm.container.RuntimeContainerDelegate;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.cdi.impl.util.ProgrammaticBeanLookup;
import org.camunda.bpm.engine.cdi.test.CdiProcessEngineTestCase;
import org.camunda.bpm.engine.cdi.test.impl.beans.InjectedProcessEngineBean;
import org.camunda.bpm.engine.impl.test.TestHelper;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class InjectDefaultProcessEngineTest
extends CdiProcessEngineTestCase {
    protected ProcessEngine defaultProcessEngine = null;
    protected ProcessEngine processEngine = null;

    @Before
    public void init() {
        this.processEngine = TestHelper.getProcessEngine((String)"activiti.cfg.xml");
        this.defaultProcessEngine = BpmPlatform.getProcessEngineService().getDefaultProcessEngine();
        if (this.defaultProcessEngine != null) {
            RuntimeContainerDelegate.INSTANCE.get().unregisterProcessEngine(this.defaultProcessEngine);
        }
        RuntimeContainerDelegate.INSTANCE.get().registerProcessEngine(this.processEngine);
    }

    @After
    public void tearDownCdiProcessEngineTestCase() {
        RuntimeContainerDelegate.INSTANCE.get().unregisterProcessEngine(this.processEngine);
        if (this.defaultProcessEngine != null) {
            RuntimeContainerDelegate.INSTANCE.get().registerProcessEngine(this.defaultProcessEngine);
        }
    }

    @Test
    public void testProcessEngineInject() {
        InjectedProcessEngineBean testClass = (InjectedProcessEngineBean)ProgrammaticBeanLookup.lookup(InjectedProcessEngineBean.class);
        Assert.assertNotNull((Object)testClass);
        Assert.assertEquals((Object)"default", (Object)testClass.processEngine.getName());
        Assert.assertTrue((boolean)testClass.processEngine.getProcessEngineConfiguration().getJdbcUrl().contains("default-process-engine"));
    }
}

