/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cdi.test.bpmn;

import java.util.HashMap;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.cdi.BusinessProcess;
import org.camunda.bpm.engine.cdi.test.CdiProcessEngineTestCase;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class SignalEventTest
extends CdiProcessEngineTestCase {
    @Test
    @Deployment(resources={"org/camunda/bpm/engine/cdi/test/bpmn/SignalEventTests.catchAlertSignalBoundaryWithReceiveTask.bpmn20.xml", "org/camunda/bpm/engine/cdi/test/bpmn/SignalEventTests.throwAlertSignalWithDelegate.bpmn20.xml"})
    public void testSignalCatchBoundaryWithVariables() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("processName", "catchSignal");
        ProcessInstance piCatchSignal = this.runtimeService.startProcessInstanceByKey("catchSignal", variables1);
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("processName", "throwSignal");
        variables2.put("signalProcessInstanceId", piCatchSignal.getProcessInstanceId());
        ProcessInstance piThrowSignal = this.runtimeService.startProcessInstanceByKey("throwSignal", variables2);
        Assert.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().processInstanceId(piCatchSignal.getProcessInstanceId()).activityId("receiveTask").count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().processInstanceId(piThrowSignal.getProcessInstanceId()).activityId("receiveTask").count());
        Assert.assertEquals((Object)"catchSignal-visited (was catchSignal)", (Object)this.runtimeService.getVariable(piCatchSignal.getId(), "processName"));
        Assert.assertEquals((Object)"throwSignal-visited (was throwSignal)", (Object)this.runtimeService.getVariable(piThrowSignal.getId(), "processName"));
        this.runtimeService.signal(piCatchSignal.getId());
        this.runtimeService.signal(piThrowSignal.getId());
    }

    @Named
    @Dependent
    public static class SendSignalDelegate
    implements JavaDelegate {
        @Inject
        private RuntimeService runtimeService;
        @Inject
        private BusinessProcess businessProcess;

        public void execute(DelegateExecution execution) throws Exception {
            this.businessProcess.setVariable("processName", (Object)("throwSignal-visited (was " + this.businessProcess.getVariable("processName") + ")"));
            String signalProcessInstanceId = (String)execution.getVariable("signalProcessInstanceId");
            String executionId = ((Execution)this.runtimeService.createExecutionQuery().processInstanceId(signalProcessInstanceId).signalEventSubscriptionName("alert").singleResult()).getId();
            this.runtimeService.signalEventReceived("alert", executionId);
        }
    }

    @Named
    @Dependent
    public static class SignalReceivedDelegate
    implements JavaDelegate {
        @Inject
        private BusinessProcess businessProcess;

        public void execute(DelegateExecution execution) {
            this.businessProcess.setVariable("processName", (Object)("catchSignal-visited (was " + this.businessProcess.getVariable("processName") + ")"));
        }
    }
}

