/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cdi.impl.util;

import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.camunda.bpm.engine.cdi.impl.util.BeanManagerLookup;
import org.camunda.bpm.engine.cdi.impl.util.CreationalContextReleaseListener;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandContextCloseListener;

public class ProgrammaticBeanLookup {
    public static final Logger LOG = Logger.getLogger(ProgrammaticBeanLookup.class.getName());

    public static <T> T lookup(Class<T> clazz, BeanManager bm) {
        return ProgrammaticBeanLookup.lookup(clazz, bm, true);
    }

    public static <T> T lookup(Class<T> clazz, BeanManager bm, boolean optional) {
        Set beans = bm.getBeans(clazz, new Annotation[0]);
        T instance = ProgrammaticBeanLookup.getContextualReference(bm, beans, clazz);
        if (!optional && instance == null) {
            throw new IllegalStateException("CDI BeanManager cannot find an instance of requested type '" + clazz.getName() + "'");
        }
        return instance;
    }

    public static Object lookup(String name, BeanManager bm) {
        return ProgrammaticBeanLookup.lookup(name, bm, true);
    }

    public static Object lookup(String name, BeanManager bm, boolean optional) {
        Set beans = bm.getBeans(name);
        Object instance = ProgrammaticBeanLookup.getContextualReference(bm, beans, Object.class);
        if (!optional && instance == null) {
            throw new IllegalStateException("CDI BeanManager cannot find an instance of requested type '" + name + "'");
        }
        return instance;
    }

    public static <T> T lookup(Class<T> clazz) {
        return ProgrammaticBeanLookup.lookup(clazz, true);
    }

    public static <T> T lookup(Class<T> clazz, boolean optional) {
        BeanManager bm = BeanManagerLookup.getBeanManager();
        return ProgrammaticBeanLookup.lookup(clazz, bm, optional);
    }

    public static Object lookup(String name) {
        BeanManager bm = BeanManagerLookup.getBeanManager();
        return ProgrammaticBeanLookup.lookup(name, bm);
    }

    private static <T> T getContextualReference(BeanManager bm, Set<Bean<?>> beans, Class<?> type) {
        if (beans == null || beans.size() == 0) {
            return null;
        }
        Bean bean = bm.resolve(beans);
        if (bean == null) {
            return null;
        }
        CreationalContext creationalContext = bm.createCreationalContext((Contextual)bean);
        if (ProgrammaticBeanLookup.isDependentScoped(bean)) {
            ProgrammaticBeanLookup.releaseOnContextClose(creationalContext, bean);
        }
        return (T)bm.getReference(bean, type, creationalContext);
    }

    private static boolean isDependentScoped(Bean<?> bean) {
        return Dependent.class.equals((Object)bean.getScope());
    }

    private static void releaseOnContextClose(CreationalContext<?> creationalContext, Bean<?> bean) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            commandContext.registerCommandContextCloseListener((CommandContextCloseListener)new CreationalContextReleaseListener(creationalContext));
        } else {
            LOG.warning("Obtained instance of @Dependent scoped bean " + bean + " outside of process engine command context. " + "Bean instance will not be destroyed. This is likely to create a memory leak. Please use a normal scope like @ApplicationScoped for this bean.");
        }
    }
}

