/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cdi.impl;

import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import org.camunda.bpm.BpmPlatform;
import org.camunda.bpm.ProcessEngineService;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.cdi.annotation.ProcessEngineName;

public class NamedProcessEngineServicesProducer {
    @Produces
    @ProcessEngineName(value="")
    public ProcessEngine processEngine(InjectionPoint ip) {
        ProcessEngineName annotation = (ProcessEngineName)ip.getAnnotated().getAnnotation(ProcessEngineName.class);
        String processEngineName = annotation.value();
        if (processEngineName == null || processEngineName.length() == 0) {
            throw new ProcessEngineException("Cannot determine which process engine to inject: @ProcessEngineName must specify the name of a process engine.");
        }
        try {
            ProcessEngineService processEngineService = BpmPlatform.getProcessEngineService();
            return processEngineService.getProcessEngine(processEngineName);
        }
        catch (Exception e) {
            throw new ProcessEngineException("Cannot find process engine named '" + processEngineName + "' specified using @ProcessEngineName: " + e.getMessage(), (Throwable)e);
        }
    }

    @Produces
    @ProcessEngineName(value="")
    public RuntimeService runtimeService(InjectionPoint ip) {
        return this.processEngine(ip).getRuntimeService();
    }

    @Produces
    @ProcessEngineName(value="")
    public TaskService taskService(InjectionPoint ip) {
        return this.processEngine(ip).getTaskService();
    }

    @Produces
    @ProcessEngineName(value="")
    public RepositoryService repositoryService(InjectionPoint ip) {
        return this.processEngine(ip).getRepositoryService();
    }

    @Produces
    @ProcessEngineName(value="")
    public FormService formService(InjectionPoint ip) {
        return this.processEngine(ip).getFormService();
    }

    @Produces
    @ProcessEngineName(value="")
    public HistoryService historyService(InjectionPoint ip) {
        return this.processEngine(ip).getHistoryService();
    }

    @Produces
    @ProcessEngineName(value="")
    public IdentityService identityService(InjectionPoint ip) {
        return this.processEngine(ip).getIdentityService();
    }

    @Produces
    @ProcessEngineName(value="")
    public ManagementService managementService(InjectionPoint ip) {
        return this.processEngine(ip).getManagementService();
    }
}

