/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cdi.impl.util;

import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.camunda.bpm.engine.ProcessEngineException;

public class BeanManagerLookup {
    public static BeanManager localInstance;
    public static String jndiName;

    public static BeanManager getBeanManager() {
        BeanManager beanManager = BeanManagerLookup.lookupBeanManagerInJndi();
        if (beanManager != null) {
            return beanManager;
        }
        if (localInstance != null) {
            return localInstance;
        }
        throw new ProcessEngineException("Could not lookup beanmanager in jndi. If no jndi is available, set the beanmanger to the 'localInstance' property of this class.");
    }

    private static BeanManager lookupBeanManagerInJndi() {
        if (jndiName != null) {
            try {
                return (BeanManager)InitialContext.doLookup(jndiName);
            }
            catch (NamingException e) {
                throw new ProcessEngineException("Could not lookup beanmanager in jndi using name: '" + jndiName + "'.", (Throwable)e);
            }
        }
        try {
            return (BeanManager)InitialContext.doLookup("java:comp/BeanManager");
        }
        catch (NamingException e) {
            try {
                return (BeanManager)InitialContext.doLookup("java:comp/env/BeanManager");
            }
            catch (NamingException namingException) {
                return null;
            }
        }
    }
}

