/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.batch.BatchDto;
import org.camunda.bpm.engine.rest.dto.runtime.ProcessInstanceDto;
import org.camunda.bpm.engine.rest.dto.runtime.ProcessInstanceQueryDto;
import org.camunda.bpm.engine.rest.dto.runtime.ProcessInstanceSuspensionStateAsyncDto;
import org.camunda.bpm.engine.rest.dto.runtime.ProcessInstanceSuspensionStateDto;
import org.camunda.bpm.engine.rest.dto.runtime.SetJobRetriesByProcessDto;
import org.camunda.bpm.engine.rest.dto.runtime.batch.CorrelationMessageAsyncDto;
import org.camunda.bpm.engine.rest.dto.runtime.batch.DeleteProcessInstancesDto;
import org.camunda.bpm.engine.rest.dto.runtime.batch.SetVariablesAsyncDto;
import org.camunda.bpm.engine.rest.sub.runtime.ProcessInstanceResource;

@Produces(value={"application/json"})
public interface ProcessInstanceRestService {
    public static final String PATH = "/process-instance";

    @Path(value="/{id}")
    public ProcessInstanceResource getProcessInstance(@PathParam(value="id") String var1);

    @GET
    @Produces(value={"application/json"})
    public List<ProcessInstanceDto> getProcessInstances(@Context UriInfo var1, @QueryParam(value="firstResult") Integer var2, @QueryParam(value="maxResults") Integer var3);

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<ProcessInstanceDto> queryProcessInstances(ProcessInstanceQueryDto var1, @QueryParam(value="firstResult") Integer var2, @QueryParam(value="maxResults") Integer var3);

    @GET
    @Path(value="/count")
    @Produces(value={"application/json"})
    public CountResultDto getProcessInstancesCount(@Context UriInfo var1);

    @POST
    @Path(value="/count")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CountResultDto queryProcessInstancesCount(ProcessInstanceQueryDto var1);

    @PUT
    @Path(value="/suspended")
    @Consumes(value={"application/json"})
    public void updateSuspensionState(ProcessInstanceSuspensionStateDto var1);

    @POST
    @Path(value="/suspended-async")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public BatchDto updateSuspensionStateAsync(ProcessInstanceSuspensionStateAsyncDto var1);

    @POST
    @Path(value="/delete")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public BatchDto deleteAsync(DeleteProcessInstancesDto var1);

    @POST
    @Path(value="/delete-historic-query-based")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public BatchDto deleteAsyncHistoricQueryBased(DeleteProcessInstancesDto var1);

    @POST
    @Path(value="/job-retries")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public BatchDto setRetriesByProcess(SetJobRetriesByProcessDto var1);

    @POST
    @Path(value="/job-retries-historic-query-based")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public BatchDto setRetriesByProcessHistoricQueryBased(SetJobRetriesByProcessDto var1);

    @POST
    @Path(value="/variables-async")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public BatchDto setVariablesAsync(SetVariablesAsyncDto var1);

    @POST
    @Path(value="/message-async")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public BatchDto correlateMessageAsync(CorrelationMessageAsyncDto var1);
}

