/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.batch;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.batch.BatchQuery;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.converter.BooleanConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringListConverter;

public class BatchQueryDto
extends AbstractQueryDto<BatchQuery> {
    private static final String SORT_BY_BATCH_ID_VALUE = "batchId";
    private static final String SORT_BY_TENANT_ID_VALUE = "tenantId";
    protected String batchId;
    protected String type;
    protected List<String> tenantIds;
    protected Boolean withoutTenantId;
    protected Boolean suspended;
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();

    public BatchQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="batchId")
    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    @CamundaQueryParam(value="type")
    public void setType(String type) {
        this.type = type;
    }

    @CamundaQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @CamundaQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    @CamundaQueryParam(value="suspended", converter=BooleanConverter.class)
    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected BatchQuery createNewQuery(ProcessEngine engine) {
        return engine.getManagementService().createBatchQuery();
    }

    @Override
    protected void applyFilters(BatchQuery query) {
        if (this.batchId != null) {
            query.batchId(this.batchId);
        }
        if (this.type != null) {
            query.type(this.type);
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
        if (Boolean.TRUE.equals(this.suspended)) {
            query.suspended();
        }
        if (Boolean.FALSE.equals(this.suspended)) {
            query.active();
        }
    }

    @Override
    protected void applySortBy(BatchQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_BATCH_ID_VALUE)) {
            query.orderById();
        } else if (sortBy.equals(SORT_BY_TENANT_ID_VALUE)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_BATCH_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID_VALUE);
    }
}

