/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.exception;

import jakarta.ws.rs.core.Response;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.camunda.bpm.engine.rest.exception.ExceptionHandlerHelper;
import org.camunda.commons.logging.BaseLogger;

public class ExceptionLogger
extends BaseLogger {
    public static final String PROJECT_CODE = "ENGINE-REST";
    public static final String REST_API = "org.camunda.bpm.engine.rest.exception";
    public static final ExceptionLogger REST_LOGGER = (ExceptionLogger)BaseLogger.createLogger(ExceptionLogger.class, (String)"ENGINE-REST", (String)"org.camunda.bpm.engine.rest.exception", (String)"HTTP");

    public void log(Throwable throwable) {
        Response.Status status = ExceptionHandlerHelper.getInstance().getStatus(throwable);
        int statusCode = status.getStatusCode();
        if (statusCode >= 500) {
            this.logWarn(String.valueOf(statusCode), this.getStackTrace(throwable), new Object[0]);
        } else {
            this.logDebug(String.valueOf(statusCode), this.getStackTrace(throwable), new Object[0]);
        }
    }

    protected String getStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }
}

