/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.rest.CaseInstanceRestService;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.runtime.CaseInstanceDto;
import org.camunda.bpm.engine.rest.dto.runtime.CaseInstanceQueryDto;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.rest.sub.runtime.CaseInstanceResource;
import org.camunda.bpm.engine.rest.sub.runtime.impl.CaseInstanceResourceImpl;
import org.camunda.bpm.engine.rest.util.QueryUtil;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.CaseInstanceQuery;

public class CaseInstanceRestServiceImpl
extends AbstractRestProcessEngineAware
implements CaseInstanceRestService {
    public CaseInstanceRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public CaseInstanceResource getCaseInstance(String caseInstanceId) {
        return new CaseInstanceResourceImpl(this.getProcessEngine(), caseInstanceId, this.getObjectMapper());
    }

    @Override
    public List<CaseInstanceDto> getCaseInstances(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        CaseInstanceQueryDto queryDto = new CaseInstanceQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryCaseInstances(queryDto, firstResult, maxResults);
    }

    @Override
    public List<CaseInstanceDto> queryCaseInstances(CaseInstanceQueryDto queryDto, Integer firstResult, Integer maxResults) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        CaseInstanceQuery query = (CaseInstanceQuery)queryDto.toQuery(engine);
        List<CaseInstance> matchingInstances = QueryUtil.list(query, firstResult, maxResults);
        ArrayList<CaseInstanceDto> instanceResults = new ArrayList<CaseInstanceDto>();
        for (CaseInstance instance : matchingInstances) {
            CaseInstanceDto resultInstance = CaseInstanceDto.fromCaseInstance(instance);
            instanceResults.add(resultInstance);
        }
        return instanceResults;
    }

    @Override
    public CountResultDto getCaseInstancesCount(UriInfo uriInfo) {
        CaseInstanceQueryDto queryDto = new CaseInstanceQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryCaseInstancesCount(queryDto);
    }

    @Override
    public CountResultDto queryCaseInstancesCount(CaseInstanceQueryDto queryDto) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        CaseInstanceQuery query = (CaseInstanceQuery)queryDto.toQuery(engine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

