/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricActivityInstanceQuery;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricActivityInstanceDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricActivityInstanceQueryDto;
import org.camunda.bpm.engine.rest.history.HistoricActivityInstanceRestService;
import org.camunda.bpm.engine.rest.sub.history.HistoricActivityInstanceResource;
import org.camunda.bpm.engine.rest.sub.history.impl.HistoricActivityInstanceResourceImpl;
import org.camunda.bpm.engine.rest.util.QueryUtil;

public class HistoricActivityInstanceRestServiceImpl
implements HistoricActivityInstanceRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public HistoricActivityInstanceRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    @Override
    public HistoricActivityInstanceResource getHistoricCaseInstance(String activityInstanceId) {
        return new HistoricActivityInstanceResourceImpl(this.processEngine, activityInstanceId);
    }

    @Override
    public List<HistoricActivityInstanceDto> getHistoricActivityInstances(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        HistoricActivityInstanceQueryDto queryHistoricActivityInstanceDto = new HistoricActivityInstanceQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryHistoricActivityInstances(queryHistoricActivityInstanceDto, firstResult, maxResults);
    }

    @Override
    public List<HistoricActivityInstanceDto> queryHistoricActivityInstances(HistoricActivityInstanceQueryDto queryDto, Integer firstResult, Integer maxResults) {
        queryDto.setObjectMapper(this.objectMapper);
        HistoricActivityInstanceQuery query = (HistoricActivityInstanceQuery)queryDto.toQuery(this.processEngine);
        List<HistoricActivityInstance> matchingHistoricActivityInstances = QueryUtil.list(query, firstResult, maxResults);
        ArrayList<HistoricActivityInstanceDto> historicActivityInstanceResults = new ArrayList<HistoricActivityInstanceDto>();
        for (HistoricActivityInstance historicActivityInstance : matchingHistoricActivityInstances) {
            HistoricActivityInstanceDto resultHistoricActivityInstance = new HistoricActivityInstanceDto();
            HistoricActivityInstanceDto.fromHistoricActivityInstance(resultHistoricActivityInstance, historicActivityInstance);
            historicActivityInstanceResults.add(resultHistoricActivityInstance);
        }
        return historicActivityInstanceResults;
    }

    @Override
    public CountResultDto getHistoricActivityInstancesCount(UriInfo uriInfo) {
        HistoricActivityInstanceQueryDto queryDto = new HistoricActivityInstanceQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryHistoricActivityInstancesCount(queryDto);
    }

    @Override
    public CountResultDto queryHistoricActivityInstancesCount(HistoricActivityInstanceQueryDto queryDto) {
        queryDto.setObjectMapper(this.objectMapper);
        HistoricActivityInstanceQuery query = (HistoricActivityInstanceQuery)queryDto.toQuery(this.processEngine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

