/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.history.impl;

import jakarta.ws.rs.core.Response;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.rest.dto.history.HistoricActivityInstanceDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.sub.history.HistoricActivityInstanceResource;

public class HistoricActivityInstanceResourceImpl
implements HistoricActivityInstanceResource {
    private ProcessEngine engine;
    private String activityInstanceId;

    public HistoricActivityInstanceResourceImpl(ProcessEngine engine, String activityInstanceId) {
        this.engine = engine;
        this.activityInstanceId = activityInstanceId;
    }

    @Override
    public HistoricActivityInstanceDto getHistoricActivityInstance() {
        HistoryService historyService = this.engine.getHistoryService();
        HistoricActivityInstance instance = (HistoricActivityInstance)historyService.createHistoricActivityInstanceQuery().activityInstanceId(this.activityInstanceId).singleResult();
        if (instance == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Historic activity instance with id '" + this.activityInstanceId + "' does not exist");
        }
        HistoricActivityInstanceDto historicActivityInstanceDto = new HistoricActivityInstanceDto();
        HistoricActivityInstanceDto.fromHistoricActivityInstance(historicActivityInstanceDto, instance);
        return historicActivityInstanceDto;
    }
}

