/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.impl;

import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.util.URLEncodingUtil;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.BytesValue;
import org.camunda.bpm.engine.variable.value.FileValue;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class VariableResponseProvider {
    public Response getResponseForTypedVariable(TypedValue typedVariableValue, String id) {
        if (typedVariableValue instanceof BytesValue || ValueType.BYTES.equals(typedVariableValue.getType())) {
            return this.responseForByteVariable(typedVariableValue);
        }
        if (ValueType.FILE.equals(typedVariableValue.getType())) {
            return this.responseForFileVariable((FileValue)typedVariableValue);
        }
        throw new InvalidRequestException(Response.Status.BAD_REQUEST, String.format("Value of variable with id %s is not a binary value.", id));
    }

    protected Response responseForFileVariable(FileValue fileValue) {
        String type;
        String string = type = fileValue.getMimeType() != null ? fileValue.getMimeType() : "application/octet-stream";
        if (fileValue.getEncoding() != null) {
            type = type + "; charset=" + fileValue.getEncoding();
        }
        Object value = fileValue.getValue() == null ? "" : fileValue.getValue();
        return Response.ok((Object)value, (String)type).header("Content-Disposition", (Object)URLEncodingUtil.buildAttachmentValue(fileValue.getFilename())).build();
    }

    protected Response responseForByteVariable(TypedValue variableInstance) {
        byte[] valueBytes = (byte[])variableInstance.getValue();
        if (valueBytes == null) {
            valueBytes = new byte[]{};
        }
        return Response.ok((Object)new ByteArrayInputStream(valueBytes), (String)"application/octet-stream").build();
    }
}

