/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.StatisticsResultDto;
import org.camunda.bpm.engine.rest.dto.repository.ProcessDefinitionDto;
import org.camunda.bpm.engine.rest.dto.repository.ProcessDefinitionSuspensionStateDto;
import org.camunda.bpm.engine.rest.sub.repository.ProcessDefinitionResource;

@Produces(value={"application/json"})
public interface ProcessDefinitionRestService {
    public static final String APPLICATION_BPMN20_XML = "application/bpmn20+xml";
    public static final MediaType APPLICATION_BPMN20_XML_TYPE = new MediaType("application", "bpmn20+xml");
    public static final String PATH = "/process-definition";

    @Path(value="/{id}")
    public ProcessDefinitionResource getProcessDefinitionById(@PathParam(value="id") String var1);

    @Path(value="/key/{key}")
    public ProcessDefinitionResource getProcessDefinitionByKey(@PathParam(value="key") String var1);

    @Path(value="/key/{key}/tenant-id/{tenantId}")
    public ProcessDefinitionResource getProcessDefinitionByKeyAndTenantId(@PathParam(value="key") String var1, @PathParam(value="tenantId") String var2);

    @GET
    @Produces(value={"application/json"})
    public List<ProcessDefinitionDto> getProcessDefinitions(@Context UriInfo var1, @QueryParam(value="firstResult") Integer var2, @QueryParam(value="maxResults") Integer var3);

    @GET
    @Path(value="/count")
    @Produces(value={"application/json"})
    public CountResultDto getProcessDefinitionsCount(@Context UriInfo var1);

    @GET
    @Path(value="/statistics")
    @Produces(value={"application/json"})
    public List<StatisticsResultDto> getStatistics(@QueryParam(value="failedJobs") Boolean var1, @QueryParam(value="rootIncidents") Boolean var2, @QueryParam(value="incidents") Boolean var3, @QueryParam(value="incidentsForType") String var4);

    @PUT
    @Path(value="/suspended")
    @Consumes(value={"application/json"})
    public void updateSuspensionState(ProcessDefinitionSuspensionStateDto var1);

    @DELETE
    @Path(value="/key/{key}/delete")
    public void deleteProcessDefinitionsByKey(@PathParam(value="key") String var1, @QueryParam(value="cascade") boolean var2, @QueryParam(value="skipCustomListeners") boolean var3, @QueryParam(value="skipIoMappings") boolean var4);

    @DELETE
    @Path(value="/key/{key}/tenant-id/{tenantId}/delete")
    public void deleteProcessDefinitionsByKeyAndTenantId(@PathParam(value="key") String var1, @QueryParam(value="cascade") boolean var2, @QueryParam(value="skipCustomListeners") boolean var3, @QueryParam(value="skipIoMappings") boolean var4, @PathParam(value="tenantId") String var5);
}

