/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.history.HistoricJobLogQuery;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricJobLogDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricJobLogQueryDto;
import org.camunda.bpm.engine.rest.history.HistoricJobLogRestService;
import org.camunda.bpm.engine.rest.sub.history.HistoricJobLogResource;
import org.camunda.bpm.engine.rest.sub.history.impl.HistoricJobLogResourceImpl;
import org.camunda.bpm.engine.rest.util.QueryUtil;

public class HistoricJobLogRestServiceImpl
implements HistoricJobLogRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public HistoricJobLogRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    @Override
    public HistoricJobLogResource getHistoricJobLog(String historicJobLogId) {
        return new HistoricJobLogResourceImpl(historicJobLogId, this.processEngine);
    }

    @Override
    public List<HistoricJobLogDto> getHistoricJobLogs(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        HistoricJobLogQueryDto queryDto = new HistoricJobLogQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryHistoricJobLogs(queryDto, firstResult, maxResults);
    }

    @Override
    public List<HistoricJobLogDto> queryHistoricJobLogs(HistoricJobLogQueryDto queryDto, Integer firstResult, Integer maxResults) {
        queryDto.setObjectMapper(this.objectMapper);
        HistoricJobLogQuery query = (HistoricJobLogQuery)queryDto.toQuery(this.processEngine);
        List<HistoricJobLog> matchingHistoricJobLogs = QueryUtil.list(query, firstResult, maxResults);
        ArrayList<HistoricJobLogDto> results = new ArrayList<HistoricJobLogDto>();
        for (HistoricJobLog historicJobLog : matchingHistoricJobLogs) {
            HistoricJobLogDto result = HistoricJobLogDto.fromHistoricJobLog(historicJobLog);
            results.add(result);
        }
        return results;
    }

    @Override
    public CountResultDto getHistoricJobLogsCount(UriInfo uriInfo) {
        HistoricJobLogQueryDto queryDto = new HistoricJobLogQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryHistoricJobLogsCount(queryDto);
    }

    @Override
    public CountResultDto queryHistoricJobLogsCount(HistoricJobLogQueryDto queryDto) {
        queryDto.setObjectMapper(this.objectMapper);
        HistoricJobLogQuery query = (HistoricJobLogQuery)queryDto.toQuery(this.processEngine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

