/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Map;
import org.camunda.bpm.engine.rest.dto.PatchVariablesDto;
import org.camunda.bpm.engine.rest.dto.VariableValueDto;
import org.camunda.bpm.engine.rest.mapper.MultipartFormData;

public interface VariableResource {
    public static final String DESERIALIZE_VALUE_QUERY_PARAM = "deserializeValue";
    public static final String DESERIALIZE_VALUES_QUERY_PARAM = "deserializeValues";

    @GET
    @Produces(value={"application/json"})
    public Map<String, VariableValueDto> getVariables(@QueryParam(value="deserializeValues") @DefaultValue(value="true") boolean var1);

    @GET
    @Path(value="/{varId}")
    @Produces(value={"application/json"})
    public VariableValueDto getVariable(@PathParam(value="varId") String var1, @QueryParam(value="deserializeValue") @DefaultValue(value="true") boolean var2);

    @GET
    @Path(value="/{varId}/data")
    public Response getVariableBinary(@PathParam(value="varId") String var1);

    @PUT
    @Path(value="/{varId}")
    @Consumes(value={"application/json"})
    public void putVariable(@PathParam(value="varId") String var1, VariableValueDto var2);

    @POST
    @Path(value="/{varId}/data")
    @Consumes(value={"multipart/form-data"})
    public void setBinaryVariable(@PathParam(value="varId") String var1, MultipartFormData var2);

    @DELETE
    @Path(value="/{varId}")
    public void deleteVariable(@PathParam(value="varId") String var1);

    @POST
    @Consumes(value={"application/json"})
    public void modifyVariables(PatchVariablesDto var1);
}

