/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.MismatchingMessageCorrelationException;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.rest.MessageRestService;
import org.camunda.bpm.engine.rest.dto.VariableValueDto;
import org.camunda.bpm.engine.rest.dto.message.CorrelationMessageDto;
import org.camunda.bpm.engine.rest.dto.message.MessageCorrelationResultDto;
import org.camunda.bpm.engine.rest.dto.message.MessageCorrelationResultWithVariableDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.runtime.MessageCorrelationBuilder;
import org.camunda.bpm.engine.runtime.MessageCorrelationResult;
import org.camunda.bpm.engine.runtime.MessageCorrelationResultWithVariables;
import org.camunda.bpm.engine.variable.VariableMap;

public class MessageRestServiceImpl
extends AbstractRestProcessEngineAware
implements MessageRestService {
    public MessageRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public Response deliverMessage(CorrelationMessageDto messageDto) {
        if (messageDto.getMessageName() == null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "No message name supplied");
        }
        if (messageDto.getTenantId() != null && messageDto.isWithoutTenantId()) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Parameter 'tenantId' cannot be used together with parameter 'withoutTenantId'.");
        }
        boolean variablesInResultEnabled = messageDto.isVariablesInResultEnabled();
        if (!messageDto.isResultEnabled() && variablesInResultEnabled) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Parameter 'variablesInResultEnabled' cannot be used without 'resultEnabled' set to true.");
        }
        ArrayList<MessageCorrelationResultDto> resultDtos = new ArrayList<MessageCorrelationResultDto>();
        try {
            MessageCorrelationBuilder correlation = this.createMessageCorrelationBuilder(messageDto);
            if (!variablesInResultEnabled) {
                resultDtos.addAll(this.correlate(messageDto, correlation));
            } else {
                resultDtos.addAll(this.correlateWithVariablesEnabled(messageDto, correlation));
            }
        }
        catch (RestException e) {
            String errorMessage = String.format("Cannot deliver message: %s", e.getMessage());
            throw new InvalidRequestException(e.getStatus(), e, errorMessage);
        }
        catch (MismatchingMessageCorrelationException e) {
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)((Object)e));
        }
        return this.createResponse(resultDtos, messageDto);
    }

    protected List<MessageCorrelationResultDto> correlate(CorrelationMessageDto messageDto, MessageCorrelationBuilder correlation) {
        ArrayList<MessageCorrelationResultDto> resultDtos = new ArrayList<MessageCorrelationResultDto>();
        if (!messageDto.isAll()) {
            MessageCorrelationResult result = correlation.correlateWithResult();
            resultDtos.add(MessageCorrelationResultDto.fromMessageCorrelationResult(result));
        } else {
            List results = correlation.correlateAllWithResult();
            for (MessageCorrelationResult result : results) {
                resultDtos.add(MessageCorrelationResultDto.fromMessageCorrelationResult(result));
            }
        }
        return resultDtos;
    }

    protected List<MessageCorrelationResultWithVariableDto> correlateWithVariablesEnabled(CorrelationMessageDto messageDto, MessageCorrelationBuilder correlation) {
        ArrayList<MessageCorrelationResultWithVariableDto> resultDtos = new ArrayList<MessageCorrelationResultWithVariableDto>();
        if (!messageDto.isAll()) {
            MessageCorrelationResultWithVariables result = correlation.correlateWithResultAndVariables(false);
            resultDtos.add(MessageCorrelationResultWithVariableDto.fromMessageCorrelationResultWithVariables(result));
        } else {
            List results = correlation.correlateAllWithResultAndVariables(false);
            for (MessageCorrelationResultWithVariables result : results) {
                resultDtos.add(MessageCorrelationResultWithVariableDto.fromMessageCorrelationResultWithVariables(result));
            }
        }
        return resultDtos;
    }

    protected Response createResponse(List<MessageCorrelationResultDto> resultDtos, CorrelationMessageDto messageDto) {
        Response.ResponseBuilder response = Response.noContent();
        if (messageDto.isResultEnabled()) {
            response = Response.ok(resultDtos, (String)"application/json");
        }
        return response.build();
    }

    protected MessageCorrelationBuilder createMessageCorrelationBuilder(CorrelationMessageDto messageDto) {
        Object value;
        String name;
        ProcessEngine processEngine = this.getProcessEngine();
        RuntimeService runtimeService = processEngine.getRuntimeService();
        ObjectMapper objectMapper = this.getObjectMapper();
        VariableMap correlationKeys = VariableValueDto.toMap(messageDto.getCorrelationKeys(), processEngine, objectMapper);
        VariableMap localCorrelationKeys = VariableValueDto.toMap(messageDto.getLocalCorrelationKeys(), processEngine, objectMapper);
        VariableMap processVariables = VariableValueDto.toMap(messageDto.getProcessVariables(), processEngine, objectMapper);
        VariableMap processVariablesLocal = VariableValueDto.toMap(messageDto.getProcessVariablesLocal(), processEngine, objectMapper);
        VariableMap processVariablesToTriggeredScope = VariableValueDto.toMap(messageDto.getProcessVariablesToTriggeredScope(), processEngine, objectMapper);
        MessageCorrelationBuilder builder = runtimeService.createMessageCorrelation(messageDto.getMessageName());
        if (processVariables != null) {
            builder.setVariables((Map)processVariables);
        }
        if (processVariablesLocal != null) {
            builder.setVariablesLocal((Map)processVariablesLocal);
        }
        if (processVariablesToTriggeredScope != null) {
            builder.setVariablesToTriggeredScope((Map)processVariablesToTriggeredScope);
        }
        if (messageDto.getBusinessKey() != null) {
            builder.processInstanceBusinessKey(messageDto.getBusinessKey());
        }
        if (correlationKeys != null && !correlationKeys.isEmpty()) {
            for (Map.Entry correlationKey : correlationKeys.entrySet()) {
                name = (String)correlationKey.getKey();
                value = correlationKey.getValue();
                builder.processInstanceVariableEquals(name, value);
            }
        }
        if (localCorrelationKeys != null && !localCorrelationKeys.isEmpty()) {
            for (Map.Entry correlationKey : localCorrelationKeys.entrySet()) {
                name = (String)correlationKey.getKey();
                value = correlationKey.getValue();
                builder.localVariableEquals(name, value);
            }
        }
        if (messageDto.getTenantId() != null) {
            builder.tenantId(messageDto.getTenantId());
        } else if (messageDto.isWithoutTenantId()) {
            builder.withoutTenantId();
        }
        String processInstanceId = messageDto.getProcessInstanceId();
        if (processInstanceId != null) {
            builder.processInstanceId(processInstanceId);
        }
        return builder;
    }
}

