/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.history.impl;

import jakarta.ws.rs.core.Response;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.rest.dto.history.HistoricDecisionInstanceDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.sub.history.HistoricDecisionInstanceResource;

public class HistoricDecisionInstanceResourceImpl
implements HistoricDecisionInstanceResource {
    private ProcessEngine engine;
    private String decisionInstanceId;

    public HistoricDecisionInstanceResourceImpl(ProcessEngine engine, String decisionInstanceId) {
        this.engine = engine;
        this.decisionInstanceId = decisionInstanceId;
    }

    @Override
    public HistoricDecisionInstanceDto getHistoricDecisionInstance(Boolean includeInputs, Boolean includeOutputs, Boolean disableBinaryFetching, Boolean disableCustomObjectDeserialization) {
        HistoricDecisionInstance instance;
        HistoryService historyService = this.engine.getHistoryService();
        HistoricDecisionInstanceQuery query = historyService.createHistoricDecisionInstanceQuery().decisionInstanceId(this.decisionInstanceId);
        if (includeInputs != null && includeInputs.booleanValue()) {
            query.includeInputs();
        }
        if (includeOutputs != null && includeOutputs.booleanValue()) {
            query.includeOutputs();
        }
        if (disableBinaryFetching != null && disableBinaryFetching.booleanValue()) {
            query.disableBinaryFetching();
        }
        if (disableCustomObjectDeserialization != null && disableCustomObjectDeserialization.booleanValue()) {
            query.disableCustomObjectDeserialization();
        }
        if ((instance = (HistoricDecisionInstance)query.singleResult()) == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Historic decision instance with id '" + this.decisionInstanceId + "' does not exist");
        }
        return HistoricDecisionInstanceDto.fromHistoricDecisionInstance(instance);
    }
}

