/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.task;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.rest.dto.VariableValueDto;
import org.camunda.bpm.engine.rest.dto.task.CompleteTaskDto;
import org.camunda.bpm.engine.rest.dto.task.FormDto;
import org.camunda.bpm.engine.rest.dto.task.IdentityLinkDto;
import org.camunda.bpm.engine.rest.dto.task.TaskBpmnErrorDto;
import org.camunda.bpm.engine.rest.dto.task.TaskDto;
import org.camunda.bpm.engine.rest.dto.task.TaskEscalationDto;
import org.camunda.bpm.engine.rest.dto.task.UserIdDto;
import org.camunda.bpm.engine.rest.sub.VariableResource;
import org.camunda.bpm.engine.rest.sub.task.TaskAttachmentResource;
import org.camunda.bpm.engine.rest.sub.task.TaskCommentResource;

public interface TaskResource {
    @GET
    @Produces(value={"application/json", "application/hal+json"})
    public Object getTask(@Context Request var1);

    @GET
    @Path(value="/form")
    @Produces(value={"application/json"})
    public FormDto getForm();

    @POST
    @Path(value="/submit-form")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response submit(CompleteTaskDto var1);

    @GET
    @Path(value="/rendered-form")
    @Produces(value={"application/xhtml+xml"})
    public Response getRenderedForm();

    @GET
    @Path(value="/deployed-form")
    public Response getDeployedForm();

    @POST
    @Path(value="/claim")
    @Consumes(value={"application/json"})
    public void claim(UserIdDto var1);

    @POST
    @Path(value="/unclaim")
    public void unclaim();

    @POST
    @Path(value="/complete")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response complete(CompleteTaskDto var1);

    @POST
    @Path(value="/resolve")
    @Consumes(value={"application/json"})
    public void resolve(CompleteTaskDto var1);

    @POST
    @Path(value="/delegate")
    @Consumes(value={"application/json"})
    public void delegate(UserIdDto var1);

    @POST
    @Path(value="/assignee")
    @Consumes(value={"application/json"})
    public void setAssignee(UserIdDto var1);

    @GET
    @Path(value="/identity-links")
    @Produces(value={"application/json"})
    public List<IdentityLinkDto> getIdentityLinks(@QueryParam(value="type") String var1);

    @POST
    @Path(value="/identity-links")
    @Consumes(value={"application/json"})
    public void addIdentityLink(IdentityLinkDto var1);

    @POST
    @Path(value="/identity-links/delete")
    @Consumes(value={"application/json"})
    public void deleteIdentityLink(IdentityLinkDto var1);

    @Path(value="/comment")
    public TaskCommentResource getTaskCommentResource();

    @Path(value="/attachment")
    public TaskAttachmentResource getAttachmentResource();

    @Path(value="/variables")
    public VariableResource getVariables();

    @Path(value="/localVariables")
    public VariableResource getLocalVariables();

    @GET
    @Path(value="/form-variables")
    @Produces(value={"application/json"})
    public Map<String, VariableValueDto> getFormVariables(@QueryParam(value="variableNames") String var1, @QueryParam(value="deserializeValues") @DefaultValue(value="true") boolean var2);

    @PUT
    @Consumes(value={"application/json"})
    public void updateTask(TaskDto var1);

    @DELETE
    public void deleteTask(@PathParam(value="id") String var1);

    @POST
    @Path(value="/bpmnError")
    @Consumes(value={"application/json"})
    public void handleBpmnError(TaskBpmnErrorDto var1);

    @POST
    @Path(value="/bpmnEscalation")
    @Consumes(value={"application/json"})
    public void handleEscalation(TaskEscalationDto var1);
}

