/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Map;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.rest.dto.VariableValueDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricDetailDto;

@JsonTypeName(value="variableUpdate")
public class HistoricVariableUpdateDto
extends HistoricDetailDto {
    protected String variableName;
    protected String variableInstanceId;
    protected String variableType;
    protected Object value;
    protected Map<String, Object> valueInfo;
    protected int revision;
    protected String errorMessage;

    public String getVariableName() {
        return this.variableName;
    }

    public String getVariableInstanceId() {
        return this.variableInstanceId;
    }

    public String getVariableType() {
        return this.variableType;
    }

    public Object getValue() {
        return this.value;
    }

    public int getRevision() {
        return this.revision;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Map<String, Object> getValueInfo() {
        return this.valueInfo;
    }

    public static HistoricVariableUpdateDto fromHistoricVariableUpdate(HistoricVariableUpdate historicVariableUpdate) {
        HistoricVariableUpdateDto dto = new HistoricVariableUpdateDto();
        HistoricVariableUpdateDto.fromHistoricVariableUpdate(dto, historicVariableUpdate);
        return dto;
    }

    protected static void fromHistoricVariableUpdate(HistoricVariableUpdateDto dto, HistoricVariableUpdate historicVariableUpdate) {
        dto.revision = historicVariableUpdate.getRevision();
        dto.variableName = historicVariableUpdate.getVariableName();
        dto.variableInstanceId = historicVariableUpdate.getVariableInstanceId();
        if (historicVariableUpdate.getErrorMessage() == null) {
            VariableValueDto variableValueDto = VariableValueDto.fromTypedValue(historicVariableUpdate.getTypedValue());
            dto.value = variableValueDto.getValue();
            dto.variableType = variableValueDto.getType();
            dto.valueInfo = variableValueDto.getValueInfo();
        } else {
            dto.errorMessage = historicVariableUpdate.getErrorMessage();
            dto.variableType = VariableValueDto.toRestApiTypeName(historicVariableUpdate.getTypeName());
        }
    }
}

