/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl.optimize;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.rest.dto.converter.DateConverter;
import org.camunda.bpm.engine.rest.dto.history.HistoricActivityInstanceDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricOptimizeVariableUpdateDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricProcessInstanceDto;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;

@Produces(value={"application/json"})
public class OptimizeRestService
extends AbstractRestProcessEngineAware {
    public static final String PATH = "/optimize";
    private DateConverter dateConverter = new DateConverter();

    public OptimizeRestService(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
        this.dateConverter.setObjectMapper(objectMapper);
    }

    @GET
    @Path(value="/activity-instance/completed")
    public List<HistoricActivityInstanceDto> getCompletedHistoricActivityInstances(@QueryParam(value="finishedAfter") String finishedAfterAsString, @QueryParam(value="finishedAt") String finishedAtAsString, @QueryParam(value="maxResults") int maxResults) {
        Date finishedAfter = this.dateConverter.convertQueryParameterToType(finishedAfterAsString);
        Date finishedAt = this.dateConverter.convertQueryParameterToType(finishedAtAsString);
        maxResults = this.ensureValidMaxResults(maxResults);
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)this.getProcessEngine().getProcessEngineConfiguration();
        List historicActivityInstances = config.getOptimizeService().getCompletedHistoricActivityInstances(finishedAfter, finishedAt, maxResults);
        ArrayList<HistoricActivityInstanceDto> result = new ArrayList<HistoricActivityInstanceDto>();
        for (HistoricActivityInstance instance : historicActivityInstances) {
            HistoricActivityInstanceDto dto = HistoricActivityInstanceDto.fromHistoricActivityInstance(instance);
            result.add(dto);
        }
        return result;
    }

    @GET
    @Path(value="/process-instance/completed")
    public List<HistoricProcessInstanceDto> getCompletedHistoricProcessInstances(@QueryParam(value="finishedAfter") String finishedAfterAsString, @QueryParam(value="finishedAt") String finishedAtAsString, @QueryParam(value="maxResults") int maxResults) {
        Date finishedAfter = this.dateConverter.convertQueryParameterToType(finishedAfterAsString);
        Date finishedAt = this.dateConverter.convertQueryParameterToType(finishedAtAsString);
        maxResults = this.ensureValidMaxResults(maxResults);
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)this.getProcessEngine().getProcessEngineConfiguration();
        List historicProcessInstances = config.getOptimizeService().getCompletedHistoricProcessInstances(finishedAfter, finishedAt, maxResults);
        ArrayList<HistoricProcessInstanceDto> result = new ArrayList<HistoricProcessInstanceDto>();
        for (HistoricProcessInstance instance : historicProcessInstances) {
            HistoricProcessInstanceDto dto = HistoricProcessInstanceDto.fromHistoricProcessInstance(instance);
            result.add(dto);
        }
        return result;
    }

    @GET
    @Path(value="/process-instance/running")
    public List<HistoricProcessInstanceDto> getRunningHistoricProcessInstances(@QueryParam(value="startedAfter") String startedAfterAsString, @QueryParam(value="startedAt") String startedAtAsString, @QueryParam(value="maxResults") int maxResults) {
        Date startedAfter = this.dateConverter.convertQueryParameterToType(startedAfterAsString);
        Date startedAt = this.dateConverter.convertQueryParameterToType(startedAtAsString);
        maxResults = this.ensureValidMaxResults(maxResults);
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)this.getProcessEngine().getProcessEngineConfiguration();
        List historicProcessInstances = config.getOptimizeService().getRunningHistoricProcessInstances(startedAfter, startedAt, maxResults);
        ArrayList<HistoricProcessInstanceDto> result = new ArrayList<HistoricProcessInstanceDto>();
        for (HistoricProcessInstance instance : historicProcessInstances) {
            HistoricProcessInstanceDto dto = HistoricProcessInstanceDto.fromHistoricProcessInstance(instance);
            result.add(dto);
        }
        return result;
    }

    @GET
    @Path(value="/variable-update")
    public List<HistoricOptimizeVariableUpdateDto> getHistoricVariableUpdates(@QueryParam(value="occurredAfter") String occurredAfterAsString, @QueryParam(value="occurredAt") String occurredAtAsString, @QueryParam(value="maxResults") int maxResults) {
        Date occurredAfter = this.dateConverter.convertQueryParameterToType(occurredAfterAsString);
        Date occurredAt = this.dateConverter.convertQueryParameterToType(occurredAtAsString);
        maxResults = this.ensureValidMaxResults(maxResults);
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)this.getProcessEngine().getProcessEngineConfiguration();
        List historicVariableUpdates = config.getOptimizeService().getHistoricVariableUpdates(occurredAfter, occurredAt, maxResults);
        ArrayList<HistoricOptimizeVariableUpdateDto> result = new ArrayList<HistoricOptimizeVariableUpdateDto>();
        for (HistoricVariableUpdate instance : historicVariableUpdates) {
            HistoricOptimizeVariableUpdateDto dto = HistoricOptimizeVariableUpdateDto.fromHistoricVariableUpdate(instance);
            result.add(dto);
        }
        return result;
    }

    protected int ensureValidMaxResults(int givenMaxResults) {
        return givenMaxResults > 0 ? givenMaxResults : Integer.MAX_VALUE;
    }
}

