/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.task.impl;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.rest.dto.converter.TaskReportResultToCsvConverter;
import org.camunda.bpm.engine.rest.dto.task.TaskCountByCandidateGroupResultDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.sub.task.TaskReportResource;
import org.camunda.bpm.engine.task.TaskCountByCandidateGroupResult;

public class TaskReportResourceImpl
implements TaskReportResource {
    public static final MediaType APPLICATION_CSV_TYPE = new MediaType("application", "csv");
    public static final MediaType TEXT_CSV_TYPE = new MediaType("text", "csv");
    public static final List<Variant> VARIANTS = Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON_TYPE, APPLICATION_CSV_TYPE, TEXT_CSV_TYPE}).add().build();
    protected ProcessEngine engine;

    public TaskReportResourceImpl(ProcessEngine engine) {
        this.engine = engine;
    }

    @Override
    public Response getTaskCountByCandidateGroupReport(Request request) {
        Variant variant = request.selectVariant(VARIANTS);
        if (variant != null) {
            MediaType mediaType = variant.getMediaType();
            if (MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType)) {
                List<TaskCountByCandidateGroupResultDto> result = this.getTaskCountByCandidateGroupResultAsJson();
                return Response.ok(result, (MediaType)mediaType).build();
            }
            if (APPLICATION_CSV_TYPE.equals((Object)mediaType) || TEXT_CSV_TYPE.equals((Object)mediaType)) {
                String csv = this.getReportResultAsCsv();
                return Response.ok((Object)csv, (MediaType)mediaType).header("Content-Disposition", (Object)"attachment; filename=task-count-by-candidate-group.csv").build();
            }
        }
        throw new InvalidRequestException(Response.Status.NOT_ACCEPTABLE, "No acceptable content-type found");
    }

    protected List<TaskCountByCandidateGroupResult> queryTaskCountByCandidateGroupReport() {
        TaskCountByCandidateGroupResultDto reportDto = new TaskCountByCandidateGroupResultDto();
        return reportDto.executeTaskCountByCandidateGroupReport(this.engine);
    }

    protected List<TaskCountByCandidateGroupResultDto> getTaskCountByCandidateGroupResultAsJson() {
        List<TaskCountByCandidateGroupResult> reports = this.queryTaskCountByCandidateGroupReport();
        ArrayList<TaskCountByCandidateGroupResultDto> result = new ArrayList<TaskCountByCandidateGroupResultDto>();
        for (TaskCountByCandidateGroupResult report : reports) {
            result.add(TaskCountByCandidateGroupResultDto.fromTaskCountByCandidateGroupResultDto(report));
        }
        return result;
    }

    protected String getReportResultAsCsv() {
        List<TaskCountByCandidateGroupResult> reports = this.queryTaskCountByCandidateGroupReport();
        return TaskReportResultToCsvConverter.convertCandidateGroupReportResult(reports);
    }
}

