/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.converter;

import java.util.ArrayList;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;

public class PermissionConverter {
    public static Permission[] getPermissionsForNames(String[] names) {
        Permission[] permissions = new Permission[names.length];
        for (int i = 0; i < names.length; ++i) {
            permissions[i] = PermissionConverter.getPermissionForName(names[i]);
        }
        return permissions;
    }

    public static String[] getNamesForPermissions(Authorization authorization, Permission[] permissions) {
        int type = authorization.getAuthorizationType();
        if ((type == 0 || type == 1) && authorization.isEveryPermissionGranted()) {
            return new String[]{Permissions.ALL.getName()};
        }
        if (type == 2 && authorization.isEveryPermissionRevoked()) {
            return new String[]{Permissions.ALL.getName()};
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Permission permission : permissions) {
            String name = permission.getName();
            if (name.equals(Permissions.NONE.getName()) || name.equals(Permissions.ALL.getName())) continue;
            names.add(name);
        }
        return names.toArray(new String[names.size()]);
    }

    public static Permission[] getAllPermissions() {
        return Permissions.values();
    }

    public static Permission getPermissionForName(String name) {
        return Permissions.forName((String)name);
    }
}

