/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.helper.variable.EqualsPrimitiveValue;
import org.camunda.bpm.engine.rest.util.OrderingBuilder;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseExecutionQuery;
import org.fest.assertions.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class CaseExecutionRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String CASE_EXECUTION_QUERY_URL = "/rest-test/case-execution";
    protected static final String CASE_EXECUTION_COUNT_QUERY_URL = "/rest-test/case-execution/count";
    private CaseExecutionQuery mockedQuery;

    @Before
    public void setUpRuntimeData() {
        this.mockedQuery = this.setUpMockCaseExecutionQuery(MockProvider.createMockCaseExecutions());
    }

    private CaseExecutionQuery setUpMockCaseExecutionQuery(List<CaseExecution> mockedCaseExecutions) {
        CaseExecutionQuery query = (CaseExecutionQuery)Mockito.mock(CaseExecutionQuery.class);
        Mockito.when((Object)processEngine.getCaseService().createCaseExecutionQuery()).thenReturn((Object)query);
        Mockito.when((Object)query.list()).thenReturn(mockedCaseExecutions);
        Mockito.when((Object)query.count()).thenReturn((Object)mockedCaseExecutions.size());
        return query;
    }

    @Test
    public void testEmptyQuery() {
        String queryCaseExecutionId = "";
        RestAssured.given().queryParam("caseExecutionId", new Object[]{queryCaseExecutionId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testEmptyQueryAsPost() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("caseExecutionId", "");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testNoParametersQuery() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testNoParametersQueryAsPost() {
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testInvalidSortingOptions() {
        this.executeAndVerifySorting("anInvalidSortByOption", "asc", Response.Status.BAD_REQUEST);
        this.executeAndVerifySorting("caseExecutionId", "anInvalidSortOrderOption", Response.Status.BAD_REQUEST);
    }

    protected void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(CASE_EXECUTION_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().queryParam("sortBy", new Object[]{"caseExecutionId"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(CASE_EXECUTION_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(CASE_EXECUTION_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortingParameters() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseExecutionId", "asc", Response.Status.OK);
        ((CaseExecutionQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseExecutionId();
        ((CaseExecutionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseDefinitionKey", "asc", Response.Status.OK);
        ((CaseExecutionQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseDefinitionKey();
        ((CaseExecutionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseDefinitionId", "asc", Response.Status.OK);
        ((CaseExecutionQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseDefinitionId();
        ((CaseExecutionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "asc", Response.Status.OK);
        ((CaseExecutionQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((CaseExecutionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseExecutionId", "desc", Response.Status.OK);
        ((CaseExecutionQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseExecutionId();
        ((CaseExecutionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseDefinitionKey", "desc", Response.Status.OK);
        ((CaseExecutionQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseDefinitionKey();
        ((CaseExecutionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseDefinitionId", "desc", Response.Status.OK);
        ((CaseExecutionQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseDefinitionId();
        ((CaseExecutionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "desc", Response.Status.OK);
        ((CaseExecutionQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((CaseExecutionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
    }

    @Test
    public void testSecondarySortingAsPost() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        HashMap<String, List<Map<String, Object>>> json = new HashMap<String, List<Map<String, Object>>>();
        json.put("sorting", OrderingBuilder.create().orderBy("caseExecutionId").desc().orderBy("caseDefinitionId").asc().getJson());
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseExecutionId();
        ((CaseExecutionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        ((CaseExecutionQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseDefinitionId();
        ((CaseExecutionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
    }

    @Test
    public void testSuccessfulPagination() {
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, maxResults);
    }

    @Test
    public void testMissingFirstResultParameter() {
        int maxResults = 10;
        RestAssured.given().queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).listPage(0, maxResults);
    }

    @Test
    public void testMissingMaxResultsParameter() {
        int firstResult = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, Integer.MAX_VALUE);
    }

    @Test
    public void testCaseExecutionRetrieval() {
        String queryCaseExecutionId = "aCaseExecutionId";
        Response response = (Response)RestAssured.given().queryParam("caseExecutionId", new Object[]{queryCaseExecutionId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_EXECUTION_QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((CaseExecutionQuery)inOrder.verify((Object)this.mockedQuery)).caseExecutionId(queryCaseExecutionId);
        ((CaseExecutionQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List caseExecutions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)caseExecutions).hasSize(1);
        Assertions.assertThat((Map)((Map)caseExecutions.get(0))).isNotNull();
        String returnedId = JsonPath.from((String)content).getString("[0].id");
        String returnedCaseInstanceId = JsonPath.from((String)content).getString("[0].caseInstanceId");
        String returnedParentId = JsonPath.from((String)content).getString("[0].parentId");
        String returnedCaseDefinitionId = JsonPath.from((String)content).getString("[0].caseDefinitionId");
        String returnedActivityId = JsonPath.from((String)content).getString("[0].activityId");
        String returnedActivityName = JsonPath.from((String)content).getString("[0].activityName");
        String returnedActivityType = JsonPath.from((String)content).getString("[0].activityType");
        String returnedActivityDescription = JsonPath.from((String)content).getString("[0].activityDescription");
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        boolean returnedRequired = JsonPath.from((String)content).getBoolean("[0].required");
        boolean returnedActiveState = JsonPath.from((String)content).getBoolean("[0].active");
        boolean returnedEnabledState = JsonPath.from((String)content).getBoolean("[0].enabled");
        boolean returnedDisabledState = JsonPath.from((String)content).getBoolean("[0].disabled");
        Assertions.assertThat((String)returnedId).isEqualTo((Object)"aCaseExecutionId");
        Assertions.assertThat((String)returnedCaseInstanceId).isEqualTo((Object)"aCaseInstanceId");
        Assertions.assertThat((String)returnedParentId).isEqualTo((Object)"aParentId");
        Assertions.assertThat((String)returnedCaseDefinitionId).isEqualTo((Object)"aCaseDefinitionId");
        Assertions.assertThat((String)returnedActivityId).isEqualTo((Object)"anActivityId");
        Assertions.assertThat((String)returnedActivityName).isEqualTo((Object)"anActivityName");
        Assertions.assertThat((String)returnedActivityType).isEqualTo((Object)"anActivityType");
        Assertions.assertThat((String)returnedActivityDescription).isEqualTo((Object)"anActivityDescription");
        Assertions.assertThat((String)returnedTenantId).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((boolean)returnedRequired).isEqualTo(true);
        Assertions.assertThat((boolean)returnedEnabledState).isEqualTo(true);
        Assertions.assertThat((boolean)returnedActiveState).isEqualTo(true);
        Assertions.assertThat((boolean)returnedDisabledState).isEqualTo(true);
    }

    @Test
    public void testCaseExecutionRetrievalAsPost() {
        String queryCaseExecutionId = "aCaseExecutionId";
        HashMap<String, String> queryParameter = new HashMap<String, String>();
        queryParameter.put("caseExecutionId", queryCaseExecutionId);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameter).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_EXECUTION_QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((CaseExecutionQuery)inOrder.verify((Object)this.mockedQuery)).caseExecutionId(queryCaseExecutionId);
        ((CaseExecutionQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List caseExecutions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)caseExecutions).hasSize(1);
        Assertions.assertThat((Map)((Map)caseExecutions.get(0))).isNotNull();
        String returnedId = JsonPath.from((String)content).getString("[0].id");
        String returnedCaseInstanceId = JsonPath.from((String)content).getString("[0].caseInstanceId");
        String returnedParentId = JsonPath.from((String)content).getString("[0].parentId");
        String returnedCaseDefinitionId = JsonPath.from((String)content).getString("[0].caseDefinitionId");
        String returnedActivityId = JsonPath.from((String)content).getString("[0].activityId");
        String returnedActivityName = JsonPath.from((String)content).getString("[0].activityName");
        String returnedActivityType = JsonPath.from((String)content).getString("[0].activityType");
        String returnedActivityDescription = JsonPath.from((String)content).getString("[0].activityDescription");
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        boolean returnedRequired = JsonPath.from((String)content).getBoolean("[0].required");
        boolean returnedActiveState = JsonPath.from((String)content).getBoolean("[0].active");
        boolean returnedEnabledState = JsonPath.from((String)content).getBoolean("[0].enabled");
        boolean returnedDisabledState = JsonPath.from((String)content).getBoolean("[0].disabled");
        Assertions.assertThat((String)returnedId).isEqualTo((Object)"aCaseExecutionId");
        Assertions.assertThat((String)returnedCaseInstanceId).isEqualTo((Object)"aCaseInstanceId");
        Assertions.assertThat((String)returnedParentId).isEqualTo((Object)"aParentId");
        Assertions.assertThat((String)returnedCaseDefinitionId).isEqualTo((Object)"aCaseDefinitionId");
        Assertions.assertThat((String)returnedActivityId).isEqualTo((Object)"anActivityId");
        Assertions.assertThat((String)returnedActivityName).isEqualTo((Object)"anActivityName");
        Assertions.assertThat((String)returnedActivityType).isEqualTo((Object)"anActivityType");
        Assertions.assertThat((String)returnedActivityDescription).isEqualTo((Object)"anActivityDescription");
        Assertions.assertThat((String)returnedTenantId).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((boolean)returnedRequired).isEqualTo(true);
        Assertions.assertThat((boolean)returnedEnabledState).isEqualTo(true);
        Assertions.assertThat((boolean)returnedActiveState).isEqualTo(true);
        Assertions.assertThat((boolean)returnedDisabledState).isEqualTo(true);
    }

    @Test
    public void testMultipleParameters() {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        queryParameters.put("caseExecutionId", "aCaseExecutionId");
        queryParameters.put("caseDefinitionKey", "aCaseDefId");
        queryParameters.put("caseDefinitionId", "aCaseDefId");
        queryParameters.put("caseInstanceId", "aCaseInstanceId");
        queryParameters.put("businessKey", "aBusinessKey");
        queryParameters.put("activityId", "anActivityId");
        queryParameters.put("tenantIdIn", "aTenantId");
        queryParameters.put("required", "true");
        queryParameters.put("active", "true");
        queryParameters.put("enabled", "true");
        queryParameters.put("disabled", "true");
        RestAssured.given().queryParams(queryParameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).caseExecutionId((String)queryParameters.get("caseExecutionId"));
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).caseDefinitionKey((String)queryParameters.get("caseDefinitionKey"));
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).caseDefinitionId((String)queryParameters.get("caseDefinitionId"));
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceId((String)queryParameters.get("caseInstanceId"));
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceBusinessKey((String)queryParameters.get("businessKey"));
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).activityId((String)queryParameters.get("activityId"));
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{(String)queryParameters.get("tenantIdIn")});
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).required();
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).active();
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).enabled();
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).disabled();
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testMultipleParametersAsPost() {
        String aCaseExecutionId = "aCaseExecutionId";
        String aCaseDefKey = "aCaseDefKey";
        String aCaseDefId = "aCaseDefId";
        String aCaseInstanceId = "aCaseInstanceId";
        String aBusinessKey = "aBusinessKey";
        String anActivityId = "anActivityId";
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        queryParameters.put("caseExecutionId", aCaseExecutionId);
        queryParameters.put("caseDefinitionKey", aCaseDefKey);
        queryParameters.put("caseDefinitionId", aCaseDefId);
        queryParameters.put("caseInstanceId", aCaseInstanceId);
        queryParameters.put("businessKey", aBusinessKey);
        queryParameters.put("activityId", anActivityId);
        queryParameters.put("required", "true");
        queryParameters.put("repeatable", "true");
        queryParameters.put("repetition", "true");
        queryParameters.put("active", "true");
        queryParameters.put("enabled", "true");
        queryParameters.put("disabled", "true");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).caseExecutionId(aCaseExecutionId);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).caseDefinitionKey(aCaseDefKey);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).caseDefinitionId(aCaseDefId);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceId(aCaseInstanceId);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceBusinessKey(aBusinessKey);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).activityId(anActivityId);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).required();
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).active();
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).enabled();
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).disabled();
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testCaseInstanceVariableParameters() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_eq_" + variableValue;
        RestAssured.given().queryParam("caseInstanceVariables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceVariableValueEquals(variableName, (Object)variableValue);
        queryValue = variableName + "_gt_" + variableValue;
        RestAssured.given().queryParam("caseInstanceVariables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceVariableValueGreaterThan(variableName, (Object)variableValue);
        queryValue = variableName + "_gteq_" + variableValue;
        RestAssured.given().queryParam("caseInstanceVariables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceVariableValueGreaterThanOrEqual(variableName, (Object)variableValue);
        queryValue = variableName + "_lt_" + variableValue;
        RestAssured.given().queryParam("caseInstanceVariables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceVariableValueLessThan(variableName, (Object)variableValue);
        queryValue = variableName + "_lteq_" + variableValue;
        RestAssured.given().queryParam("caseInstanceVariables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceVariableValueLessThanOrEqual(variableName, (Object)variableValue);
        queryValue = variableName + "_like_" + variableValue;
        RestAssured.given().queryParam("caseInstanceVariables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceVariableValueLike(variableName, variableValue);
        queryValue = variableName + "_neq_" + variableValue;
        RestAssured.given().queryParam("caseInstanceVariables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceVariableValueNotEquals(variableName, (Object)variableValue);
    }

    @Test
    public void testCaseInstanceVariableParametersAsPost() {
        String variableName = "varName";
        String variableValue = "varValue";
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", variableName);
        variableJson.put("operator", "eq");
        variableJson.put("value", variableValue);
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("caseInstanceVariables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceVariableValueEquals(variableName, (Object)variableValue);
        variableJson.put("operator", "gt");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceVariableValueGreaterThan(variableName, (Object)variableValue);
        variableJson.put("operator", "gteq");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceVariableValueGreaterThanOrEqual(variableName, (Object)variableValue);
        variableJson.put("operator", "lt");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceVariableValueLessThan(variableName, (Object)variableValue);
        variableJson.put("operator", "lteq");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceVariableValueLessThanOrEqual(variableName, (Object)variableValue);
        variableJson.put("operator", "like");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceVariableValueLike(variableName, variableValue);
        variableJson.put("operator", "neq");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceVariableValueNotEquals(variableName, (Object)variableValue);
    }

    @Test
    public void testMultipleCaseInstanceVariableParameters() {
        String variableName1 = "varName";
        String variableValue1 = "varValue";
        String variableParameter1 = variableName1 + "_eq_" + variableValue1;
        String variableName2 = "anotherVarName";
        String variableValue2 = "anotherVarValue";
        String variableParameter2 = variableName2 + "_neq_" + variableValue2;
        String queryValue = variableParameter1 + "," + variableParameter2;
        RestAssured.given().queryParam("caseInstanceVariables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceVariableValueEquals(variableName1, (Object)variableValue1);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceVariableValueNotEquals(variableName2, (Object)variableValue2);
    }

    @Test
    public void testMultipleCaseInstanceVariableParametersAsPost() {
        String variableName = "varName";
        String variableValue = "varValue";
        String anotherVariableName = "anotherVarName";
        Integer anotherVariableValue = 30;
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", variableName);
        variableJson.put("operator", "eq");
        variableJson.put("value", variableValue);
        HashMap<String, Object> anotherVariableJson = new HashMap<String, Object>();
        anotherVariableJson.put("name", anotherVariableName);
        anotherVariableJson.put("operator", "neq");
        anotherVariableJson.put("value", anotherVariableValue);
        ArrayList<HashMap<String, Object>> variables = new ArrayList<HashMap<String, Object>>();
        variables.add(variableJson);
        variables.add(anotherVariableJson);
        HashMap<String, ArrayList<HashMap<String, Object>>> json = new HashMap<String, ArrayList<HashMap<String, Object>>>();
        json.put("caseInstanceVariables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceVariableValueEquals(variableName, (Object)variableValue);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceVariableValueNotEquals((String)org.mockito.Matchers.eq((Object)anotherVariableName), org.mockito.Matchers.argThat((Matcher)EqualsPrimitiveValue.numberValue(anotherVariableValue)));
    }

    @Test
    public void testVariableParameters() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_eq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName, (Object)variableValue);
        queryValue = variableName + "_gt_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).variableValueGreaterThan(variableName, (Object)variableValue);
        queryValue = variableName + "_gteq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).variableValueGreaterThanOrEqual(variableName, (Object)variableValue);
        queryValue = variableName + "_lt_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLessThan(variableName, (Object)variableValue);
        queryValue = variableName + "_lteq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLessThanOrEqual(variableName, (Object)variableValue);
        queryValue = variableName + "_like_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLike(variableName, variableValue);
        queryValue = variableName + "_neq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals(variableName, (Object)variableValue);
    }

    @Test
    public void testVariableParametersAsPost() {
        String variableName = "varName";
        String variableValue = "varValue";
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", variableName);
        variableJson.put("operator", "eq");
        variableJson.put("value", variableValue);
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName, (Object)variableValue);
        variableJson.put("operator", "gt");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).variableValueGreaterThan(variableName, (Object)variableValue);
        variableJson.put("operator", "gteq");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).variableValueGreaterThanOrEqual(variableName, (Object)variableValue);
        variableJson.put("operator", "lt");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLessThan(variableName, (Object)variableValue);
        variableJson.put("operator", "lteq");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLessThanOrEqual(variableName, (Object)variableValue);
        variableJson.put("operator", "like");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLike(variableName, variableValue);
        variableJson.put("operator", "neq");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals(variableName, (Object)variableValue);
    }

    @Test
    public void testMultipleVariableParameters() {
        String variableName1 = "varName";
        String variableValue1 = "varValue";
        String variableParameter1 = variableName1 + "_eq_" + variableValue1;
        String variableName2 = "anotherVarName";
        String variableValue2 = "anotherVarValue";
        String variableParameter2 = variableName2 + "_neq_" + variableValue2;
        String queryValue = variableParameter1 + "," + variableParameter2;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName1, (Object)variableValue1);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals(variableName2, (Object)variableValue2);
    }

    @Test
    public void testMultipleVariableParametersAsPost() {
        String variableName = "varName";
        String variableValue = "varValue";
        String anotherVariableName = "anotherVarName";
        Integer anotherVariableValue = 30;
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", variableName);
        variableJson.put("operator", "eq");
        variableJson.put("value", variableValue);
        HashMap<String, Object> anotherVariableJson = new HashMap<String, Object>();
        anotherVariableJson.put("name", anotherVariableName);
        anotherVariableJson.put("operator", "neq");
        anotherVariableJson.put("value", anotherVariableValue);
        ArrayList<HashMap<String, Object>> variables = new ArrayList<HashMap<String, Object>>();
        variables.add(variableJson);
        variables.add(anotherVariableJson);
        HashMap<String, ArrayList<HashMap<String, Object>>> json = new HashMap<String, ArrayList<HashMap<String, Object>>>();
        json.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName, (Object)variableValue);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals((String)org.mockito.Matchers.eq((Object)anotherVariableName), org.mockito.Matchers.argThat((Matcher)EqualsPrimitiveValue.numberValue(anotherVariableValue)));
    }

    @Test
    public void testQueryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(CASE_EXECUTION_COUNT_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    @Test
    public void testQueryCountAsPost() {
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().post(CASE_EXECUTION_COUNT_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    @Test
    public void testTenantIdListParameter() {
        this.mockedQuery = this.setUpMockCaseExecutionQuery(this.createMockCaseExecutionsTwoTenants());
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId,anotherTenantId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List caseExecutions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)caseExecutions).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testTenantIdListPostParameter() {
        this.mockedQuery = this.setUpMockCaseExecutionQuery(this.createMockCaseExecutionsTwoTenants());
        HashMap<String, String[]> queryParameters = new HashMap<String, String[]>();
        queryParameters.put("tenantIdIn", "aTenantId,anotherTenantId".split(","));
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_EXECUTION_QUERY_URL, new Object[0]);
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((CaseExecutionQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List caseExecutions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)caseExecutions).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    private List<CaseExecution> createMockCaseExecutionsTwoTenants() {
        return Arrays.asList(MockProvider.createMockCaseExecution("aTenantId"), MockProvider.createMockCaseExecution("anotherTenantId"));
    }
}

