/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.impl.RuntimeServiceImpl;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.helper.variable.EqualsPrimitiveValue;
import org.camunda.bpm.engine.rest.util.VariablesBuilder;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.variable.Variables;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class CustomJacksonDateFormatTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String PROCESS_INSTANCE_URL = "/rest-test/process-instance";
    protected static final String SINGLE_PROCESS_INSTANCE_URL = "/rest-test/process-instance/{id}";
    protected static final String PROCESS_INSTANCE_VARIABLES_URL = "/rest-test/process-instance/{id}/variables";
    protected static final String SINGLE_PROCESS_INSTANCE_VARIABLE_URL = "/rest-test/process-instance/{id}/variables/{varId}";
    protected static final SimpleDateFormat testDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    protected static final Date testDate = new Date(1450282812000L);
    protected static final String testDateFormatted = testDateFormat.format(testDate);
    protected RuntimeServiceImpl runtimeServiceMock;

    @Before
    public void setUpRuntimeData() {
        this.runtimeServiceMock = (RuntimeServiceImpl)Mockito.mock(RuntimeServiceImpl.class);
        Mockito.when((Object)this.runtimeServiceMock.getVariableTyped((String)Matchers.eq((Object)"aProcessInstanceId"), (String)Matchers.eq((Object)"aVariableKey"), Matchers.eq((boolean)true))).thenReturn((Object)Variables.dateValue((Date)testDate));
        Mockito.when((Object)processEngine.getRuntimeService()).thenReturn((Object)this.runtimeServiceMock);
    }

    @Test
    public void testGetDateVariable() {
        RestAssured.given().pathParam("id", (Object)"aProcessInstanceId").pathParam("varId", (Object)"aVariableKey").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("value", org.hamcrest.Matchers.is((Object)testDateFormatted), new Object[0]).body("type", org.hamcrest.Matchers.is((Object)"Date"), new Object[0]).when().get(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testSetDateVariable() throws Exception {
        String variableValue = testDateFormat.format(testDate);
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, "Date");
        RestAssured.given().pathParam("id", (Object)"aProcessInstanceId").pathParam("varId", (Object)"aVariableKey").contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariable((String)Matchers.eq((Object)"aProcessInstanceId"), (String)Matchers.eq((Object)"aVariableKey"), Matchers.argThat((Matcher)EqualsPrimitiveValue.dateValue(testDate)));
    }
}

