/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinition;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinitionQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.fest.assertions.Assertions;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class DecisionRequirementsDefinitionRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String DECISION_REQUIREMENTS_DEFINITION_QUERY_URL = "/rest-test/decision-requirements-definition";
    protected static final String DECISION_REQUIREMENTS_DEFINITION_COUNT_QUERY_URL = "/rest-test/decision-requirements-definition/count";
    private DecisionRequirementsDefinitionQuery mockedQuery;

    @Before
    public void setUpRuntime() {
        DecisionRequirementsDefinition mockDecisionRequirementsDefinition = MockProvider.createMockDecisionRequirementsDefinition();
        this.mockedQuery = this.createMockQuery(Collections.singletonList(mockDecisionRequirementsDefinition));
    }

    private DecisionRequirementsDefinitionQuery createMockQuery(List<DecisionRequirementsDefinition> mockedDefinitions) {
        DecisionRequirementsDefinitionQuery query = (DecisionRequirementsDefinitionQuery)Mockito.mock(DecisionRequirementsDefinitionQuery.class);
        Mockito.when((Object)query.list()).thenReturn(mockedDefinitions);
        Mockito.when((Object)query.count()).thenReturn((Object)mockedDefinitions.size());
        Mockito.when((Object)processEngine.getRepositoryService().createDecisionRequirementsDefinitionQuery()).thenReturn((Object)query);
        return query;
    }

    @Test
    public void testEmptyQuery() {
        RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DECISION_REQUIREMENTS_DEFINITION_QUERY_URL, new Object[0]);
        ((DecisionRequirementsDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testInvalidNumericParameter() {
        String anInvalidIntegerQueryParam = "aString";
        RestAssured.given().queryParam("version", new Object[]{anInvalidIntegerQueryParam}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Cannot set query parameter 'version' to value 'aString': Cannot convert value aString to java type java.lang.Integer"), new Object[0]).when().get(DECISION_REQUIREMENTS_DEFINITION_QUERY_URL, new Object[0]);
    }

    @Test
    public void testInvalidBooleanParameter() {
        String anInvalidBooleanQueryParam = "neitherTrueNorFalse";
        RestAssured.given().queryParam("latestVersion", new Object[]{anInvalidBooleanQueryParam}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Cannot set query parameter 'latestVersion' to value 'neitherTrueNorFalse': Cannot convert value neitherTrueNorFalse to java type java.lang.Boolean"), new Object[0]).when().get(DECISION_REQUIREMENTS_DEFINITION_QUERY_URL, new Object[0]);
    }

    @Test
    public void testInvalidSortingOptions() {
        this.executeAndVerifySorting("anInvalidSortByOption", "asc", Response.Status.BAD_REQUEST);
        this.executeAndVerifySorting("id", "anInvalidSortOrderOption", Response.Status.BAD_REQUEST);
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().queryParam("sortBy", new Object[]{"id"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(DECISION_REQUIREMENTS_DEFINITION_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(DECISION_REQUIREMENTS_DEFINITION_QUERY_URL, new Object[0]);
    }

    protected void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(DECISION_REQUIREMENTS_DEFINITION_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortingParameters() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("id", "asc", Response.Status.OK);
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByDecisionRequirementsDefinitionId();
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("name", "asc", Response.Status.OK);
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByDecisionRequirementsDefinitionName();
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("version", "asc", Response.Status.OK);
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByDecisionRequirementsDefinitionVersion();
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("key", "asc", Response.Status.OK);
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByDecisionRequirementsDefinitionKey();
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("category", "asc", Response.Status.OK);
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByDecisionRequirementsDefinitionCategory();
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("deploymentId", "asc", Response.Status.OK);
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByDeploymentId();
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "asc", Response.Status.OK);
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("id", "desc", Response.Status.OK);
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByDecisionRequirementsDefinitionId();
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("name", "desc", Response.Status.OK);
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByDecisionRequirementsDefinitionName();
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("version", "desc", Response.Status.OK);
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByDecisionRequirementsDefinitionVersion();
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("key", "desc", Response.Status.OK);
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByDecisionRequirementsDefinitionKey();
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("category", "desc", Response.Status.OK);
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByDecisionRequirementsDefinitionCategory();
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("deploymentId", "desc", Response.Status.OK);
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByDeploymentId();
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "desc", Response.Status.OK);
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
    }

    @Test
    public void testSuccessfulPagination() {
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DECISION_REQUIREMENTS_DEFINITION_QUERY_URL, new Object[0]);
        ((DecisionRequirementsDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, maxResults);
    }

    @Test
    public void testMissingFirstResultParameter() {
        int maxResults = 10;
        RestAssured.given().queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DECISION_REQUIREMENTS_DEFINITION_QUERY_URL, new Object[0]);
        ((DecisionRequirementsDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).listPage(0, maxResults);
    }

    @Test
    public void testMissingMaxResultsParameter() {
        int firstResult = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DECISION_REQUIREMENTS_DEFINITION_QUERY_URL, new Object[0]);
        ((DecisionRequirementsDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, Integer.MAX_VALUE);
    }

    @Test
    public void testDecisionRequirementsDefinitionRetrieval() {
        Response response = (Response)RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DECISION_REQUIREMENTS_DEFINITION_QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List decisionRequirementsDefinitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)decisionRequirementsDefinitions).hasSize(1);
        Assertions.assertThat((Map)((Map)decisionRequirementsDefinitions.get(0))).isNotNull();
        String returnedId = JsonPath.from((String)content).getString("[0].id");
        String returnedKey = JsonPath.from((String)content).getString("[0].key");
        String returnedCategory = JsonPath.from((String)content).getString("[0].category");
        String returnedName = JsonPath.from((String)content).getString("[0].name");
        int returnedVersion = JsonPath.from((String)content).getInt("[0].version");
        String returnedResource = JsonPath.from((String)content).getString("[0].resource");
        String returnedDeploymentId = JsonPath.from((String)content).getString("[0].deploymentId");
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        Assertions.assertThat((String)returnedId).isEqualTo((Object)"aDecisionRequirementsDefinitionId");
        Assertions.assertThat((String)returnedKey).isEqualTo((Object)"aDecisionRequirementsDefinitionKey");
        Assertions.assertThat((String)returnedCategory).isEqualTo((Object)"aDecisionRequirementsDefinitionCategory");
        Assertions.assertThat((String)returnedName).isEqualTo((Object)"aDecisionRequirementsDefinitionName");
        Assertions.assertThat((int)returnedVersion).isEqualTo(1);
        Assertions.assertThat((String)returnedResource).isEqualTo((Object)"aDecisionRequirementsDefinitionResourceName");
        Assertions.assertThat((String)returnedDeploymentId).isEqualTo((Object)"aDeploymentId");
        Assertions.assertThat((String)returnedTenantId).isEqualTo(null);
    }

    @Test
    public void testDecisionRequirementsDefinitionRetrievalByList() {
        this.mockedQuery = this.createMockQuery(MockProvider.createMockTwoDecisionRequirementsDefinitions());
        Response response = (Response)RestAssured.given().queryParam("decisionRequirementsDefinitionIdIn", new Object[]{"aDecisionRequirementsDefinitionId,anotherDecisionRequirementsDefinitionId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DECISION_REQUIREMENTS_DEFINITION_QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).decisionRequirementsDefinitionIdIn(new String[]{"aDecisionRequirementsDefinitionId", "anotherDecisionRequirementsDefinitionId"});
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(2);
        String returnedDefinitionId1 = JsonPath.from((String)content).getString("[0].id");
        String returnedDefinitionId2 = JsonPath.from((String)content).getString("[1].id");
        Assertions.assertThat((String)returnedDefinitionId1).isEqualTo((Object)"aDecisionRequirementsDefinitionId");
        Assertions.assertThat((String)returnedDefinitionId2).isEqualTo((Object)"anotherDecisionRequirementsDefinitionId");
    }

    @Test
    public void testDecisionRequirementsDefinitionRetrievalByEmptyList() {
        RestAssured.given().queryParam("decisionRequirementsDefinitionIdIn", new Object[]{""}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DECISION_REQUIREMENTS_DEFINITION_QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery, Mockito.never())).decisionRequirementsDefinitionIdIn((String[])org.mockito.Matchers.anyVararg());
        ((DecisionRequirementsDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testAdditionalParameters() {
        Map<String, String> queryParameters = this.getCompleteQueryParameters();
        RestAssured.given().queryParams(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DECISION_REQUIREMENTS_DEFINITION_QUERY_URL, new Object[0]);
        ((DecisionRequirementsDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).decisionRequirementsDefinitionId(queryParameters.get("decisionRequirementsDefinitionId"));
        ((DecisionRequirementsDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).decisionRequirementsDefinitionCategory(queryParameters.get("category"));
        ((DecisionRequirementsDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).decisionRequirementsDefinitionCategoryLike(queryParameters.get("categoryLike"));
        ((DecisionRequirementsDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).decisionRequirementsDefinitionName(queryParameters.get("name"));
        ((DecisionRequirementsDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).decisionRequirementsDefinitionNameLike(queryParameters.get("nameLike"));
        ((DecisionRequirementsDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).decisionRequirementsDefinitionKey(queryParameters.get("key"));
        ((DecisionRequirementsDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).decisionRequirementsDefinitionKeyLike(queryParameters.get("keyLike"));
        ((DecisionRequirementsDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).decisionRequirementsDefinitionVersion(Integer.valueOf(Integer.parseInt(queryParameters.get("version"))));
        ((DecisionRequirementsDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).latestVersion();
        ((DecisionRequirementsDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).decisionRequirementsDefinitionResourceName(queryParameters.get("resourceName"));
        ((DecisionRequirementsDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).decisionRequirementsDefinitionResourceNameLike(queryParameters.get("resourceNameLike"));
        ((DecisionRequirementsDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).deploymentId(queryParameters.get("deploymentId"));
        ((DecisionRequirementsDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testDecisionRequirementDefinitionTenantIdList() {
        List<DecisionRequirementsDefinition> decisionRequirementsDefinitions = Arrays.asList(MockProvider.mockDecisionRequirementsDefinition().tenantId("aTenantId").build(), MockProvider.createAnotherMockDecisionRequirementsDefinition());
        this.mockedQuery = this.createMockQuery(decisionRequirementsDefinitions);
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId,anotherTenantId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DECISION_REQUIREMENTS_DEFINITION_QUERY_URL, new Object[0]);
        ((DecisionRequirementsDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((DecisionRequirementsDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testDecisionRequirementsDefinitionWithoutTenantId() {
        Response response = (Response)RestAssured.given().queryParam("withoutTenantId", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DECISION_REQUIREMENTS_DEFINITION_QUERY_URL, new Object[0]);
        ((DecisionRequirementsDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).withoutTenantId();
        ((DecisionRequirementsDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(1);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo(null);
    }

    @Test
    public void testDecisionRequirementsDefinitionTenantIdIncludeDefinitionsWithoutTenantid() {
        List<DecisionRequirementsDefinition> decisionDefinitions = Arrays.asList(MockProvider.mockDecisionRequirementsDefinition().tenantId(null).build(), MockProvider.mockDecisionRequirementsDefinition().tenantId("aTenantId").build());
        this.mockedQuery = this.createMockQuery(decisionDefinitions);
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId"}).queryParam("includeDecisionRequirementsDefinitionsWithoutTenantId", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DECISION_REQUIREMENTS_DEFINITION_QUERY_URL, new Object[0]);
        ((DecisionRequirementsDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId"});
        ((DecisionRequirementsDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).includeDecisionRequirementsDefinitionsWithoutTenantId();
        ((DecisionRequirementsDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo(null);
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"aTenantId");
    }

    @Test
    public void testQueryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(DECISION_REQUIREMENTS_DEFINITION_COUNT_QUERY_URL, new Object[0]);
        ((DecisionRequirementsDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    private Map<String, String> getCompleteQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("decisionRequirementsDefinitionId", "anId");
        parameters.put("category", "cat");
        parameters.put("categoryLike", "catlike");
        parameters.put("name", "name");
        parameters.put("nameLike", "namelike");
        parameters.put("key", "key");
        parameters.put("keyLike", "keylike");
        parameters.put("version", "1");
        parameters.put("latestVersion", "true");
        parameters.put("resourceName", "res");
        parameters.put("resourceNameLike", "resLike");
        parameters.put("deploymentId", "depId");
        return parameters;
    }
}

