/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.impl.util.ReflectUtil;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.repository.DeploymentWithDefinitions;
import org.camunda.bpm.engine.repository.Resource;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DeploymentRestServiceInteractionTest
extends AbstractRestServiceTest {
    protected static final String PROPERTY_DEPLOYED_PROCESS_DEFINITIONS = "deployedProcessDefinitions";
    protected static final String PROPERTY_DEPLOYED_CASE_DEFINITIONS = "deployedCaseDefinitions";
    protected static final String PROPERTY_DEPLOYED_DECISION_DEFINITIONS = "deployedDecisionDefinitions";
    protected static final String PROPERTY_DEPLOYED_DECISION_REQUIREMENTS_DEFINITIONS = "deployedDecisionRequirementsDefinitions";
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String RESOURCE_URL = "/rest-test/deployment";
    protected static final String DEPLOYMENT_URL = "/rest-test/deployment/{id}";
    protected static final String RESOURCES_URL = "/rest-test/deployment/{id}/resources";
    protected static final String SINGLE_RESOURCE_URL = "/rest-test/deployment/{id}/resources/{resourceId}";
    protected static final String SINGLE_RESOURCE_DATA_URL = "/rest-test/deployment/{id}/resources/{resourceId}/data";
    protected static final String CREATE_DEPLOYMENT_URL = "/rest-test/deployment/create";
    protected static final String REDEPLOY_DEPLOYMENT_URL = "/rest-test/deployment/{id}/redeploy";
    protected RepositoryService mockRepositoryService;
    protected Deployment mockDeployment;
    protected DeploymentWithDefinitions mockDeploymentWithDefinitions;
    protected List<Resource> mockDeploymentResources;
    protected Resource mockDeploymentResource;
    protected DeploymentQuery mockDeploymentQuery;
    protected DeploymentBuilder mockDeploymentBuilder;
    protected Collection<String> resourceNames = new ArrayList<String>();

    @Before
    public void setUpRuntimeData() {
        this.mockRepositoryService = (RepositoryService)Mockito.mock(RepositoryService.class);
        Mockito.when((Object)processEngine.getRepositoryService()).thenReturn((Object)this.mockRepositoryService);
        this.mockDeployment = MockProvider.createMockDeployment();
        this.mockDeploymentWithDefinitions = MockProvider.createMockDeploymentWithDefinitions();
        this.mockDeploymentQuery = (DeploymentQuery)Mockito.mock(DeploymentQuery.class);
        Mockito.when((Object)this.mockDeploymentQuery.deploymentId("aDeploymentId")).thenReturn((Object)this.mockDeploymentQuery);
        Mockito.when((Object)this.mockDeploymentQuery.singleResult()).thenReturn((Object)this.mockDeployment);
        Mockito.when((Object)this.mockRepositoryService.createDeploymentQuery()).thenReturn((Object)this.mockDeploymentQuery);
        this.mockDeploymentResources = MockProvider.createMockDeploymentResources();
        Mockito.when((Object)this.mockRepositoryService.getDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"))).thenReturn(this.mockDeploymentResources);
        this.mockDeploymentResource = MockProvider.createMockDeploymentResource();
        Mockito.when((Object)this.mockRepositoryService.getResourceAsStreamById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (String)org.mockito.Matchers.eq((Object)"aDeploymentResourceId"))).thenReturn((Object)this.createMockDeploymentResourceBpmnData());
        this.mockDeploymentBuilder = (DeploymentBuilder)Mockito.mock(DeploymentBuilder.class);
        Mockito.when((Object)this.mockRepositoryService.createDeployment()).thenReturn((Object)this.mockDeploymentBuilder);
        Mockito.when((Object)this.mockDeploymentBuilder.addInputStream(org.mockito.Matchers.anyString(), (InputStream)org.mockito.Matchers.any(InputStream.class))).thenReturn((Object)this.mockDeploymentBuilder);
        Mockito.when((Object)this.mockDeploymentBuilder.addDeploymentResourcesById(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyListOf(String.class))).thenReturn((Object)this.mockDeploymentBuilder);
        Mockito.when((Object)this.mockDeploymentBuilder.addDeploymentResourcesByName(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyListOf(String.class))).thenReturn((Object)this.mockDeploymentBuilder);
        Mockito.when((Object)this.mockDeploymentBuilder.source(org.mockito.Matchers.anyString())).thenReturn((Object)this.mockDeploymentBuilder);
        Mockito.when((Object)this.mockDeploymentBuilder.tenantId(org.mockito.Matchers.anyString())).thenReturn((Object)this.mockDeploymentBuilder);
        Mockito.when((Object)this.mockDeploymentBuilder.getResourceNames()).thenReturn(this.resourceNames);
        Mockito.when((Object)this.mockDeploymentBuilder.deployWithResult()).thenReturn((Object)this.mockDeploymentWithDefinitions);
    }

    private byte[] createMockDeploymentResourceByteData() {
        return "someContent".getBytes();
    }

    private InputStream createMockDeploymentResourceBpmnData() {
        InputStream bpmn20XmlIn = ReflectUtil.getResourceAsStream((String)"processes/fox-invoice_en_long_id.bpmn");
        Assert.assertNotNull((Object)bpmn20XmlIn);
        return bpmn20XmlIn;
    }

    private InputStream createMockDeploymentResourceBpmnDataNonExecutableProcess() {
        String model = Bpmn.convertToString((BpmnModelInstance)Bpmn.createProcess().startEvent().endEvent().done());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(model.getBytes());
        return inputStream;
    }

    private InputStream createMockDeploymentResourceSvgData() {
        InputStream image = ReflectUtil.getResourceAsStream((String)"processes/diagram.svg");
        Assert.assertNotNull((Object)image);
        return image;
    }

    @Test
    public void testGetSingleDeployment() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DEPLOYMENT_URL, new Object[0]);
        this.verifyDeployment(this.mockDeployment, response);
    }

    @Test
    public void testGetNonExistingSingleDeployment() {
        Mockito.when((Object)this.mockDeploymentQuery.deploymentId("aNonExistingDeploymentId")).thenReturn((Object)this.mockDeploymentQuery);
        Mockito.when((Object)this.mockDeploymentQuery.singleResult()).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"aNonExistingDeploymentId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(CoreMatchers.containsString((String)"Deployment with id 'aNonExistingDeploymentId' does not exist"), new Matcher[0]).when().get(DEPLOYMENT_URL, new Object[0]);
    }

    @Test
    public void testGetDeploymentResources() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(RESOURCES_URL, new Object[0]);
        this.verifyDeploymentResources(this.mockDeploymentResources, response);
    }

    @Test
    public void testGetNonExistingDeploymentResources() {
        RestAssured.given().pathParam("id", (Object)"aNonExistingDeploymentId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(CoreMatchers.containsString((String)"Deployment resources for deployment id 'aNonExistingDeploymentId' do not exist."), new Matcher[0]).when().get(RESOURCES_URL, new Object[0]);
    }

    @Test
    public void testGetDeploymentResourcesThrowsAuthorizationException() {
        String message = "expected exception";
        Mockito.when((Object)this.mockRepositoryService.getDeploymentResources("aDeploymentId")).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().pathParam("id", (Object)"aDeploymentId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().get(RESOURCES_URL, new Object[0]);
    }

    @Test
    public void testGetDeploymentResource() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aDeploymentResourceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(SINGLE_RESOURCE_URL, new Object[0]);
        this.verifyDeploymentResource(this.mockDeploymentResource, response);
    }

    @Test
    public void testGetNonExistingDeploymentResource() {
        RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aNonExistingDeploymentResourceId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(CoreMatchers.containsString((String)"Deployment resource with resource id 'aNonExistingDeploymentResourceId' for deployment id 'aDeploymentId' does not exist."), new Matcher[0]).when().get(SINGLE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testGetDeploymentResourceWithNonExistingDeploymentId() {
        RestAssured.given().pathParam("id", (Object)"aNonExistingDeploymentId").pathParam("resourceId", (Object)"aDeploymentResourceId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(CoreMatchers.containsString((String)"Deployment resources for deployment id 'aNonExistingDeploymentId' do not exist."), new Matcher[0]).when().get(SINGLE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testGetDeploymentResourceWithNonExistingDeploymentIdAndNonExistingResourceId() {
        RestAssured.given().pathParam("id", (Object)"aNonExistingDeploymentId").pathParam("resourceId", (Object)"aNonExistingDeploymentResourceId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(CoreMatchers.containsString((String)"Deployment resources for deployment id 'aNonExistingDeploymentId' do not exist."), new Matcher[0]).when().get(SINGLE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testGetDeploymentResourceThrowsAuthorizationException() {
        String message = "expected exception";
        Mockito.when((Object)this.mockRepositoryService.getDeploymentResources("aDeploymentId")).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aDeploymentResourceId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().get(SINGLE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testGetDeploymentResourceData() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aDeploymentResourceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/octet-stream").header("Content-Disposition", "attachment; filename=aDeploymentResourceName").when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertTrue((boolean)responseContent.contains("<?xml"));
    }

    @Test
    public void testGetDeploymentSvgResourceData() {
        Resource resource = MockProvider.createMockDeploymentSvgResource();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        Mockito.when((Object)this.mockRepositoryService.getDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"))).thenReturn(resources);
        Mockito.when((Object)this.mockRepositoryService.getResourceAsStreamById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (String)org.mockito.Matchers.eq((Object)"aDeploymentSvgResourceId"))).thenReturn((Object)this.createMockDeploymentResourceSvgData());
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aDeploymentSvgResourceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("image/svg+xml").header("Content-Disposition", "attachment; filename=a-svg-resource.svg").when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertTrue((boolean)responseContent.contains("<?xml"));
    }

    @Test
    public void testGetDeploymentPngResourceData() {
        Resource resource = MockProvider.createMockDeploymentPngResource();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        ByteArrayInputStream input = new ByteArrayInputStream(this.createMockDeploymentResourceByteData());
        Mockito.when((Object)this.mockRepositoryService.getDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"))).thenReturn(resources);
        Mockito.when((Object)this.mockRepositoryService.getResourceAsStreamById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (String)org.mockito.Matchers.eq((Object)"aDeploymentPngResourceId"))).thenReturn((Object)input);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aDeploymentPngResourceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("image/png").header("Content-Disposition", "attachment; filename=an-image-resource.png").when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertNotNull((Object)responseContent);
    }

    @Test
    public void testGetDeploymentGifResourceData() {
        Resource resource = MockProvider.createMockDeploymentGifResource();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        ByteArrayInputStream input = new ByteArrayInputStream(this.createMockDeploymentResourceByteData());
        Mockito.when((Object)this.mockRepositoryService.getDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"))).thenReturn(resources);
        Mockito.when((Object)this.mockRepositoryService.getResourceAsStreamById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (String)org.mockito.Matchers.eq((Object)"aDeploymentGifResourceId"))).thenReturn((Object)input);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aDeploymentGifResourceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("image/gif").header("Content-Disposition", "attachment; filename=an-image-resource.gif").when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertNotNull((Object)responseContent);
    }

    @Test
    public void testGetDeploymentJpgResourceData() {
        Resource resource = MockProvider.createMockDeploymentJpgResource();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        ByteArrayInputStream input = new ByteArrayInputStream(this.createMockDeploymentResourceByteData());
        Mockito.when((Object)this.mockRepositoryService.getDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"))).thenReturn(resources);
        Mockito.when((Object)this.mockRepositoryService.getResourceAsStreamById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (String)org.mockito.Matchers.eq((Object)"aDeploymentJpgResourceId"))).thenReturn((Object)input);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aDeploymentJpgResourceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("image/jpeg").header("Content-Disposition", "attachment; filename=an-image-resource.jpg").when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertNotNull((Object)responseContent);
    }

    @Test
    public void testGetDeploymentJpegResourceData() {
        Resource resource = MockProvider.createMockDeploymentJpegResource();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        ByteArrayInputStream input = new ByteArrayInputStream(this.createMockDeploymentResourceByteData());
        Mockito.when((Object)this.mockRepositoryService.getDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"))).thenReturn(resources);
        Mockito.when((Object)this.mockRepositoryService.getResourceAsStreamById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (String)org.mockito.Matchers.eq((Object)"aDeploymentJpegResourceId"))).thenReturn((Object)input);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aDeploymentJpegResourceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("image/jpeg").header("Content-Disposition", "attachment; filename=an-image-resource.jpeg").when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertNotNull((Object)responseContent);
    }

    @Test
    public void testGetDeploymentJpeResourceData() {
        Resource resource = MockProvider.createMockDeploymentJpeResource();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        ByteArrayInputStream input = new ByteArrayInputStream(this.createMockDeploymentResourceByteData());
        Mockito.when((Object)this.mockRepositoryService.getDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"))).thenReturn(resources);
        Mockito.when((Object)this.mockRepositoryService.getResourceAsStreamById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (String)org.mockito.Matchers.eq((Object)"aDeploymentJpeResourceId"))).thenReturn((Object)input);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aDeploymentJpeResourceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("image/jpeg").header("Content-Disposition", "attachment; filename=an-image-resource.jpe").when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertNotNull((Object)responseContent);
    }

    @Test
    public void testGetDeploymentTifResourceData() {
        Resource resource = MockProvider.createMockDeploymentTifResource();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        ByteArrayInputStream input = new ByteArrayInputStream(this.createMockDeploymentResourceByteData());
        Mockito.when((Object)this.mockRepositoryService.getDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"))).thenReturn(resources);
        Mockito.when((Object)this.mockRepositoryService.getResourceAsStreamById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (String)org.mockito.Matchers.eq((Object)"aDeploymentTifResourceId"))).thenReturn((Object)input);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aDeploymentTifResourceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("image/tiff").header("Content-Disposition", "attachment; filename=an-image-resource.tif").when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertNotNull((Object)responseContent);
    }

    @Test
    public void testGetDeploymentTiffResourceData() {
        Resource resource = MockProvider.createMockDeploymentTiffResource();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        ByteArrayInputStream input = new ByteArrayInputStream(this.createMockDeploymentResourceByteData());
        Mockito.when((Object)this.mockRepositoryService.getDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"))).thenReturn(resources);
        Mockito.when((Object)this.mockRepositoryService.getResourceAsStreamById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (String)org.mockito.Matchers.eq((Object)"aDeploymentTiffResourceId"))).thenReturn((Object)input);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aDeploymentTiffResourceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("image/tiff").header("Content-Disposition", "attachment; filename=an-image-resource.tiff").when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertNotNull((Object)responseContent);
    }

    @Test
    public void testGetDeploymentBpmnResourceData() {
        Resource resource = MockProvider.createMockDeploymentBpmnResource();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        Mockito.when((Object)this.mockRepositoryService.getDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"))).thenReturn(resources);
        Mockito.when((Object)this.mockRepositoryService.getResourceAsStreamById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (String)org.mockito.Matchers.eq((Object)"aDeploymentBpmnResourceId"))).thenReturn((Object)this.createMockDeploymentResourceBpmnData());
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aDeploymentBpmnResourceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.XML).header("Content-Disposition", "attachment; filename=a-bpmn-resource.bpmn").when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertNotNull((Object)responseContent);
    }

    @Test
    public void testGetDeploymentBpmnXmlResourceData() {
        Resource resource = MockProvider.createMockDeploymentBpmnXmlResource();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        Mockito.when((Object)this.mockRepositoryService.getDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"))).thenReturn(resources);
        Mockito.when((Object)this.mockRepositoryService.getResourceAsStreamById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (String)org.mockito.Matchers.eq((Object)"aDeploymentBpmnXmlResourceId"))).thenReturn((Object)this.createMockDeploymentResourceBpmnData());
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aDeploymentBpmnXmlResourceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.XML).header("Content-Disposition", "attachment; filename=a-bpmn-resource.bpmn20.xml").when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertNotNull((Object)responseContent);
    }

    @Test
    public void testGetDeploymentCmmnResourceData() {
        Resource resource = MockProvider.createMockDeploymentCmmnResource();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        ByteArrayInputStream input = new ByteArrayInputStream(this.createMockDeploymentResourceByteData());
        Mockito.when((Object)this.mockRepositoryService.getDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"))).thenReturn(resources);
        Mockito.when((Object)this.mockRepositoryService.getResourceAsStreamById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (String)org.mockito.Matchers.eq((Object)"aDeploymentCmmnResourceId"))).thenReturn((Object)input);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aDeploymentCmmnResourceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.XML).header("Content-Disposition", "attachment; filename=a-cmmn-resource.cmmn").when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertNotNull((Object)responseContent);
    }

    @Test
    public void testGetDeploymentCmmnXmlResourceData() {
        Resource resource = MockProvider.createMockDeploymentCmmnXmlResource();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        ByteArrayInputStream input = new ByteArrayInputStream(this.createMockDeploymentResourceByteData());
        Mockito.when((Object)this.mockRepositoryService.getDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"))).thenReturn(resources);
        Mockito.when((Object)this.mockRepositoryService.getResourceAsStreamById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (String)org.mockito.Matchers.eq((Object)"aDeploymentCmmnXmlResourceId"))).thenReturn((Object)input);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aDeploymentCmmnXmlResourceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.XML).header("Content-Disposition", "attachment; filename=a-cmmn-resource.cmmn10.xml").when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertNotNull((Object)responseContent);
    }

    @Test
    public void testGetDeploymentDmnResourceData() {
        Resource resource = MockProvider.createMockDeploymentDmnResource();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        ByteArrayInputStream input = new ByteArrayInputStream(this.createMockDeploymentResourceByteData());
        Mockito.when((Object)this.mockRepositoryService.getDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"))).thenReturn(resources);
        Mockito.when((Object)this.mockRepositoryService.getResourceAsStreamById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (String)org.mockito.Matchers.eq((Object)"aDeploymentDmnResourceId"))).thenReturn((Object)input);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aDeploymentDmnResourceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.XML).header("Content-Disposition", "attachment; filename=a-dmn-resource.dmn").when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertNotNull((Object)responseContent);
    }

    @Test
    public void testGetDeploymentDmnXmlResourceData() {
        Resource resource = MockProvider.createMockDeploymentDmnXmlResource();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        ByteArrayInputStream input = new ByteArrayInputStream(this.createMockDeploymentResourceByteData());
        Mockito.when((Object)this.mockRepositoryService.getDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"))).thenReturn(resources);
        Mockito.when((Object)this.mockRepositoryService.getResourceAsStreamById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (String)org.mockito.Matchers.eq((Object)"aDeploymentDmnXmlResourceId"))).thenReturn((Object)input);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aDeploymentDmnXmlResourceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.XML).header("Content-Disposition", "attachment; filename=a-dmn-resource.dmn11.xml").when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertNotNull((Object)responseContent);
    }

    @Test
    public void testGetDeploymentXmlResourceData() {
        Resource resource = MockProvider.createMockDeploymentXmlResource();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        ByteArrayInputStream input = new ByteArrayInputStream(this.createMockDeploymentResourceByteData());
        Mockito.when((Object)this.mockRepositoryService.getDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"))).thenReturn(resources);
        Mockito.when((Object)this.mockRepositoryService.getResourceAsStreamById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (String)org.mockito.Matchers.eq((Object)"aDeploymentXmlResourceId"))).thenReturn((Object)input);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aDeploymentXmlResourceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.XML).header("Content-Disposition", "attachment; filename=a-xml-resource.xml").when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertNotNull((Object)responseContent);
    }

    @Test
    public void testGetDeploymentJsonResourceData() {
        Resource resource = MockProvider.createMockDeploymentJsonResource();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        ByteArrayInputStream input = new ByteArrayInputStream(this.createMockDeploymentResourceByteData());
        Mockito.when((Object)this.mockRepositoryService.getDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"))).thenReturn(resources);
        Mockito.when((Object)this.mockRepositoryService.getResourceAsStreamById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (String)org.mockito.Matchers.eq((Object)"aDeploymentJsonResourceId"))).thenReturn((Object)input);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aDeploymentJsonResourceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).header("Content-Disposition", "attachment; filename=a-json-resource.json").when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertNotNull((Object)responseContent);
    }

    @Test
    public void testGetDeploymentGroovyResourceData() {
        Resource resource = MockProvider.createMockDeploymentGroovyResource();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        ByteArrayInputStream input = new ByteArrayInputStream(this.createMockDeploymentResourceByteData());
        Mockito.when((Object)this.mockRepositoryService.getDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"))).thenReturn(resources);
        Mockito.when((Object)this.mockRepositoryService.getResourceAsStreamById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (String)org.mockito.Matchers.eq((Object)"aDeploymentGroovyResourceId"))).thenReturn((Object)input);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aDeploymentGroovyResourceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.TEXT).header("Content-Disposition", "attachment; filename=a-groovy-resource.groovy").when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertNotNull((Object)responseContent);
    }

    @Test
    public void testGetDeploymentJavaResourceData() {
        Resource resource = MockProvider.createMockDeploymentJavaResource();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        ByteArrayInputStream input = new ByteArrayInputStream(this.createMockDeploymentResourceByteData());
        Mockito.when((Object)this.mockRepositoryService.getDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"))).thenReturn(resources);
        Mockito.when((Object)this.mockRepositoryService.getResourceAsStreamById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (String)org.mockito.Matchers.eq((Object)"aDeploymentGroovyResourceId"))).thenReturn((Object)input);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aDeploymentGroovyResourceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.TEXT).header("Content-Disposition", "attachment; filename=a-java-resource.java").when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertNotNull((Object)responseContent);
    }

    @Test
    public void testGetDeploymentJsResourceData() {
        Resource resource = MockProvider.createMockDeploymentJsResource();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        ByteArrayInputStream input = new ByteArrayInputStream(this.createMockDeploymentResourceByteData());
        Mockito.when((Object)this.mockRepositoryService.getDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"))).thenReturn(resources);
        Mockito.when((Object)this.mockRepositoryService.getResourceAsStreamById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (String)org.mockito.Matchers.eq((Object)"aDeploymentJsResourceId"))).thenReturn((Object)input);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aDeploymentJsResourceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.TEXT).header("Content-Disposition", "attachment; filename=a-js-resource.js").when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertNotNull((Object)responseContent);
    }

    @Test
    public void testGetDeploymentPythonResourceData() {
        Resource resource = MockProvider.createMockDeploymentPythonResource();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        ByteArrayInputStream input = new ByteArrayInputStream(this.createMockDeploymentResourceByteData());
        Mockito.when((Object)this.mockRepositoryService.getDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"))).thenReturn(resources);
        Mockito.when((Object)this.mockRepositoryService.getResourceAsStreamById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (String)org.mockito.Matchers.eq((Object)"aDeploymentPythonResourceId"))).thenReturn((Object)input);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aDeploymentPythonResourceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.TEXT).header("Content-Disposition", "attachment; filename=a-python-resource.py").when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertNotNull((Object)responseContent);
    }

    @Test
    public void testGetDeploymentRubyResourceData() {
        Resource resource = MockProvider.createMockDeploymentRubyResource();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        ByteArrayInputStream input = new ByteArrayInputStream(this.createMockDeploymentResourceByteData());
        Mockito.when((Object)this.mockRepositoryService.getDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"))).thenReturn(resources);
        Mockito.when((Object)this.mockRepositoryService.getResourceAsStreamById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (String)org.mockito.Matchers.eq((Object)"aDeploymentRubyResourceId"))).thenReturn((Object)input);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aDeploymentRubyResourceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.TEXT).header("Content-Disposition", "attachment; filename=a-ruby-resource.rb").when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertNotNull((Object)responseContent);
    }

    @Test
    public void testGetDeploymentPhpResourceData() {
        Resource resource = MockProvider.createMockDeploymentPhpResource();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        ByteArrayInputStream input = new ByteArrayInputStream(this.createMockDeploymentResourceByteData());
        Mockito.when((Object)this.mockRepositoryService.getDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"))).thenReturn(resources);
        Mockito.when((Object)this.mockRepositoryService.getResourceAsStreamById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (String)org.mockito.Matchers.eq((Object)"aDeploymentPhpResourceId"))).thenReturn((Object)input);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aDeploymentPhpResourceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.TEXT).header("Content-Disposition", "attachment; filename=a-php-resource.php").when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertNotNull((Object)responseContent);
    }

    @Test
    public void testGetDeploymentHtmlpResourceData() {
        Resource resource = MockProvider.createMockDeploymentHtmlResource();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        ByteArrayInputStream input = new ByteArrayInputStream(this.createMockDeploymentResourceByteData());
        Mockito.when((Object)this.mockRepositoryService.getDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"))).thenReturn(resources);
        Mockito.when((Object)this.mockRepositoryService.getResourceAsStreamById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (String)org.mockito.Matchers.eq((Object)"aDeploymentHtmlResourceId"))).thenReturn((Object)input);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aDeploymentHtmlResourceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.HTML).header("Content-Disposition", "attachment; filename=a-html-resource.html").when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertNotNull((Object)responseContent);
    }

    @Test
    public void testGetDeploymentTxtResourceData() {
        Resource resource = MockProvider.createMockDeploymentTxtResource();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        ByteArrayInputStream input = new ByteArrayInputStream(this.createMockDeploymentResourceByteData());
        Mockito.when((Object)this.mockRepositoryService.getDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"))).thenReturn(resources);
        Mockito.when((Object)this.mockRepositoryService.getResourceAsStreamById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (String)org.mockito.Matchers.eq((Object)"aDeploymentTxtResourceId"))).thenReturn((Object)input);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aDeploymentTxtResourceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.TEXT).header("Content-Disposition", "attachment; filename=a-txt-resource.txt").when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertNotNull((Object)responseContent);
    }

    @Test
    public void testGetDeploymentResourceDataFilename() {
        Resource resource = MockProvider.createMockDeploymentResourceFilename();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        ByteArrayInputStream input = new ByteArrayInputStream(this.createMockDeploymentResourceByteData());
        Mockito.when((Object)this.mockRepositoryService.getDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"))).thenReturn(resources);
        Mockito.when((Object)this.mockRepositoryService.getResourceAsStreamById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (String)org.mockito.Matchers.eq((Object)"aDeploymentResourceFilenameId"))).thenReturn((Object)input);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aDeploymentResourceFilenameId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.XML).header("Content-Disposition", "attachment; filename=process.bpmn").when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertNotNull((Object)responseContent);
    }

    @Test
    public void testGetDeploymentResourceDataFilenameBackslash() {
        Resource resource = MockProvider.createMockDeploymentResourceFilenameBackslash();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        ByteArrayInputStream input = new ByteArrayInputStream(this.createMockDeploymentResourceByteData());
        Mockito.when((Object)this.mockRepositoryService.getDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"))).thenReturn(resources);
        Mockito.when((Object)this.mockRepositoryService.getResourceAsStreamById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (String)org.mockito.Matchers.eq((Object)"aDeploymentResourceFilenameId"))).thenReturn((Object)input);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aDeploymentResourceFilenameId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.XML).header("Content-Disposition", "attachment; filename=process.bpmn").when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertNotNull((Object)responseContent);
    }

    @Test
    public void testGetDeploymentResourceDataForNonExistingDeploymentId() {
        RestAssured.given().pathParam("id", (Object)"aNonExistingDeploymentId").pathParam("resourceId", (Object)"aDeploymentResourceId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(CoreMatchers.containsString((String)"Deployment resource 'aDeploymentResourceId' for deployment id 'aNonExistingDeploymentId' does not exist."), new Matcher[0]).when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
    }

    @Test
    public void testGetDeploymentResourceDataForNonExistingResourceId() {
        RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aNonExistingDeploymentResourceId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(CoreMatchers.containsString((String)"Deployment resource 'aNonExistingDeploymentResourceId' for deployment id 'aDeploymentId' does not exist."), new Matcher[0]).when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
    }

    @Test
    public void testGetDeploymentResourceDataForNonExistingDeploymentIdAndNonExistingResourceId() {
        RestAssured.given().pathParam("id", (Object)"aNonExistingDeploymentId").pathParam("resourceId", (Object)"aNonExistingDeploymentResourceId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(CoreMatchers.containsString((String)"Deployment resource 'aNonExistingDeploymentResourceId' for deployment id 'aNonExistingDeploymentId' does not exist."), new Matcher[0]).when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
    }

    @Test
    public void testGetDeploymentResourceDataThrowsAuthorizationException() {
        String message = "expected exception";
        Mockito.when((Object)this.mockRepositoryService.getResourceAsStreamById("aDeploymentId", "aDeploymentResourceId")).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().pathParam("id", (Object)"aDeploymentId").pathParam("resourceId", (Object)"aDeploymentResourceId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().get(SINGLE_RESOURCE_DATA_URL, new Object[0]);
    }

    @Test
    public void testCreateCompleteDeployment() throws Exception {
        this.resourceNames.addAll(Arrays.asList("data", "more-data"));
        Response response = (Response)RestAssured.given().multiPart("data", "unspecified", this.createMockDeploymentResourceByteData()).multiPart("more-data", "unspecified", this.createMockDeploymentResourceBpmnData()).multiPart("deployment-name", "aDeploymentId").multiPart("enable-duplicate-filtering", "true").expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CREATE_DEPLOYMENT_URL, new Object[0]);
        this.verifyCreatedDeployment(this.mockDeployment, response);
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).name("aDeploymentId");
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).enableDuplicateFiltering(false);
    }

    @Test
    public void testCreateCompleteBpmnDeployment() throws Exception {
        DeploymentWithDefinitions mockDeployment = MockProvider.createMockDeploymentWithDefinitions();
        Mockito.when((Object)mockDeployment.getDeployedDecisionDefinitions()).thenReturn(null);
        Mockito.when((Object)mockDeployment.getDeployedCaseDefinitions()).thenReturn(null);
        Mockito.when((Object)mockDeployment.getDeployedDecisionRequirementsDefinitions()).thenReturn(null);
        Mockito.when((Object)this.mockDeploymentBuilder.deployWithResult()).thenReturn((Object)mockDeployment);
        this.resourceNames.addAll(Arrays.asList("data", "more-data"));
        Response response = (Response)RestAssured.given().multiPart("data", "unspecified", this.createMockDeploymentResourceByteData()).multiPart("more-data", "unspecified", this.createMockDeploymentResourceBpmnData()).multiPart("deployment-name", "aDeploymentId").multiPart("enable-duplicate-filtering", "true").expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CREATE_DEPLOYMENT_URL, new Object[0]);
        this.verifyCreatedBpmnDeployment((Deployment)mockDeployment, response);
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).name("aDeploymentId");
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).enableDuplicateFiltering(false);
    }

    @Test
    public void testCreateCompleteCmmnDeployment() throws Exception {
        DeploymentWithDefinitions mockDeployment = MockProvider.createMockDeploymentWithDefinitions();
        Mockito.when((Object)mockDeployment.getDeployedDecisionDefinitions()).thenReturn(null);
        Mockito.when((Object)mockDeployment.getDeployedProcessDefinitions()).thenReturn(null);
        Mockito.when((Object)mockDeployment.getDeployedDecisionRequirementsDefinitions()).thenReturn(null);
        Mockito.when((Object)this.mockDeploymentBuilder.deployWithResult()).thenReturn((Object)mockDeployment);
        this.resourceNames.addAll(Arrays.asList("data", "more-data"));
        Response response = (Response)RestAssured.given().multiPart("data", "unspecified", this.createMockDeploymentResourceByteData()).multiPart("more-data", "unspecified", this.createMockDeploymentResourceBpmnData()).multiPart("deployment-name", "aDeploymentId").multiPart("enable-duplicate-filtering", "true").expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CREATE_DEPLOYMENT_URL, new Object[0]);
        this.verifyCreatedCmmnDeployment((Deployment)mockDeployment, response);
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).name("aDeploymentId");
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).enableDuplicateFiltering(false);
    }

    @Test
    public void testCreateCompleteDmnDeployment() throws Exception {
        DeploymentWithDefinitions mockDeployment = MockProvider.createMockDeploymentWithDefinitions();
        Mockito.when((Object)mockDeployment.getDeployedCaseDefinitions()).thenReturn(null);
        Mockito.when((Object)mockDeployment.getDeployedProcessDefinitions()).thenReturn(null);
        Mockito.when((Object)mockDeployment.getDeployedDecisionRequirementsDefinitions()).thenReturn(null);
        Mockito.when((Object)this.mockDeploymentBuilder.deployWithResult()).thenReturn((Object)mockDeployment);
        this.resourceNames.addAll(Arrays.asList("data", "more-data"));
        Response response = (Response)RestAssured.given().multiPart("data", "unspecified", this.createMockDeploymentResourceByteData()).multiPart("more-data", "unspecified", this.createMockDeploymentResourceBpmnData()).multiPart("deployment-name", "aDeploymentId").multiPart("enable-duplicate-filtering", "true").expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CREATE_DEPLOYMENT_URL, new Object[0]);
        this.verifyCreatedDmnDeployment((Deployment)mockDeployment, response);
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).name("aDeploymentId");
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).enableDuplicateFiltering(false);
    }

    @Test
    public void testCreateCompleteDrdDeployment() throws Exception {
        DeploymentWithDefinitions mockDeployment = MockProvider.createMockDeploymentWithDefinitions();
        Mockito.when((Object)mockDeployment.getDeployedCaseDefinitions()).thenReturn(null);
        Mockito.when((Object)mockDeployment.getDeployedProcessDefinitions()).thenReturn(null);
        Mockito.when((Object)this.mockDeploymentBuilder.deployWithResult()).thenReturn((Object)mockDeployment);
        this.resourceNames.addAll(Arrays.asList("data", "more-data"));
        Response response = (Response)RestAssured.given().multiPart("data", "unspecified", this.createMockDeploymentResourceByteData()).multiPart("more-data", "unspecified", this.createMockDeploymentResourceBpmnData()).multiPart("deployment-name", "aDeploymentId").multiPart("enable-duplicate-filtering", "true").expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CREATE_DEPLOYMENT_URL, new Object[0]);
        this.verifyCreatedDrdDeployment((Deployment)mockDeployment, response);
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).name("aDeploymentId");
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).enableDuplicateFiltering(false);
    }

    @Test
    public void testCreateDeploymentWithNonExecutableProcess() throws Exception {
        DeploymentWithDefinitions mockDeployment = MockProvider.createMockDeploymentWithDefinitions();
        Mockito.when((Object)mockDeployment.getDeployedDecisionDefinitions()).thenReturn(null);
        Mockito.when((Object)mockDeployment.getDeployedCaseDefinitions()).thenReturn(null);
        Mockito.when((Object)mockDeployment.getDeployedProcessDefinitions()).thenReturn(null);
        Mockito.when((Object)mockDeployment.getDeployedDecisionRequirementsDefinitions()).thenReturn(null);
        Mockito.when((Object)this.mockDeploymentBuilder.deployWithResult()).thenReturn((Object)mockDeployment);
        this.resourceNames.addAll(Arrays.asList("data", "more-data"));
        Response response = (Response)RestAssured.given().multiPart("data", "unspecified", this.createMockDeploymentResourceByteData()).multiPart("more-data", "unspecified", this.createMockDeploymentResourceBpmnDataNonExecutableProcess()).multiPart("deployment-name", "aDeploymentId").multiPart("enable-duplicate-filtering", "true").expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CREATE_DEPLOYMENT_URL, new Object[0]);
        this.verifyCreatedEmptyDeployment((Deployment)mockDeployment, response);
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).name("aDeploymentId");
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).enableDuplicateFiltering(false);
    }

    @Test
    public void testCreateCompleteDeploymentDeployChangedOnly() throws Exception {
        this.resourceNames.addAll(Arrays.asList("data", "more-data"));
        RestAssured.given().multiPart("data", "unspecified", this.createMockDeploymentResourceByteData()).multiPart("deploy-changed-only", "true").expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CREATE_DEPLOYMENT_URL, new Object[0]);
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).enableDuplicateFiltering(true);
    }

    @Test
    public void testCreateCompleteDeploymentConflictingDuplicateSetting() throws Exception {
        this.resourceNames.addAll(Arrays.asList("data", "more-data"));
        RestAssured.given().multiPart("data", "unspecified", this.createMockDeploymentResourceByteData()).multiPart("enable-duplicate-filtering", "false").multiPart("deploy-changed-only", "true").expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CREATE_DEPLOYMENT_URL, new Object[0]);
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).enableDuplicateFiltering(true);
    }

    @Test
    public void testCreateDeploymentWithDeploymentSource() throws Exception {
        this.resourceNames.addAll(Arrays.asList("data", "more-data"));
        RestAssured.given().multiPart("data", "unspecified", this.createMockDeploymentResourceByteData()).multiPart("enable-duplicate-filtering", "false").multiPart("deployment-source", "my-deployment-source").expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CREATE_DEPLOYMENT_URL, new Object[0]);
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).source("my-deployment-source");
    }

    @Test
    public void testCreateDeploymentWithTenantId() throws Exception {
        this.resourceNames.addAll(Arrays.asList("data", "more-data"));
        RestAssured.given().multiPart("data", "unspecified", this.createMockDeploymentResourceByteData()).multiPart("tenant-id", "aTenantId").expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CREATE_DEPLOYMENT_URL, new Object[0]);
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).tenantId("aTenantId");
    }

    @Test
    public void testCreateDeploymentOnlyWithBytes() throws Exception {
        this.resourceNames.addAll(Arrays.asList("data", "more-data"));
        Response response = (Response)RestAssured.given().multiPart("data", "unspecified", this.createMockDeploymentResourceByteData()).multiPart("more-data", "unspecified", this.createMockDeploymentResourceBpmnData()).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CREATE_DEPLOYMENT_URL, new Object[0]);
        this.verifyCreatedDeployment(this.mockDeployment, response);
    }

    @Test
    public void testCreateDeploymentWithoutBytes() throws Exception {
        RestAssured.given().multiPart("deployment-name", "aDeploymentId").expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(CREATE_DEPLOYMENT_URL, new Object[0]);
    }

    @Test
    public void testCreateDeploymentThrowsAuthorizationException() {
        String message = "expected exception";
        Mockito.when((Object)this.mockDeploymentBuilder.deployWithResult()).thenThrow(new Throwable[]{new AuthorizationException(message)});
        this.resourceNames.addAll(Arrays.asList("data", "more-data"));
        RestAssured.given().multiPart("data", "unspecified", this.createMockDeploymentResourceByteData()).multiPart("more-data", "unspecified", this.createMockDeploymentResourceBpmnData()).multiPart("deployment-name", "aDeploymentId").multiPart("enable-duplicate-filtering", "true").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().post(CREATE_DEPLOYMENT_URL, new Object[0]);
    }

    @Test
    public void testDeleteDeployment() {
        RestAssured.given().pathParam("id", (Object)"aDeploymentId").expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(DEPLOYMENT_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.mockRepositoryService)).deleteDeployment("aDeploymentId", false, false, false);
    }

    @Test
    public void testDeleteDeploymentCascade() {
        RestAssured.given().pathParam("id", (Object)"aDeploymentId").queryParam("cascade", new Object[]{true}).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(DEPLOYMENT_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.mockRepositoryService)).deleteDeployment("aDeploymentId", true, false, false);
    }

    @Test
    public void testDeleteDeploymentCascadeNonsense() {
        RestAssured.given().pathParam("id", (Object)"aDeploymentId").queryParam("cascade", new Object[]{"bla"}).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(DEPLOYMENT_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.mockRepositoryService)).deleteDeployment("aDeploymentId", false, false, false);
    }

    @Test
    public void testDeleteDeploymentCascadeFalse() {
        RestAssured.given().pathParam("id", (Object)"aDeploymentId").queryParam("cascade", new Object[]{false}).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(DEPLOYMENT_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.mockRepositoryService)).deleteDeployment("aDeploymentId", false, false, false);
    }

    @Test
    public void testDeleteDeploymentSkipCustomListeners() {
        RestAssured.given().pathParam("id", (Object)"aDeploymentId").queryParam("skipCustomListeners", new Object[]{true}).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(DEPLOYMENT_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.mockRepositoryService)).deleteDeployment("aDeploymentId", false, true, false);
    }

    @Test
    public void testDeleteDeploymentSkipCustomListenersNonsense() {
        RestAssured.given().pathParam("id", (Object)"aDeploymentId").queryParam("skipCustomListeners", new Object[]{"bla"}).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(DEPLOYMENT_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.mockRepositoryService)).deleteDeployment("aDeploymentId", false, false, false);
    }

    @Test
    public void testDeleteDeploymentSkipCustomListenersFalse() {
        RestAssured.given().pathParam("id", (Object)"aDeploymentId").queryParam("skipCustomListeners", new Object[]{false}).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(DEPLOYMENT_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.mockRepositoryService)).deleteDeployment("aDeploymentId", false, false, false);
    }

    @Test
    public void testDeleteDeploymentSkipCustomListenersAndCascade() {
        RestAssured.given().pathParam("id", (Object)"aDeploymentId").queryParam("cascade", new Object[]{true}).queryParam("skipCustomListeners", new Object[]{true}).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(DEPLOYMENT_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.mockRepositoryService)).deleteDeployment("aDeploymentId", true, true, false);
    }

    @Test
    public void testDeleteDeploymentSkipIoMappings() {
        RestAssured.given().pathParam("id", (Object)"aDeploymentId").queryParam("cascade", new Object[]{true}).queryParam("skipIoMappings", new Object[]{true}).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(DEPLOYMENT_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.mockRepositoryService)).deleteDeployment("aDeploymentId", true, false, true);
    }

    @Test
    public void testDeleteDeploymentSkipIoMappingsFalse() {
        RestAssured.given().pathParam("id", (Object)"aDeploymentId").queryParam("cascade", new Object[]{true}).queryParam("skipIoMappings", new Object[]{false}).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(DEPLOYMENT_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.mockRepositoryService)).deleteDeployment("aDeploymentId", true, false, false);
    }

    @Test
    public void testDeleteNonExistingDeployment() {
        Mockito.when((Object)this.mockDeploymentQuery.deploymentId("aNonExistingDeploymentId")).thenReturn((Object)this.mockDeploymentQuery);
        Mockito.when((Object)this.mockDeploymentQuery.singleResult()).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"aNonExistingDeploymentId").expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(CoreMatchers.containsString((String)"Deployment with id 'aNonExistingDeploymentId' do not exist"), new Matcher[0]).when().delete(DEPLOYMENT_URL, new Object[0]);
    }

    @Test
    public void testDeleteDeploymentThrowsAuthorizationException() {
        String message = "expected exception";
        ((RepositoryService)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.mockRepositoryService)).deleteDeployment("aDeploymentId", false, false, false);
        RestAssured.given().pathParam("id", (Object)"aDeploymentId").expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().delete(DEPLOYMENT_URL, new Object[0]);
    }

    @Test
    public void testRedeployDeployment() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<String> resourceIds = new ArrayList<String>();
        resourceIds.add("first-resource-id");
        resourceIds.add("second-resource-id");
        json.put("resourceIds", resourceIds);
        ArrayList<String> resourceNames = new ArrayList<String>();
        resourceNames.add("first-resource-name");
        resourceNames.add("second-resource-name");
        json.put("resourceNames", resourceNames);
        json.put("source", "aDeploymentSource");
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").contentType(POST_JSON_CONTENT_TYPE).body(json).expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().post(REDEPLOY_DEPLOYMENT_URL, new Object[0]);
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder, (VerificationMode)Mockito.never())).addDeploymentResources(org.mockito.Matchers.anyString());
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).nameFromDeployment((String)org.mockito.Matchers.eq((Object)"aDeploymentId"));
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder, (VerificationMode)Mockito.never())).addDeploymentResourceById(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyString());
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).addDeploymentResourcesById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (List)org.mockito.Matchers.eq(resourceIds));
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder, (VerificationMode)Mockito.never())).addDeploymentResourceByName(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyString());
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).addDeploymentResourcesByName((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (List)org.mockito.Matchers.eq(resourceNames));
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).source("aDeploymentSource");
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).deployWithResult();
        this.verifyDeployment(this.mockDeployment, response);
    }

    @Test
    public void testRedeployDeploymentWithoutRequestBody() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").contentType(POST_JSON_CONTENT_TYPE).expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().post(REDEPLOY_DEPLOYMENT_URL, new Object[0]);
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).addDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"));
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).nameFromDeployment((String)org.mockito.Matchers.eq((Object)"aDeploymentId"));
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder, (VerificationMode)Mockito.never())).addDeploymentResourceById(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyString());
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder, (VerificationMode)Mockito.never())).addDeploymentResourcesById(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyListOf(String.class));
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder, (VerificationMode)Mockito.never())).addDeploymentResourceByName(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyString());
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder, (VerificationMode)Mockito.never())).addDeploymentResourcesByName(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyListOf(String.class));
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder, (VerificationMode)Mockito.never())).source(org.mockito.Matchers.anyString());
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).deployWithResult();
        this.verifyDeployment(this.mockDeployment, response);
    }

    @Test
    public void testRedeployDeploymentEmptyRequestBody() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").contentType(POST_JSON_CONTENT_TYPE).body("{}").expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().post(REDEPLOY_DEPLOYMENT_URL, new Object[0]);
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).addDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"));
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).nameFromDeployment((String)org.mockito.Matchers.eq((Object)"aDeploymentId"));
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder, (VerificationMode)Mockito.never())).addDeploymentResourceById(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyString());
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder, (VerificationMode)Mockito.never())).addDeploymentResourcesById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), org.mockito.Matchers.anyListOf(String.class));
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder, (VerificationMode)Mockito.never())).addDeploymentResourceByName(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyString());
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder, (VerificationMode)Mockito.never())).addDeploymentResourcesByName((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), org.mockito.Matchers.anyListOf(String.class));
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).source(null);
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).deployWithResult();
        this.verifyDeployment(this.mockDeployment, response);
    }

    @Test
    public void testRedeployDeploymentResourceIds() {
        HashMap json = new HashMap();
        ArrayList<String> resourceIds = new ArrayList<String>();
        resourceIds.add("first-resource-id");
        resourceIds.add("second-resource-id");
        json.put("resourceIds", resourceIds);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").contentType(POST_JSON_CONTENT_TYPE).body(json).expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().post(REDEPLOY_DEPLOYMENT_URL, new Object[0]);
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder, (VerificationMode)Mockito.never())).addDeploymentResources(org.mockito.Matchers.anyString());
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).nameFromDeployment((String)org.mockito.Matchers.eq((Object)"aDeploymentId"));
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder, (VerificationMode)Mockito.never())).addDeploymentResourceById(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyString());
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).addDeploymentResourcesById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (List)org.mockito.Matchers.eq(resourceIds));
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder, (VerificationMode)Mockito.never())).addDeploymentResourceByName(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyString());
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder, (VerificationMode)Mockito.never())).addDeploymentResourcesByName((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), org.mockito.Matchers.anyListOf(String.class));
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).source(null);
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).deployWithResult();
        this.verifyDeployment(this.mockDeployment, response);
    }

    @Test
    public void testRedeployDeploymentResourceNames() {
        HashMap json = new HashMap();
        ArrayList<String> resourceNames = new ArrayList<String>();
        resourceNames.add("first-resource-name");
        resourceNames.add("second-resource-name");
        json.put("resourceNames", resourceNames);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").contentType(POST_JSON_CONTENT_TYPE).body(json).expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().post(REDEPLOY_DEPLOYMENT_URL, new Object[0]);
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder, (VerificationMode)Mockito.never())).addDeploymentResources(org.mockito.Matchers.anyString());
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).nameFromDeployment((String)org.mockito.Matchers.eq((Object)"aDeploymentId"));
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder, (VerificationMode)Mockito.never())).addDeploymentResourceById(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyString());
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder, (VerificationMode)Mockito.never())).addDeploymentResourcesById((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), org.mockito.Matchers.anyListOf(String.class));
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder, (VerificationMode)Mockito.never())).addDeploymentResourceByName(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyString());
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).addDeploymentResourcesByName((String)org.mockito.Matchers.eq((Object)"aDeploymentId"), (List)org.mockito.Matchers.eq(resourceNames));
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).source(null);
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).deployWithResult();
        this.verifyDeployment(this.mockDeployment, response);
    }

    @Test
    public void testRedeployDeploymentSource() {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("source", "aDeploymentSource");
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").contentType(POST_JSON_CONTENT_TYPE).body(json).expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().post(REDEPLOY_DEPLOYMENT_URL, new Object[0]);
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).addDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"));
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).nameFromDeployment((String)org.mockito.Matchers.eq((Object)"aDeploymentId"));
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder, (VerificationMode)Mockito.never())).addDeploymentResourceById(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyString());
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder, (VerificationMode)Mockito.never())).addDeploymentResourcesById(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyListOf(String.class));
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder, (VerificationMode)Mockito.never())).addDeploymentResourceByName(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyString());
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder, (VerificationMode)Mockito.never())).addDeploymentResourcesByName(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyListOf(String.class));
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).source((String)org.mockito.Matchers.eq((Object)"aDeploymentSource"));
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).deployWithResult();
        this.verifyDeployment(this.mockDeployment, response);
    }

    @Test
    public void testRedeployDeploymentWithoutTenantId() {
        Mockito.when((Object)this.mockDeployment.getTenantId()).thenReturn(null);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").contentType(POST_JSON_CONTENT_TYPE).expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().post(REDEPLOY_DEPLOYMENT_URL, new Object[0]);
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).addDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"));
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder, (VerificationMode)Mockito.never())).tenantId((String)org.mockito.Matchers.any(String.class));
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).deployWithResult();
        this.verifyDeployment(this.mockDeployment, response);
    }

    @Test
    public void testRedeployDeploymentWithTenantId() {
        Mockito.when((Object)this.mockDeployment.getTenantId()).thenReturn((Object)"aTenantId");
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDeploymentId").contentType(POST_JSON_CONTENT_TYPE).expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().post(REDEPLOY_DEPLOYMENT_URL, new Object[0]);
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).addDeploymentResources((String)org.mockito.Matchers.eq((Object)"aDeploymentId"));
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).tenantId((String)org.mockito.Matchers.eq((Object)"aTenantId"));
        ((DeploymentBuilder)Mockito.verify((Object)this.mockDeploymentBuilder)).deployWithResult();
        this.verifyDeployment(this.mockDeployment, response);
    }

    @Test
    public void testRedeployThrowsNotFoundException() {
        String message = "deployment not found";
        ((DeploymentBuilder)Mockito.doThrow((Throwable)new NotFoundException(message)).when((Object)this.mockDeploymentBuilder)).deployWithResult();
        String expected = "Cannot redeploy deployment 'aDeploymentId': " + message;
        RestAssured.given().pathParam("id", (Object)"aDeploymentId").contentType(POST_JSON_CONTENT_TYPE).expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expected), new Object[0]).when().post(REDEPLOY_DEPLOYMENT_URL, new Object[0]);
    }

    @Test
    public void testRedeployThrowsNotValidException() {
        String message = "not valid";
        ((DeploymentBuilder)Mockito.doThrow((Throwable)new NotValidException(message)).when((Object)this.mockDeploymentBuilder)).deployWithResult();
        String expected = "Cannot redeploy deployment 'aDeploymentId': " + message;
        RestAssured.given().pathParam("id", (Object)"aDeploymentId").contentType(POST_JSON_CONTENT_TYPE).expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expected), new Object[0]).when().post(REDEPLOY_DEPLOYMENT_URL, new Object[0]);
    }

    @Test
    public void testRedeployThrowsProcessEngineException() {
        String message = "something went wrong";
        ((DeploymentBuilder)Mockito.doThrow((Throwable)new ProcessEngineException(message)).when((Object)this.mockDeploymentBuilder)).deployWithResult();
        RestAssured.given().pathParam("id", (Object)"aDeploymentId").contentType(POST_JSON_CONTENT_TYPE).expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().post(REDEPLOY_DEPLOYMENT_URL, new Object[0]);
    }

    @Test
    public void testRedeployThrowsAuthorizationException() {
        String message = "missing authorization";
        ((DeploymentBuilder)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.mockDeploymentBuilder)).deployWithResult();
        RestAssured.given().pathParam("id", (Object)"aDeploymentId").contentType(POST_JSON_CONTENT_TYPE).expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().post(REDEPLOY_DEPLOYMENT_URL, new Object[0]);
    }

    private void verifyDeployment(Deployment mockDeployment, Response response) {
        String content = response.asString();
        this.verifyDeploymentValues(mockDeployment, content);
    }

    private void verifyCreatedDeployment(Deployment mockDeployment, Response response) {
        String content = response.asString();
        this.verifyDeploymentWithDefinitionsValues(mockDeployment, content);
        this.verifyDeploymentLink(mockDeployment, content);
    }

    private void verifyCreatedBpmnDeployment(Deployment mockDeployment, Response response) {
        String content = response.asString();
        this.verifyBpmnDeploymentValues(mockDeployment, content);
        this.verifyDeploymentLink(mockDeployment, content);
    }

    private void verifyCreatedCmmnDeployment(Deployment mockDeployment, Response response) {
        String content = response.asString();
        this.verifyCmmnDeploymentValues(mockDeployment, content);
        this.verifyDeploymentLink(mockDeployment, content);
    }

    private void verifyCreatedDmnDeployment(Deployment mockDeployment, Response response) {
        String content = response.asString();
        this.verifyDmnDeploymentValues(mockDeployment, content);
        this.verifyDeploymentLink(mockDeployment, content);
    }

    private void verifyCreatedDrdDeployment(Deployment mockDeployment, Response response) {
        String content = response.asString();
        this.verifyDrdDeploymentValues(mockDeployment, content);
        this.verifyDeploymentLink(mockDeployment, content);
    }

    private void verifyCreatedEmptyDeployment(Deployment mockDeployment, Response response) {
        String content = response.asString();
        this.verifyDeploymentValuesEmptyDefinitions(mockDeployment, content);
        this.verifyDeploymentLink(mockDeployment, content);
    }

    private void verifyDeploymentValues(Deployment mockDeployment, String responseContent) {
        JsonPath path = JsonPath.from((String)responseContent);
        this.verifyStandardDeploymentValues(mockDeployment, path);
    }

    private void verifyDeploymentWithDefinitionsValues(Deployment mockDeployment, String responseContent) {
        JsonPath path = JsonPath.from((String)responseContent);
        this.verifyStandardDeploymentValues(mockDeployment, path);
        Map deployedProcessDefinitions = path.getMap(PROPERTY_DEPLOYED_PROCESS_DEFINITIONS);
        Map deployedCaseDefinitions = path.getMap(PROPERTY_DEPLOYED_CASE_DEFINITIONS);
        Map deployedDecisionDefinitions = path.getMap(PROPERTY_DEPLOYED_DECISION_DEFINITIONS);
        Map deployedDecisionRequirementsDefinitions = path.getMap(PROPERTY_DEPLOYED_DECISION_REQUIREMENTS_DEFINITIONS);
        Assert.assertEquals((long)1L, (long)deployedProcessDefinitions.size());
        Assert.assertNotNull(deployedProcessDefinitions.get("aProcDefId"));
        Assert.assertEquals((long)1L, (long)deployedCaseDefinitions.size());
        Assert.assertNotNull(deployedCaseDefinitions.get("aCaseDefnitionId"));
        Assert.assertEquals((long)1L, (long)deployedDecisionDefinitions.size());
        Assert.assertNotNull(deployedDecisionDefinitions.get("aDecisionDefinitionId"));
        Assert.assertEquals((long)1L, (long)deployedDecisionRequirementsDefinitions.size());
        Assert.assertNotNull(deployedDecisionRequirementsDefinitions.get("aDecisionRequirementsDefinitionId"));
    }

    private void verifyBpmnDeploymentValues(Deployment mockDeployment, String responseContent) {
        JsonPath path = JsonPath.from((String)responseContent);
        this.verifyStandardDeploymentValues(mockDeployment, path);
        Map deployedProcessDefinitionDtos = path.getMap(PROPERTY_DEPLOYED_PROCESS_DEFINITIONS);
        Assert.assertEquals((long)1L, (long)deployedProcessDefinitionDtos.size());
        HashMap processDefinitionDto = (HashMap)deployedProcessDefinitionDtos.get("aProcDefId");
        Assert.assertNotNull((Object)processDefinitionDto);
        this.verifyBpmnDeployment(processDefinitionDto);
        Assert.assertNull((Object)path.get(PROPERTY_DEPLOYED_CASE_DEFINITIONS));
        Assert.assertNull((Object)path.get(PROPERTY_DEPLOYED_DECISION_DEFINITIONS));
        Assert.assertNull((Object)path.get(PROPERTY_DEPLOYED_DECISION_REQUIREMENTS_DEFINITIONS));
    }

    private void verifyCmmnDeploymentValues(Deployment mockDeployment, String responseContent) {
        JsonPath path = JsonPath.from((String)responseContent);
        this.verifyStandardDeploymentValues(mockDeployment, path);
        Map deployedCaseDefinitions = path.getMap(PROPERTY_DEPLOYED_CASE_DEFINITIONS);
        Assert.assertEquals((long)1L, (long)deployedCaseDefinitions.size());
        HashMap caseDefinitionDto = (HashMap)deployedCaseDefinitions.get("aCaseDefnitionId");
        Assert.assertNotNull((Object)caseDefinitionDto);
        this.verifyCmnDeployment(caseDefinitionDto);
        Assert.assertNull((Object)path.get(PROPERTY_DEPLOYED_PROCESS_DEFINITIONS));
        Assert.assertNull((Object)path.get(PROPERTY_DEPLOYED_DECISION_DEFINITIONS));
        Assert.assertNull((Object)path.get(PROPERTY_DEPLOYED_DECISION_REQUIREMENTS_DEFINITIONS));
    }

    private void verifyDmnDeploymentValues(Deployment mockDeployment, String responseContent) {
        JsonPath path = JsonPath.from((String)responseContent);
        this.verifyStandardDeploymentValues(mockDeployment, path);
        Map deployedDecisionDefinitions = path.getMap(PROPERTY_DEPLOYED_DECISION_DEFINITIONS);
        Assert.assertEquals((long)1L, (long)deployedDecisionDefinitions.size());
        HashMap decisionDefinitionDto = (HashMap)deployedDecisionDefinitions.get("aDecisionDefinitionId");
        Assert.assertNotNull((Object)decisionDefinitionDto);
        this.verifyDmnDeployment(decisionDefinitionDto);
        Assert.assertNull((Object)path.get(PROPERTY_DEPLOYED_DECISION_REQUIREMENTS_DEFINITIONS));
        Assert.assertNull((Object)path.get(PROPERTY_DEPLOYED_PROCESS_DEFINITIONS));
        Assert.assertNull((Object)path.get(PROPERTY_DEPLOYED_CASE_DEFINITIONS));
    }

    private void verifyDrdDeploymentValues(Deployment mockDeployment, String responseContent) {
        JsonPath path = JsonPath.from((String)responseContent);
        this.verifyStandardDeploymentValues(mockDeployment, path);
        Map deployedDecisionDefinitions = path.getMap(PROPERTY_DEPLOYED_DECISION_DEFINITIONS);
        Map deployedDecisionRequirementsDefinitions = path.getMap(PROPERTY_DEPLOYED_DECISION_REQUIREMENTS_DEFINITIONS);
        Assert.assertEquals((long)1L, (long)deployedDecisionDefinitions.size());
        HashMap decisionDefinitionDto = (HashMap)deployedDecisionDefinitions.get("aDecisionDefinitionId");
        Assert.assertNotNull((Object)decisionDefinitionDto);
        this.verifyDmnDeployment(decisionDefinitionDto);
        Assert.assertEquals((long)1L, (long)deployedDecisionRequirementsDefinitions.size());
        HashMap decisionRequirementsDefinitionDto = (HashMap)deployedDecisionRequirementsDefinitions.get("aDecisionRequirementsDefinitionId");
        Assert.assertNotNull((Object)decisionRequirementsDefinitionDto);
        this.verifyDrdDeployment(decisionRequirementsDefinitionDto);
        Assert.assertNull((Object)path.get(PROPERTY_DEPLOYED_PROCESS_DEFINITIONS));
        Assert.assertNull((Object)path.get(PROPERTY_DEPLOYED_CASE_DEFINITIONS));
    }

    private void verifyBpmnDeployment(HashMap<String, Object> dto) {
        Assert.assertEquals((Object)dto.get("id"), (Object)"aProcDefId");
        Assert.assertEquals((Object)dto.get("category"), (Object)"aCategory");
        Assert.assertEquals((Object)dto.get("name"), (Object)"aName");
        Assert.assertEquals((Object)dto.get("key"), (Object)"aKey");
        Assert.assertEquals((Object)dto.get("description"), (Object)"aDescription");
        Assert.assertEquals((Object)dto.get("version"), (Object)42);
        Assert.assertEquals((Object)dto.get("resource"), (Object)"aResourceName");
        Assert.assertEquals((Object)dto.get("deploymentId"), (Object)"aDeploymentId");
        Assert.assertEquals((Object)dto.get("diagram"), (Object)"aResourceName.png");
        Assert.assertEquals((Object)dto.get("suspended"), (Object)true);
    }

    private void verifyCmnDeployment(HashMap<String, Object> dto) {
        Assert.assertEquals((Object)dto.get("id"), (Object)"aCaseDefnitionId");
        Assert.assertEquals((Object)dto.get("category"), (Object)"aCaseDefinitionCategory");
        Assert.assertEquals((Object)dto.get("name"), (Object)"aCaseDefinitionName");
        Assert.assertEquals((Object)dto.get("key"), (Object)"aCaseDefinitionKey");
        Assert.assertEquals((Object)dto.get("version"), (Object)1);
        Assert.assertEquals((Object)dto.get("resource"), (Object)"aCaseDefinitionResourceName");
        Assert.assertEquals((Object)dto.get("deploymentId"), (Object)"aDeploymentId");
    }

    private void verifyDmnDeployment(HashMap<String, Object> dto) {
        Assert.assertEquals((Object)dto.get("id"), (Object)"aDecisionDefinitionId");
        Assert.assertEquals((Object)dto.get("category"), (Object)"aDecisionDefinitionCategory");
        Assert.assertEquals((Object)dto.get("name"), (Object)"aDecisionDefinitionName");
        Assert.assertEquals((Object)dto.get("key"), (Object)"aDecisionDefinitionKey");
        Assert.assertEquals((Object)dto.get("version"), (Object)1);
        Assert.assertEquals((Object)dto.get("resource"), (Object)"aDecisionDefinitionResourceName");
        Assert.assertEquals((Object)dto.get("deploymentId"), (Object)"aDeploymentId");
        Assert.assertEquals((Object)dto.get("decisionRequirementsDefinitionId"), (Object)"aDecisionRequirementsDefinitionId");
        Assert.assertEquals((Object)dto.get("decisionRequirementsDefinitionKey"), (Object)"aDecisionRequirementsDefinitionKey");
    }

    private void verifyDrdDeployment(HashMap<String, Object> dto) {
        Assert.assertEquals((Object)dto.get("id"), (Object)"aDecisionRequirementsDefinitionId");
        Assert.assertEquals((Object)dto.get("category"), (Object)"aDecisionRequirementsDefinitionCategory");
        Assert.assertEquals((Object)dto.get("name"), (Object)"aDecisionRequirementsDefinitionName");
        Assert.assertEquals((Object)dto.get("key"), (Object)"aDecisionRequirementsDefinitionKey");
        Assert.assertEquals((Object)dto.get("version"), (Object)1);
        Assert.assertEquals((Object)dto.get("resource"), (Object)"aDecisionRequirementsDefinitionResourceName");
        Assert.assertEquals((Object)dto.get("deploymentId"), (Object)"aDeploymentId");
    }

    private void verifyDeploymentValuesEmptyDefinitions(Deployment mockDeployment, String responseContent) {
        JsonPath path = JsonPath.from((String)responseContent);
        this.verifyStandardDeploymentValues(mockDeployment, path);
        Assert.assertNull((Object)path.get(PROPERTY_DEPLOYED_PROCESS_DEFINITIONS));
        Assert.assertNull((Object)path.get(PROPERTY_DEPLOYED_CASE_DEFINITIONS));
        Assert.assertNull((Object)path.get(PROPERTY_DEPLOYED_DECISION_DEFINITIONS));
        Assert.assertNull((Object)path.get(PROPERTY_DEPLOYED_DECISION_REQUIREMENTS_DEFINITIONS));
    }

    private void verifyStandardDeploymentValues(Deployment mockDeployment, JsonPath path) {
        String returnedId = (String)path.get("id");
        String returnedName = (String)path.get("name");
        Date returnedDeploymentTime = DateTimeUtil.parseDate((String)((String)path.get("deploymentTime")));
        Assert.assertEquals((Object)mockDeployment.getId(), (Object)returnedId);
        Assert.assertEquals((Object)mockDeployment.getName(), (Object)returnedName);
        Assert.assertEquals((Object)mockDeployment.getDeploymentTime(), (Object)returnedDeploymentTime);
    }

    private void verifyDeploymentLink(Deployment mockDeployment, String responseContent) {
        List returnedLinks = JsonPath.from((String)responseContent).getList("links");
        Assert.assertEquals((long)1L, (long)returnedLinks.size());
        Map returnedLink = (Map)returnedLinks.get(0);
        Assert.assertEquals((Object)"GET", returnedLink.get("method"));
        Assert.assertTrue((boolean)((String)returnedLink.get("href")).endsWith("/rest-test/deployment/" + mockDeployment.getId()));
        Assert.assertEquals((Object)"self", returnedLink.get("rel"));
    }

    private void verifyDeploymentResource(Resource mockDeploymentResource, Response response) {
        String content = response.asString();
        JsonPath path = JsonPath.from((String)content);
        String returnedId = (String)path.get("id");
        String returnedName = (String)path.get("name");
        String returnedDeploymentId = (String)path.get("deploymentId");
        Assert.assertEquals((Object)mockDeploymentResource.getId(), (Object)returnedId);
        Assert.assertEquals((Object)mockDeploymentResource.getName(), (Object)returnedName);
        Assert.assertEquals((Object)mockDeploymentResource.getDeploymentId(), (Object)returnedDeploymentId);
    }

    private void verifyDeploymentResources(List<Resource> mockDeploymentResources, Response response) {
        List list = (List)response.as(List.class);
        Assert.assertEquals((long)1L, (long)list.size());
        LinkedHashMap resourceHashMap = (LinkedHashMap)list.get(0);
        String returnedId = (String)resourceHashMap.get("id");
        String returnedName = (String)resourceHashMap.get("name");
        String returnedDeploymentId = (String)resourceHashMap.get("deploymentId");
        Resource mockDeploymentResource = mockDeploymentResources.get(0);
        Assert.assertEquals((Object)mockDeploymentResource.getId(), (Object)returnedId);
        Assert.assertEquals((Object)mockDeploymentResource.getName(), (Object)returnedName);
        Assert.assertEquals((Object)mockDeploymentResource.getDeploymentId(), (Object)returnedDeploymentId);
    }
}

