/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.management.UpdateJobSuspensionStateSelectBuilder;
import org.camunda.bpm.engine.management.UpdateJobSuspensionStateTenantBuilder;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.dto.batch.BatchDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricProcessInstanceQueryDto;
import org.camunda.bpm.engine.rest.dto.runtime.JobSuspensionStateDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.helper.MockJobBuilder;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.JsonPathUtil;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class JobRestServiceInteractionTest
extends AbstractRestServiceTest {
    private static final String RETRIES = "retries";
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String JOB_RESOURCE_URL = "/rest-test/job";
    protected static final String SINGLE_JOB_RESOURCE_URL = "/rest-test/job/{id}";
    protected static final String JOB_RESOURCE_SET_RETRIES_URL = "/rest-test/job/{id}/retries";
    protected static final String JOBS_SET_RETRIES_URL = "/rest-test/job/retries";
    protected static final String JOB_RESOURCE_SET_PRIORITY_URL = "/rest-test/job/{id}/priority";
    protected static final String JOB_RESOURCE_EXECUTE_JOB_URL = "/rest-test/job/{id}/execute";
    protected static final String JOB_RESOURCE_GET_STACKTRACE_URL = "/rest-test/job/{id}/stacktrace";
    protected static final String JOB_RESOURCE_SET_DUEDATE_URL = "/rest-test/job/{id}/duedate";
    protected static final String SINGLE_JOB_SUSPENDED_URL = "/rest-test/job/{id}/suspended";
    protected static final String JOB_SUSPENDED_URL = "/rest-test/job/suspended";
    private ProcessEngine namedProcessEngine;
    private ManagementService mockManagementService;
    private UpdateJobSuspensionStateTenantBuilder mockSuspensionStateBuilder;
    private UpdateJobSuspensionStateSelectBuilder mockSuspensionStateSelectBuilder;
    private JobQuery mockQuery;

    @Before
    public void setUpRuntimeData() {
        this.mockQuery = (JobQuery)Mockito.mock(JobQuery.class);
        Job mockedJob = new MockJobBuilder().id("aJobId").processInstanceId("aProcInstId").executionId("anExecutionId").retries(3).exceptionMessage("").dueDate(new Date()).priority(2147483689L).jobDefinitionId("aJobDefId").tenantId("aTenantId").createTime(DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_JOB_CREATE_TIME)).build();
        Mockito.when((Object)this.mockQuery.singleResult()).thenReturn((Object)mockedJob);
        Mockito.when((Object)this.mockQuery.jobId("aJobId")).thenReturn((Object)this.mockQuery);
        this.mockManagementService = (ManagementService)Mockito.mock(ManagementService.class);
        Mockito.when((Object)this.mockManagementService.createJobQuery()).thenReturn((Object)this.mockQuery);
        this.mockSuspensionStateSelectBuilder = (UpdateJobSuspensionStateSelectBuilder)Mockito.mock(UpdateJobSuspensionStateSelectBuilder.class);
        Mockito.when((Object)this.mockManagementService.updateJobSuspensionState()).thenReturn((Object)this.mockSuspensionStateSelectBuilder);
        this.mockSuspensionStateBuilder = (UpdateJobSuspensionStateTenantBuilder)Mockito.mock(UpdateJobSuspensionStateTenantBuilder.class);
        Mockito.when((Object)this.mockSuspensionStateSelectBuilder.byJobId(org.mockito.Matchers.anyString())).thenReturn((Object)this.mockSuspensionStateBuilder);
        Mockito.when((Object)this.mockSuspensionStateSelectBuilder.byJobDefinitionId(org.mockito.Matchers.anyString())).thenReturn((Object)this.mockSuspensionStateBuilder);
        Mockito.when((Object)this.mockSuspensionStateSelectBuilder.byProcessInstanceId(org.mockito.Matchers.anyString())).thenReturn((Object)this.mockSuspensionStateBuilder);
        Mockito.when((Object)this.mockSuspensionStateSelectBuilder.byProcessDefinitionId(org.mockito.Matchers.anyString())).thenReturn((Object)this.mockSuspensionStateBuilder);
        Mockito.when((Object)this.mockSuspensionStateSelectBuilder.byProcessDefinitionKey(org.mockito.Matchers.anyString())).thenReturn((Object)this.mockSuspensionStateBuilder);
        this.namedProcessEngine = this.getProcessEngine("default");
        Mockito.when((Object)this.namedProcessEngine.getManagementService()).thenReturn((Object)this.mockManagementService);
    }

    @Test
    public void testSetJobRetries() {
        HashMap<String, Integer> retriesVariableJson = new HashMap<String, Integer>();
        retriesVariableJson.put(RETRIES, 3);
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body(retriesVariableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_RESOURCE_SET_RETRIES_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).setJobRetries("aJobId", 3);
    }

    @Test
    public void testSetJobRetriesNonExistentJob() {
        String expectedMessage = "No job found with id 'aNonExistingJobId'.";
        ((ManagementService)Mockito.doThrow((Throwable)new ProcessEngineException(expectedMessage)).when((Object)this.mockManagementService)).setJobRetries("aNonExistingJobId", 3);
        HashMap<String, Integer> retriesVariableJson = new HashMap<String, Integer>();
        retriesVariableJson.put(RETRIES, 3);
        RestAssured.given().pathParam("id", (Object)"aNonExistingJobId").contentType(ContentType.JSON).body(retriesVariableJson).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)expectedMessage), new Object[0]).when().put(JOB_RESOURCE_SET_RETRIES_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).setJobRetries("aNonExistingJobId", 3);
    }

    @Test
    public void testSetJobRetriesNegativeRetries() {
        String expectedMessage = "The number of job retries must be a non-negative Integer, but '-3' has been provided.";
        ((ManagementService)Mockito.doThrow((Throwable)new ProcessEngineException(expectedMessage)).when((Object)this.mockManagementService)).setJobRetries("aJobId", -3);
        HashMap<String, Integer> retriesVariableJson = new HashMap<String, Integer>();
        retriesVariableJson.put(RETRIES, -3);
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body(retriesVariableJson).then().then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)expectedMessage), new Object[0]).when().put(JOB_RESOURCE_SET_RETRIES_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).setJobRetries("aJobId", -3);
    }

    @Test
    public void testSetJobRetriesThrowsAuthorizationException() {
        String message = "expected exception";
        ((ManagementService)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.mockManagementService)).setJobRetries(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyInt());
        HashMap<String, Integer> retriesVariableJson = new HashMap<String, Integer>();
        retriesVariableJson.put(RETRIES, -3);
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body(retriesVariableJson).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().put(JOB_RESOURCE_SET_RETRIES_URL, new Object[0]);
    }

    @Test
    public void testSimpleJobGet() {
        RestAssured.given().pathParam("id", (Object)"aJobId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)"aJobId"), new Object[0]).body("processInstanceId", Matchers.equalTo((Object)"aProcInstId"), new Object[0]).body("executionId", Matchers.equalTo((Object)"anExecutionId"), new Object[0]).body("exceptionMessage", Matchers.equalTo((Object)""), new Object[0]).body("priority", Matchers.equalTo((Object)2147483689L), new Object[0]).body("jobDefinitionId", Matchers.equalTo((Object)"aJobDefId"), new Object[0]).body("tenantId", Matchers.equalTo((Object)"aTenantId"), new Object[0]).body("createTime", Matchers.equalTo((Object)MockProvider.EXAMPLE_JOB_CREATE_TIME), new Object[0]).when().get(SINGLE_JOB_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        ((JobQuery)inOrder.verify((Object)this.mockQuery)).jobId("aJobId");
        ((JobQuery)inOrder.verify((Object)this.mockQuery)).singleResult();
    }

    @Test
    public void testJobGetIdDoesntExist() {
        JobQuery invalidQueryNonExistingJob = (JobQuery)Mockito.mock(JobQuery.class);
        Mockito.when((Object)this.mockManagementService.createJobQuery().jobId("aNonExistingJobId")).thenReturn((Object)invalidQueryNonExistingJob);
        Mockito.when((Object)invalidQueryNonExistingJob.singleResult()).thenReturn(null);
        String jobId = "aNonExistingJobId";
        RestAssured.given().pathParam("id", (Object)jobId).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)("Job with id " + jobId + " does not exist")), new Object[0]).when().get(SINGLE_JOB_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testExecuteJob() {
        RestAssured.given().pathParam("id", (Object)"aJobId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(JOB_RESOURCE_EXECUTE_JOB_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).executeJob("aJobId");
    }

    @Test
    public void testExecuteJobIdDoesntExist() {
        String jobId = "aNonExistingJobId";
        String expectedMessage = "No job found with id '" + jobId + "'";
        ((ManagementService)Mockito.doThrow((Throwable)new ProcessEngineException(expectedMessage)).when((Object)this.mockManagementService)).executeJob("aNonExistingJobId");
        RestAssured.given().pathParam("id", (Object)jobId).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)expectedMessage), new Object[0]).when().post(JOB_RESOURCE_EXECUTE_JOB_URL, new Object[0]);
    }

    @Test
    public void testExecuteJobRuntimeException() {
        String jobId = "aJobId";
        ((ManagementService)Mockito.doThrow((Throwable)new RuntimeException("Runtime exception")).when((Object)this.mockManagementService)).executeJob(jobId);
        RestAssured.given().pathParam("id", (Object)jobId).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Runtime exception"), new Object[0]).when().post(JOB_RESOURCE_EXECUTE_JOB_URL, new Object[0]);
    }

    @Test
    public void testExecuteJobThrowsAuthorizationException() {
        String message = "expected exception";
        ((ManagementService)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.mockManagementService)).executeJob(org.mockito.Matchers.anyString());
        RestAssured.given().pathParam("id", (Object)"aJobId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(JOB_RESOURCE_EXECUTE_JOB_URL, new Object[0]);
    }

    @Test
    public void testGetStacktrace() {
        String stacktrace = "aStacktrace";
        Mockito.when((Object)this.mockManagementService.getJobExceptionStacktrace("aJobId")).thenReturn((Object)stacktrace);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aJobId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.TEXT).when().get(JOB_RESOURCE_GET_STACKTRACE_URL, new Object[0]);
        String content = response.asString();
        Assert.assertEquals((Object)stacktrace, (Object)content);
    }

    @Test
    public void testGetStacktraceJobNotFound() {
        String exceptionMessage = "job not found";
        ((ManagementService)Mockito.doThrow((Throwable)new ProcessEngineException(exceptionMessage)).when((Object)this.mockManagementService)).getJobExceptionStacktrace("aJobId");
        RestAssured.given().pathParam("id", (Object)"aJobId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)exceptionMessage), new Object[0]).when().get(JOB_RESOURCE_GET_STACKTRACE_URL, new Object[0]);
    }

    @Test
    public void testGetStacktraceJobThrowsAuthorizationException() {
        String message = "expected exception";
        ((ManagementService)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.mockManagementService)).getJobExceptionStacktrace("aJobId");
        RestAssured.given().pathParam("id", (Object)"aJobId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().get(JOB_RESOURCE_GET_STACKTRACE_URL, new Object[0]);
    }

    @Test
    public void testSetJobDuedate() {
        Date newDuedate = MockProvider.createMockDuedate();
        HashMap<String, Date> duedateVariableJson = new HashMap<String, Date>();
        duedateVariableJson.put("duedate", newDuedate);
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body(duedateVariableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_RESOURCE_SET_DUEDATE_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).setJobDuedate("aJobId", newDuedate);
    }

    @Test
    public void testSetJobDuedateNull() {
        HashMap<String, Object> duedateVariableJson = new HashMap<String, Object>();
        duedateVariableJson.put("duedate", null);
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body(duedateVariableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_RESOURCE_SET_DUEDATE_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).setJobDuedate("aJobId", null);
    }

    @Test
    public void testSetJobDuedateNonExistentJob() {
        Date newDuedate = MockProvider.createMockDuedate();
        String expectedMessage = "No job found with id 'aNonExistingJobId'.";
        ((ManagementService)Mockito.doThrow((Throwable)new ProcessEngineException(expectedMessage)).when((Object)this.mockManagementService)).setJobDuedate("aNonExistingJobId", newDuedate);
        HashMap<String, Date> duedateVariableJson = new HashMap<String, Date>();
        duedateVariableJson.put("duedate", newDuedate);
        RestAssured.given().pathParam("id", (Object)"aNonExistingJobId").contentType(ContentType.JSON).body(duedateVariableJson).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)expectedMessage), new Object[0]).when().put(JOB_RESOURCE_SET_DUEDATE_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).setJobDuedate("aNonExistingJobId", newDuedate);
    }

    @Test
    public void testSetJobDuedateThrowsAuthorizationException() {
        String message = "expected exception";
        ((ManagementService)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.mockManagementService)).setJobDuedate(org.mockito.Matchers.anyString(), (Date)org.mockito.Matchers.any(Date.class));
        Date newDuedate = MockProvider.createMockDuedate();
        HashMap<String, Date> duedateVariableJson = new HashMap<String, Date>();
        duedateVariableJson.put("duedate", newDuedate);
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body(duedateVariableJson).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().put(JOB_RESOURCE_SET_DUEDATE_URL, new Object[0]);
    }

    @Test
    public void testActivateJob() {
        JobSuspensionStateDto dto = new JobSuspensionStateDto();
        dto.setSuspended(false);
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body((Object)dto).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_JOB_SUSPENDED_URL, new Object[0]);
        ((UpdateJobSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byJobId("aJobId");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).activate();
    }

    @Test
    public void testActivateThrowsProcessEngineException() {
        JobSuspensionStateDto dto = new JobSuspensionStateDto();
        dto.setSuspended(false);
        String expectedMessage = "expectedMessage";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable)new ProcessEngineException(expectedMessage)).when((Object)this.mockSuspensionStateBuilder)).activate();
        RestAssured.given().pathParam("id", (Object)"aNonExistingJobId").contentType(ContentType.JSON).body((Object)dto).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedMessage), new Object[0]).when().put(SINGLE_JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateThrowsAuthorizationException() {
        JobSuspensionStateDto dto = new JobSuspensionStateDto();
        dto.setSuspended(false);
        String expectedMessage = "expectedMessage";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable)new AuthorizationException(expectedMessage)).when((Object)this.mockSuspensionStateBuilder)).activate();
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body((Object)dto).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedMessage), new Object[0]).when().put(SINGLE_JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendJob() {
        JobSuspensionStateDto dto = new JobSuspensionStateDto();
        dto.setSuspended(true);
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body((Object)dto).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_JOB_SUSPENDED_URL, new Object[0]);
        ((UpdateJobSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byJobId("aJobId");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testSuspendedThrowsProcessEngineException() {
        JobSuspensionStateDto dto = new JobSuspensionStateDto();
        dto.setSuspended(true);
        String expectedMessage = "expectedMessage";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable)new ProcessEngineException(expectedMessage)).when((Object)this.mockSuspensionStateBuilder)).suspend();
        RestAssured.given().pathParam("id", (Object)"aNonExistingJobId").contentType(ContentType.JSON).body((Object)dto).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedMessage), new Object[0]).when().put(SINGLE_JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendWithMultipleByParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("jobDefinitionId", "aJobDefId");
        params.put("processInstanceId", "aProcInstId");
        params.put("processDefinitionId", "aProcDefId");
        params.put("processDefinitionKey", "aKey");
        String message = "Only one of jobId, jobDefinitionId, processInstanceId, processDefinitionId or processDefinitionKey should be set to update the suspension state.";
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().put(SINGLE_JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendThrowsAuthorizationException() {
        JobSuspensionStateDto dto = new JobSuspensionStateDto();
        dto.setSuspended(true);
        String expectedMessage = "expectedMessage";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable)new AuthorizationException(expectedMessage)).when((Object)this.mockSuspensionStateBuilder)).suspend();
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body((Object)dto).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedMessage), new Object[0]).when().put(SINGLE_JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateJobByProcessDefinitionKey() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionKey", "aKey");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_SUSPENDED_URL, new Object[0]);
        ((UpdateJobSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionKey("aKey");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).activate();
    }

    @Test
    public void testActivateJobByProcessDefinitionKeyWithException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionKey", "aKey");
        String expectedException = "expectedException";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable)new ProcessEngineException(expectedException)).when((Object)this.mockSuspensionStateBuilder)).activate();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateJobByProcessDefinitionKeyThrowsAuthorizationException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionKey", "aKey");
        String expectedException = "expectedException";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable)new AuthorizationException(expectedException)).when((Object)this.mockSuspensionStateBuilder)).activate();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendJobByProcessDefinitionKey() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionKey", "aKey");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_SUSPENDED_URL, new Object[0]);
        ((UpdateJobSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionKey("aKey");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testSuspendJobByProcessDefinitionKeyWithException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionKey", "aKey");
        String expectedException = "expectedException";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable)new ProcessEngineException(expectedException)).when((Object)this.mockSuspensionStateBuilder)).suspend();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendJobByProcessDefinitionKeyThrowsAuthorizationException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionKey", "aKey");
        String expectedException = "expectedException";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable)new AuthorizationException(expectedException)).when((Object)this.mockSuspensionStateBuilder)).suspend();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateJobByProcessDefinitionKeyAndTenantId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionKey", "aKey");
        params.put("processDefinitionTenantId", "aTenantId");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_SUSPENDED_URL, new Object[0]);
        ((UpdateJobSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionKey("aKey");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).processDefinitionTenantId("aTenantId");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).activate();
    }

    @Test
    public void testActivateJobByProcessDefinitionKeyWithoutTenantId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionKey", "aKey");
        params.put("processDefinitionWithoutTenantId", true);
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_SUSPENDED_URL, new Object[0]);
        ((UpdateJobSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionKey("aKey");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).processDefinitionWithoutTenantId();
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).activate();
    }

    @Test
    public void testSuspendJobByProcessDefinitionKeyAndTenantId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionKey", "aKey");
        params.put("processDefinitionTenantId", "aTenantId");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_SUSPENDED_URL, new Object[0]);
        ((UpdateJobSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionKey("aKey");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).processDefinitionTenantId("aTenantId");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testSuspendJobByProcessDefinitionKeyWithoutTenantId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionKey", "aKey");
        params.put("processDefinitionWithoutTenantId", true);
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_SUSPENDED_URL, new Object[0]);
        ((UpdateJobSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionKey("aKey");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).processDefinitionWithoutTenantId();
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testActivateJobByProcessDefinitionId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionId", "aProcDefId");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_SUSPENDED_URL, new Object[0]);
        ((UpdateJobSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionId("aProcDefId");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).activate();
    }

    @Test
    public void testActivateJobByProcessDefinitionIdWithException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionId", "aProcDefId");
        String expectedException = "expectedException";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable)new ProcessEngineException(expectedException)).when((Object)this.mockSuspensionStateBuilder)).activate();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateJobByProcessDefinitionIdThrowsAuthorizationException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionId", "aProcDefId");
        String expectedException = "expectedException";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable)new AuthorizationException(expectedException)).when((Object)this.mockSuspensionStateBuilder)).activate();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendJobByProcessDefinitionId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionId", "aProcDefId");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_SUSPENDED_URL, new Object[0]);
        ((UpdateJobSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessDefinitionId("aProcDefId");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testSuspendJobByProcessDefinitionIdWithException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionId", "aProcDefId");
        String expectedException = "expectedException";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable)new ProcessEngineException(expectedException)).when((Object)this.mockSuspensionStateBuilder)).suspend();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendJobByProcessDefinitionIdThrowsAuthorizationException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionId", "aProcDefId");
        String expectedException = "expectedException";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable)new AuthorizationException(expectedException)).when((Object)this.mockSuspensionStateBuilder)).suspend();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateJobByProcessInstanceId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processInstanceId", "aProcInstId");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_SUSPENDED_URL, new Object[0]);
        ((UpdateJobSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessInstanceId("aProcInstId");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).activate();
    }

    @Test
    public void testActivateJobByProcessInstanceIdWithException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processInstanceId", "aProcInstId");
        String expectedException = "expectedException";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable)new ProcessEngineException(expectedException)).when((Object)this.mockSuspensionStateBuilder)).activate();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateJobByProcessInstanceIdThrowsAuthorizationException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processInstanceId", "aProcInstId");
        String expectedException = "expectedException";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable)new AuthorizationException(expectedException)).when((Object)this.mockSuspensionStateBuilder)).activate();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendJobByProcessInstanceId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processInstanceId", "aProcInstId");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_SUSPENDED_URL, new Object[0]);
        ((UpdateJobSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byProcessInstanceId("aProcInstId");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testSuspendJobByProcessInstanceIdWithException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processInstanceId", "aProcInstId");
        String expectedException = "expectedException";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable)new ProcessEngineException(expectedException)).when((Object)this.mockSuspensionStateBuilder)).suspend();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendJobByProcessInstanceIdThrowsAuthorizationException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processInstanceId", "aProcInstId");
        String expectedException = "expectedException";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable)new AuthorizationException(expectedException)).when((Object)this.mockSuspensionStateBuilder)).suspend();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateJobByJobDefinitionId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("jobDefinitionId", "aJobDefId");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_SUSPENDED_URL, new Object[0]);
        ((UpdateJobSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byJobDefinitionId("aJobDefId");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).activate();
    }

    @Test
    public void testActivateJobByJobDefinitionIdThrowsAuthorizationException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("jobDefinitionId", "aJobDefId");
        String expectedException = "expectedException";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable)new AuthorizationException(expectedException)).when((Object)this.mockSuspensionStateBuilder)).activate();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendJobByJobDefinitionId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("jobDefinitionId", "aJobDefId");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_SUSPENDED_URL, new Object[0]);
        ((UpdateJobSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockSuspensionStateSelectBuilder)).byJobDefinitionId("aJobDefId");
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testSuspendJobByJobDefinitionIdThrowsAuthorizationException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("jobDefinitionId", "aJobDefId");
        String expectedException = "expectedException";
        ((UpdateJobSuspensionStateTenantBuilder)Mockito.doThrow((Throwable)new AuthorizationException(expectedException)).when((Object)this.mockSuspensionStateBuilder)).suspend();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateJobByIdShouldThrowException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("jobId", "aJobId");
        String message = "Either jobDefinitionId, processInstanceId, processDefinitionId or processDefinitionKey can be set to update the suspension state.";
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendJobByIdShouldThrowException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("jobId", "aJobId");
        String message = "Either jobDefinitionId, processInstanceId, processDefinitionId or processDefinitionKey can be set to update the suspension state.";
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendJobByNothing() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", true);
        String message = "Either jobId, jobDefinitionId, processInstanceId, processDefinitionId or processDefinitionKey should be set to update the suspension state.";
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().put(JOB_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSetJobPriority() {
        HashMap<String, Long> priorityJson = new HashMap<String, Long>();
        priorityJson.put("priority", 2147483689L);
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body(priorityJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_RESOURCE_SET_PRIORITY_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).setJobPriority("aJobId", 2147483689L);
    }

    @Test
    public void testSetJobPriorityToExtremeValue() {
        HashMap<String, Long> priorityJson = new HashMap<String, Long>();
        priorityJson.put("priority", Long.MAX_VALUE);
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body(priorityJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(JOB_RESOURCE_SET_PRIORITY_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).setJobPriority("aJobId", Long.MAX_VALUE);
    }

    @Test
    public void testSetJobPriorityNonExistentJob() {
        String expectedMessage = "No job found with id 'aNonExistingJobId'.";
        ((ManagementService)Mockito.doThrow((Throwable)new NotFoundException(expectedMessage)).when((Object)this.mockManagementService)).setJobPriority("aNonExistingJobId", 2147483689L);
        HashMap<String, Long> priorityJson = new HashMap<String, Long>();
        priorityJson.put("priority", 2147483689L);
        RestAssured.given().pathParam("id", (Object)"aNonExistingJobId").contentType(ContentType.JSON).body(priorityJson).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)expectedMessage), new Object[0]).when().put(JOB_RESOURCE_SET_PRIORITY_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).setJobPriority("aNonExistingJobId", 2147483689L);
    }

    @Test
    public void testSetJobPriorityFailure() {
        String expectedMessage = "No job found with id 'aJobId'.";
        ((ManagementService)Mockito.doThrow((Throwable)new ProcessEngineException(expectedMessage)).when((Object)this.mockManagementService)).setJobPriority("aJobId", 2147483689L);
        HashMap<String, Long> priorityJson = new HashMap<String, Long>();
        priorityJson.put("priority", 2147483689L);
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body(priorityJson).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)expectedMessage), new Object[0]).when().put(JOB_RESOURCE_SET_PRIORITY_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).setJobPriority("aJobId", 2147483689L);
    }

    @Test
    public void testSetNullJobPriorityFailure() {
        String expectedMessage = "Priority for job 'aJobId' cannot be null.";
        HashMap<String, Object> priorityJson = new HashMap<String, Object>();
        priorityJson.put("priority", null);
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body(priorityJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)expectedMessage), new Object[0]).when().put(JOB_RESOURCE_SET_PRIORITY_URL, new Object[0]);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockManagementService});
    }

    @Test
    public void testSetJobPriorityThrowsAuthorizationException() {
        String message = "expected exception";
        ((ManagementService)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.mockManagementService)).setJobPriority(org.mockito.Matchers.anyString(), (long)org.mockito.Matchers.anyInt());
        HashMap<String, Long> priorityJson = new HashMap<String, Long>();
        priorityJson.put("priority", 2147483689L);
        RestAssured.given().pathParam("id", (Object)"aJobId").contentType(ContentType.JSON).body(priorityJson).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().put(JOB_RESOURCE_SET_PRIORITY_URL, new Object[0]);
    }

    @Test
    public void deleteJob() {
        RestAssured.given().pathParam("id", (Object)"aJobId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_JOB_RESOURCE_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).deleteJob("aJobId");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockManagementService});
    }

    @Test
    public void deleteNotExistingJob() {
        String jobId = "aNonExistingJobId";
        String expectedMessage = "No job found with id '" + jobId + "'.";
        ((ManagementService)Mockito.doThrow((Throwable)new NullValueException(expectedMessage)).when((Object)this.mockManagementService)).deleteJob(jobId);
        RestAssured.given().pathParam("id", (Object)jobId).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)expectedMessage), new Object[0]).when().delete(SINGLE_JOB_RESOURCE_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).deleteJob(jobId);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockManagementService});
    }

    @Test
    public void deleteLockedJob() {
        String jobId = "aJobId";
        String expectedMessage = "Cannot delete job when the job is being executed. Try again later.";
        ((ManagementService)Mockito.doThrow((Throwable)new ProcessEngineException(expectedMessage)).when((Object)this.mockManagementService)).deleteJob(jobId);
        RestAssured.given().pathParam("id", (Object)jobId).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)expectedMessage), new Object[0]).when().delete(SINGLE_JOB_RESOURCE_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).deleteJob(jobId);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockManagementService});
    }

    @Test
    public void deleteJobThrowAuthorizationException() {
        String jobId = "aJobId";
        String expectedMessage = "Missing permissions";
        ((ManagementService)Mockito.doThrow((Throwable)new AuthorizationException(expectedMessage)).when((Object)this.mockManagementService)).deleteJob(jobId);
        RestAssured.given().pathParam("id", (Object)jobId).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedMessage), new Object[0]).when().delete(SINGLE_JOB_RESOURCE_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).deleteJob(jobId);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockManagementService});
    }

    @Test
    public void testSetRetriesAsync() {
        List<String> ids = Arrays.asList("aProcInstId");
        Batch batchEntity = MockProvider.createMockBatch();
        Mockito.when((Object)this.mockManagementService.setJobRetriesAsync(org.mockito.Matchers.anyListOf(String.class), (JobQuery)org.mockito.Matchers.any(JobQuery.class), org.mockito.Matchers.anyInt())).thenReturn((Object)batchEntity);
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        messageBodyJson.put("jobIds", ids);
        messageBodyJson.put(RETRIES, 5);
        Response response = (Response)RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(JOBS_SET_RETRIES_URL, new Object[0]);
        this.verifyBatchJson(response.asString());
        ((ManagementService)Mockito.verify((Object)this.mockManagementService, (VerificationMode)Mockito.times((int)1))).setJobRetriesAsync((List)org.mockito.Matchers.eq(ids), (JobQuery)org.mockito.Matchers.eq((Object)null), org.mockito.Matchers.eq((int)5));
    }

    @Test
    public void testSetRetriesAsyncWithQuery() {
        Batch batchEntity = MockProvider.createMockBatch();
        Mockito.when((Object)this.mockManagementService.setJobRetriesAsync(org.mockito.Matchers.anyListOf(String.class), (JobQuery)org.mockito.Matchers.any(JobQuery.class), org.mockito.Matchers.anyInt())).thenReturn((Object)batchEntity);
        HashMap<String, Integer> messageBodyJson = new HashMap<String, Integer>();
        messageBodyJson.put(RETRIES, 5);
        HistoricProcessInstanceQueryDto query = new HistoricProcessInstanceQueryDto();
        messageBodyJson.put("jobQuery", (Integer)query);
        Response response = (Response)RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(JOBS_SET_RETRIES_URL, new Object[0]);
        this.verifyBatchJson(response.asString());
        ((ManagementService)Mockito.verify((Object)this.mockManagementService, (VerificationMode)Mockito.times((int)1))).setJobRetriesAsync((List)org.mockito.Matchers.eq((Object)null), (JobQuery)org.mockito.Matchers.any(JobQuery.class), Mockito.eq((int)5));
    }

    @Test
    public void testSetRetriesWithBadRequestQuery() {
        ((ManagementService)Mockito.doThrow((Throwable)new BadUserRequestException("job ids are empty")).when((Object)this.mockManagementService)).setJobRetriesAsync((List)org.mockito.Matchers.eq((Object)null), (JobQuery)org.mockito.Matchers.eq((Object)null), org.mockito.Matchers.anyInt());
        HashMap<String, Integer> messageBodyJson = new HashMap<String, Integer>();
        messageBodyJson.put(RETRIES, 5);
        RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(JOBS_SET_RETRIES_URL, new Object[0]);
    }

    @Test
    public void testSetRetriesWithoutBody() {
        RestAssured.given().contentType(ContentType.JSON).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(JOBS_SET_RETRIES_URL, new Object[0]);
    }

    @Test
    public void testSetRetriesWithNegativeRetries() {
        ((ManagementService)Mockito.doThrow((Throwable)new BadUserRequestException("retries are negative")).when((Object)this.mockManagementService)).setJobRetriesAsync(org.mockito.Matchers.anyListOf(String.class), (JobQuery)org.mockito.Matchers.any(JobQuery.class), org.mockito.Matchers.eq((int)-1));
        HashMap<String, Integer> messageBodyJson = new HashMap<String, Integer>();
        messageBodyJson.put(RETRIES, -1);
        HistoricProcessInstanceQueryDto query = new HistoricProcessInstanceQueryDto();
        messageBodyJson.put("jobQuery", (Integer)query);
        RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(JOBS_SET_RETRIES_URL, new Object[0]);
    }

    @Test
    public void testSetRetriesWithoutRetries() {
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        messageBodyJson.put("jobIds", null);
        RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(JOBS_SET_RETRIES_URL, new Object[0]);
    }

    protected void verifyBatchJson(String batchJson) {
        BatchDto batch = (BatchDto)JsonPathUtil.from(batchJson).getObject("", BatchDto.class);
        Assert.assertNotNull((String)"The returned batch should not be null.", (Object)batch);
        Assert.assertEquals((Object)"aBatchId", (Object)batch.getId());
        Assert.assertEquals((Object)"aBatchType", (Object)batch.getType());
        Assert.assertEquals((long)10L, (long)batch.getTotalJobs());
        Assert.assertEquals((long)11L, (long)batch.getBatchJobsPerSeed());
        Assert.assertEquals((long)12L, (long)batch.getInvocationsPerBatchJob());
        Assert.assertEquals((Object)"aSeedJobDefinitionId", (Object)batch.getSeedJobDefinitionId());
        Assert.assertEquals((Object)"aMonitorJobDefinitionId", (Object)batch.getMonitorJobDefinitionId());
        Assert.assertEquals((Object)"aBatchJobDefinitionId", (Object)batch.getBatchJobDefinitionId());
        Assert.assertEquals((Object)"aTenantId", (Object)batch.getTenantId());
    }
}

