/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.ProcessApplicationService;
import org.camunda.bpm.application.ProcessApplicationInfo;
import org.camunda.bpm.container.RuntimeContainerDelegate;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.form.StartFormData;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.impl.digest._apacheCommonsCodec.Base64;
import org.camunda.bpm.engine.impl.form.validator.FormFieldValidationException;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.impl.util.ReflectUtil;
import org.camunda.bpm.engine.repository.DeleteProcessDefinitionsBuilder;
import org.camunda.bpm.engine.repository.DeleteProcessDefinitionsSelectBuilder;
import org.camunda.bpm.engine.repository.DeleteProcessDefinitionsTenantBuilder;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.dto.HistoryTimeToLiveDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.helper.EqualsMap;
import org.camunda.bpm.engine.rest.helper.EqualsVariableMap;
import org.camunda.bpm.engine.rest.helper.ErrorMessageHelper;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.helper.VariableTypeHelper;
import org.camunda.bpm.engine.rest.helper.variable.EqualsObjectValue;
import org.camunda.bpm.engine.rest.helper.variable.EqualsPrimitiveValue;
import org.camunda.bpm.engine.rest.helper.variable.EqualsUntypedValue;
import org.camunda.bpm.engine.rest.sub.repository.impl.ProcessDefinitionResourceImpl;
import org.camunda.bpm.engine.rest.util.EncodingUtil;
import org.camunda.bpm.engine.rest.util.ModificationInstructionBuilder;
import org.camunda.bpm.engine.rest.util.VariablesBuilder;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.runtime.ProcessInstanceWithVariables;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.impl.VariableMapImpl;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.fest.assertions.Assertions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class ProcessDefinitionRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String PROCESS_DEFINITION_URL = "/rest-test/process-definition";
    protected static final String SINGLE_PROCESS_DEFINITION_URL = "/rest-test/process-definition/{id}";
    protected static final String SINGLE_PROCESS_DEFINITION_BY_KEY_URL = "/rest-test/process-definition/key/{key}";
    protected static final String SINGLE_PROCESS_DEFINITION_BY_KEY_AND_TENANT_ID_URL = "/rest-test/process-definition/key/{key}/tenant-id/{tenant-id}";
    protected static final String START_PROCESS_INSTANCE_URL = "/rest-test/process-definition/{id}/start";
    protected static final String START_PROCESS_INSTANCE_BY_KEY_URL = "/rest-test/process-definition/key/{key}/start";
    protected static final String START_PROCESS_INSTANCE_BY_KEY_AND_TENANT_ID_URL = "/rest-test/process-definition/key/{key}/tenant-id/{tenant-id}/start";
    protected static final String XML_DEFINITION_URL = "/rest-test/process-definition/{id}/xml";
    protected static final String XML_DEFINITION_BY_KEY_URL = "/rest-test/process-definition/key/{key}/xml";
    protected static final String DIAGRAM_DEFINITION_URL = "/rest-test/process-definition/{id}/diagram";
    protected static final String DIAGRAM_DEFINITION_KEY_URL = "/rest-test/process-definition/key/{key}/diagram";
    protected static final String START_FORM_URL = "/rest-test/process-definition/{id}/startForm";
    protected static final String START_FORM_BY_KEY_URL = "/rest-test/process-definition/key/{key}/startForm";
    protected static final String DEPLOYED_START_FORM_URL = "/rest-test/process-definition/{id}/deployed-start-form";
    protected static final String DEPLOYED_START_FORM_BY_KEY_URL = "/rest-test/process-definition/key/{key}/deployed-start-form";
    protected static final String RENDERED_FORM_URL = "/rest-test/process-definition/{id}/rendered-form";
    protected static final String RENDERED_FORM_BY_KEY_URL = "/rest-test/process-definition/key/{key}/rendered-form";
    protected static final String SUBMIT_FORM_URL = "/rest-test/process-definition/{id}/submit-form";
    protected static final String SUBMIT_FORM_BY_KEY_URL = "/rest-test/process-definition/key/{key}/submit-form";
    protected static final String START_FORM_VARIABLES_URL = "/rest-test/process-definition/{id}/form-variables";
    protected static final String START_FORM_VARIABLES_BY_KEY_URL = "/rest-test/process-definition/key/{key}/form-variables";
    protected static final String SINGLE_PROCESS_DEFINITION_SUSPENDED_URL = "/rest-test/process-definition/{id}/suspended";
    protected static final String SINGLE_PROCESS_DEFINITION_BY_KEY_SUSPENDED_URL = "/rest-test/process-definition/key/{key}/suspended";
    protected static final String SINGLE_PROCESS_DEFINITION_HISTORY_TIMETOLIVE_URL = "/rest-test/process-definition/{id}/history-time-to-live";
    protected static final String PROCESS_DEFINITION_SUSPENDED_URL = "/rest-test/process-definition/suspended";
    protected static final String SINGLE_PROCESS_DEFINITION_BY_KEY_DELETE_URL = "/rest-test/process-definition/key/{key}/delete";
    protected static final String SINGLE_PROCESS_DEFINITION_BY_KEY_AND_TENANT_ID_DELETE_URL = "/rest-test/process-definition/key/{key}/tenant-id/{tenant-id}/delete";
    private RuntimeService runtimeServiceMock;
    private RepositoryService repositoryServiceMock;
    private FormService formServiceMock;
    private ManagementService managementServiceMock;
    private ProcessDefinitionQuery processDefinitionQueryMock;
    private ProcessInstanceWithVariables mockInstance;
    private ProcessInstantiationBuilder mockInstantiationBuilder;

    @Before
    public void setUpRuntimeData() {
        ProcessDefinition mockDefinition = MockProvider.createMockDefinition();
        this.setUpRuntimeDataForDefinition(mockDefinition);
        this.managementServiceMock = (ManagementService)Mockito.mock(ManagementService.class);
        Mockito.when((Object)processEngine.getManagementService()).thenReturn((Object)this.managementServiceMock);
        Mockito.when((Object)this.managementServiceMock.getProcessApplicationForDeployment("aDeploymentId")).thenReturn((Object)"aProcessApplication");
        ProcessApplicationService processApplicationService = (ProcessApplicationService)Mockito.mock(ProcessApplicationService.class);
        ProcessApplicationInfo appMock = MockProvider.createMockProcessApplicationInfo();
        Mockito.when((Object)processApplicationService.getProcessApplicationInfo("aProcessApplication")).thenReturn((Object)appMock);
        RuntimeContainerDelegate delegate = (RuntimeContainerDelegate)Mockito.mock(RuntimeContainerDelegate.class);
        Mockito.when((Object)delegate.getProcessApplicationService()).thenReturn((Object)processApplicationService);
        RuntimeContainerDelegate.INSTANCE.set(delegate);
    }

    private void setUpRuntimeDataForDefinition(ProcessDefinition mockDefinition) {
        this.mockInstance = MockProvider.createMockInstanceWithVariables();
        this.runtimeServiceMock = (RuntimeService)Mockito.mock(RuntimeService.class);
        Mockito.when((Object)processEngine.getRuntimeService()).thenReturn((Object)this.runtimeServiceMock);
        Mockito.when((Object)this.runtimeServiceMock.startProcessInstanceById((String)Matchers.eq((Object)"aProcDefId"), (Map)Matchers.any())).thenReturn((Object)this.mockInstance);
        Mockito.when((Object)this.runtimeServiceMock.startProcessInstanceById((String)Matchers.eq((Object)"aProcDefId"), Matchers.anyString(), Matchers.anyString(), (Map)Matchers.any())).thenReturn((Object)this.mockInstance);
        this.mockInstantiationBuilder = this.setUpMockInstantiationBuilder();
        Mockito.when((Object)this.mockInstantiationBuilder.executeWithVariablesInReturn(Matchers.anyBoolean(), Matchers.anyBoolean())).thenReturn((Object)this.mockInstance);
        Mockito.when((Object)this.runtimeServiceMock.createProcessInstanceById(Matchers.anyString())).thenReturn((Object)this.mockInstantiationBuilder);
        this.repositoryServiceMock = (RepositoryService)Mockito.mock(RepositoryService.class);
        Mockito.when((Object)processEngine.getRepositoryService()).thenReturn((Object)this.repositoryServiceMock);
        Mockito.when((Object)this.repositoryServiceMock.getProcessDefinition((String)Matchers.eq((Object)"aProcDefId"))).thenReturn((Object)mockDefinition);
        Mockito.when((Object)this.repositoryServiceMock.getProcessModel((String)Matchers.eq((Object)"aProcDefId"))).thenReturn((Object)this.createMockProcessDefinionBpmn20Xml());
        DeleteProcessDefinitionsSelectBuilder deleteProcessDefinitionsSelectBuilder = (DeleteProcessDefinitionsSelectBuilder)Mockito.mock(DeleteProcessDefinitionsSelectBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.repositoryServiceMock.deleteProcessDefinitions()).thenReturn((Object)deleteProcessDefinitionsSelectBuilder);
        this.setUpMockDefinitionQuery(mockDefinition);
        StartFormData formDataMock = MockProvider.createMockStartFormData(mockDefinition);
        this.formServiceMock = (FormService)Mockito.mock(FormService.class);
        Mockito.when((Object)processEngine.getFormService()).thenReturn((Object)this.formServiceMock);
        Mockito.when((Object)this.formServiceMock.getStartFormData((String)Matchers.eq((Object)"aProcDefId"))).thenReturn((Object)formDataMock);
        Mockito.when((Object)this.formServiceMock.submitStartForm((String)Matchers.eq((Object)"aProcDefId"), (Map)Matchers.any())).thenReturn((Object)this.mockInstance);
        Mockito.when((Object)this.formServiceMock.submitStartForm((String)Matchers.eq((Object)"aProcDefId"), Matchers.anyString(), (Map)Matchers.any())).thenReturn((Object)this.mockInstance);
        VariableMap startFormVariablesMock = MockProvider.createMockFormVariables();
        Mockito.when((Object)this.formServiceMock.getStartFormVariables((String)Matchers.eq((Object)"aProcessDefinitionId"), (Collection)Matchers.any(), Matchers.anyBoolean())).thenReturn((Object)startFormVariablesMock);
    }

    private InputStream createMockProcessDefinionBpmn20Xml() {
        InputStream bpmn20XmlIn = null;
        bpmn20XmlIn = ReflectUtil.getResourceAsStream((String)"processes/fox-invoice_en_long_id.bpmn");
        Assert.assertNotNull((Object)bpmn20XmlIn);
        return bpmn20XmlIn;
    }

    private void setUpMockDefinitionQuery(ProcessDefinition mockDefinition) {
        this.processDefinitionQueryMock = (ProcessDefinitionQuery)Mockito.mock(ProcessDefinitionQuery.class);
        Mockito.when((Object)this.processDefinitionQueryMock.processDefinitionKey("aKey")).thenReturn((Object)this.processDefinitionQueryMock);
        Mockito.when((Object)this.processDefinitionQueryMock.processDefinitionId("aProcDefId")).thenReturn((Object)this.processDefinitionQueryMock);
        Mockito.when((Object)this.processDefinitionQueryMock.tenantIdIn(new String[]{Matchers.anyString()})).thenReturn((Object)this.processDefinitionQueryMock);
        Mockito.when((Object)this.processDefinitionQueryMock.withoutTenantId()).thenReturn((Object)this.processDefinitionQueryMock);
        Mockito.when((Object)this.processDefinitionQueryMock.latestVersion()).thenReturn((Object)this.processDefinitionQueryMock);
        Mockito.when((Object)this.processDefinitionQueryMock.singleResult()).thenReturn((Object)mockDefinition);
        Mockito.when((Object)this.processDefinitionQueryMock.count()).thenReturn((Object)1L);
        Mockito.when((Object)this.processDefinitionQueryMock.list()).thenReturn(Collections.singletonList(mockDefinition));
        Mockito.when((Object)this.repositoryServiceMock.createProcessDefinitionQuery()).thenReturn((Object)this.processDefinitionQueryMock);
    }

    @Test
    public void testInstanceResourceLinkResult() {
        String fullInstanceUrl = "http://localhost:" + PORT + "/rest-test" + "/process-instance/" + "aProcInstId";
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", org.hamcrest.Matchers.equalTo((Object)fullInstanceUrl), new Object[0]).when().post(START_PROCESS_INSTANCE_URL, new Object[0]);
    }

    @Test
    public void testInstanceResourceLinkWithEnginePrefix() {
        String startInstanceOnExplicitEngineUrl = "/rest-test/engine/default/process-definition/{id}/start";
        String fullInstanceUrl = "http://localhost:" + PORT + "/rest-test" + "/engine/default/process-instance/" + "aProcInstId";
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", org.hamcrest.Matchers.equalTo((Object)fullInstanceUrl), new Object[0]).when().post(startInstanceOnExplicitEngineUrl, new Object[0]);
    }

    @Test
    public void testProcessDefinitionBpmn20XmlRetrieval() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aProcDefId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(XML_DEFINITION_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertTrue((boolean)responseContent.contains("aProcDefId"));
        Assert.assertTrue((boolean)responseContent.contains("<?xml"));
    }

    @Test
    public void testProcessDiagramRetrieval() throws FileNotFoundException, URISyntaxException {
        File file = this.getFile("/processes/todo-process.png");
        Mockito.when((Object)this.repositoryServiceMock.getProcessDiagram("aProcDefId")).thenReturn((Object)new FileInputStream(file));
        byte[] actual = ((Response)RestAssured.given().pathParam("id", (Object)"aProcDefId").expect().statusCode(Response.Status.OK.getStatusCode()).contentType("image/png").header("Content-Disposition", "attachment; filename=aResourceName.png").when().get(DIAGRAM_DEFINITION_URL, new Object[0])).getBody().asByteArray();
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).getProcessDefinition("aProcDefId");
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).getProcessDiagram("aProcDefId");
        byte[] expected = IoUtil.readInputStream((InputStream)new FileInputStream(file), (String)"process diagram");
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void testProcessDiagramNullFilename() throws FileNotFoundException, URISyntaxException {
        File file = this.getFile("/processes/todo-process.png");
        Mockito.when((Object)this.repositoryServiceMock.getProcessDefinition("aProcDefId").getDiagramResourceName()).thenReturn(null);
        Mockito.when((Object)this.repositoryServiceMock.getProcessDiagram("aProcDefId")).thenReturn((Object)new FileInputStream(file));
        byte[] actual = ((Response)RestAssured.given().pathParam("id", (Object)"aProcDefId").expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/octet-stream").header("Content-Disposition", "attachment; filename=" + null).when().get(DIAGRAM_DEFINITION_URL, new Object[0])).getBody().asByteArray();
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).getProcessDiagram("aProcDefId");
        byte[] expected = IoUtil.readInputStream((InputStream)new FileInputStream(file), (String)"process diagram");
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void testProcessDiagramNotExist() {
        Mockito.when((Object)this.repositoryServiceMock.getProcessDiagram("aProcDefId")).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().get(DIAGRAM_DEFINITION_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).getProcessDefinition("aProcDefId");
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).getProcessDiagram("aProcDefId");
    }

    @Test
    public void testProcessDiagramMediaType() {
        Assert.assertEquals((Object)"image/png", (Object)ProcessDefinitionResourceImpl.getMediaTypeForFileSuffix((String)"process.png"));
        Assert.assertEquals((Object)"image/png", (Object)ProcessDefinitionResourceImpl.getMediaTypeForFileSuffix((String)"process.PNG"));
        Assert.assertEquals((Object)"image/svg+xml", (Object)ProcessDefinitionResourceImpl.getMediaTypeForFileSuffix((String)"process.svg"));
        Assert.assertEquals((Object)"image/jpeg", (Object)ProcessDefinitionResourceImpl.getMediaTypeForFileSuffix((String)"process.jpeg"));
        Assert.assertEquals((Object)"image/jpeg", (Object)ProcessDefinitionResourceImpl.getMediaTypeForFileSuffix((String)"process.jpg"));
        Assert.assertEquals((Object)"image/gif", (Object)ProcessDefinitionResourceImpl.getMediaTypeForFileSuffix((String)"process.gif"));
        Assert.assertEquals((Object)"image/bmp", (Object)ProcessDefinitionResourceImpl.getMediaTypeForFileSuffix((String)"process.bmp"));
        Assert.assertEquals((Object)"application/octet-stream", (Object)ProcessDefinitionResourceImpl.getMediaTypeForFileSuffix((String)"process.UNKNOWN"));
    }

    @Test
    public void testGetProcessDiagramGetDefinitionThrowsAuthorizationException() {
        String message = "expected exception";
        Mockito.when((Object)this.repositoryServiceMock.getProcessDefinition("aProcDefId")).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().pathParam("id", (Object)"aProcDefId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)message), new Object[0]).when().get(DIAGRAM_DEFINITION_URL, new Object[0]);
    }

    @Test
    public void testGetProcessDiagramThrowsAuthorizationException() {
        String message = "expected exception";
        Mockito.when((Object)this.repositoryServiceMock.getProcessDiagram("aProcDefId")).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().pathParam("id", (Object)"aProcDefId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)message), new Object[0]).when().get(DIAGRAM_DEFINITION_URL, new Object[0]);
    }

    @Test
    public void testGetProcessDiagramGetDefinitionThrowsAuthorizationException_ByKey() {
        String message = "expected exception";
        Mockito.when((Object)this.repositoryServiceMock.getProcessDefinition("aProcDefId")).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().pathParam("key", (Object)"aKey").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)message), new Object[0]).when().get(DIAGRAM_DEFINITION_KEY_URL, new Object[0]);
    }

    @Test
    public void testGetProcessDiagramThrowsAuthorizationException_ByKey() {
        String message = "expected exception";
        Mockito.when((Object)this.repositoryServiceMock.getProcessDiagram("aProcDefId")).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().pathParam("key", (Object)"aKey").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)message), new Object[0]).when().get(DIAGRAM_DEFINITION_KEY_URL, new Object[0]);
    }

    @Test
    public void testGetStartFormData() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("key", org.hamcrest.Matchers.equalTo((Object)"aFormKey"), new Object[0]).when().get(START_FORM_URL, new Object[0]);
    }

    @Test
    public void testGetStartForm_shouldReturnKeyContainingTaskId() {
        ProcessDefinition mockDefinition = MockProvider.createMockDefinition();
        StartFormData mockStartFormData = MockProvider.createMockStartFormDataUsingFormFieldsWithoutFormKey(mockDefinition);
        Mockito.when((Object)this.formServiceMock.getStartFormData(mockDefinition.getId())).thenReturn((Object)mockStartFormData);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("key", org.hamcrest.Matchers.equalTo((Object)("embedded:engine://engine/:engine/process-definition/" + mockDefinition.getId() + "/rendered-form")), new Object[0]).body("contextPath", org.hamcrest.Matchers.equalTo((Object)"http://camunda.org/someContext"), new Object[0]).when().get(START_FORM_URL, new Object[0]);
    }

    @Test
    public void testGetStartForm_StartFormDataEqualsNull() {
        ProcessDefinition mockDefinition = MockProvider.createMockDefinition();
        Mockito.when((Object)this.formServiceMock.getStartFormData(mockDefinition.getId())).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("contextPath", org.hamcrest.Matchers.equalTo((Object)"http://camunda.org/someContext"), new Object[0]).when().get(START_FORM_URL, new Object[0]);
    }

    @Test
    public void testGetStartFormThrowsAuthorizationException() {
        String message = "expected exception";
        Mockito.when((Object)this.formServiceMock.getStartFormData("aProcDefId")).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().pathParam("id", (Object)"aProcDefId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)message), new Object[0]).when().get(START_FORM_URL, new Object[0]);
    }

    @Test
    public void testGetRenderedStartForm() {
        String expectedResult = "<formField>anyContent</formField>";
        Mockito.when((Object)this.formServiceMock.getRenderedStartForm("aProcDefId")).thenReturn((Object)expectedResult);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aProcDefId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(XHTML_XML_CONTENT_TYPE).when().get(RENDERED_FORM_URL, new Object[0]);
        String responseContent = response.asString();
        Assertions.assertThat((String)responseContent).isEqualTo((Object)expectedResult);
    }

    @Test
    public void testGetRenderedStartFormForDifferentPlatformEncoding() throws NoSuchFieldException, IllegalAccessException, UnsupportedEncodingException {
        String expectedResult = "<formField>unicode symbol: \u2200</formField>";
        Mockito.when((Object)this.formServiceMock.getRenderedStartForm("aProcDefId")).thenReturn((Object)expectedResult);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aProcDefId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(XHTML_XML_CONTENT_TYPE).when().get(RENDERED_FORM_URL, new Object[0]);
        String responseContent = new String(response.asByteArray(), EncodingUtil.DEFAULT_ENCODING);
        Assertions.assertThat((String)responseContent).isEqualTo((Object)expectedResult);
    }

    @Test
    public void testGetRenderedStartFormReturnsNotFound() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)"No matching rendered start form for process definition with the id aProcDefId found."), new Object[0]).when().get(RENDERED_FORM_URL, new Object[0]);
    }

    @Test
    public void testGetRenderedStartFormThrowsAuthorizationException() {
        String message = "expected exception";
        Mockito.when((Object)this.formServiceMock.getRenderedStartForm(Matchers.anyString())).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().pathParam("id", (Object)"aProcDefId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", org.hamcrest.Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)message), new Object[0]).when().get(RENDERED_FORM_URL, new Object[0]);
    }

    @Test
    public void testSubmitStartForm() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcInstId"), new Object[0]).body("definitionId", org.hamcrest.Matchers.equalTo((Object)"aProcDefId"), new Object[0]).body("businessKey", org.hamcrest.Matchers.equalTo((Object)"aKey"), new Object[0]).body("ended", org.hamcrest.Matchers.equalTo((Object)false), new Object[0]).body("suspended", org.hamcrest.Matchers.equalTo((Object)false), new Object[0]).when().post(SUBMIT_FORM_URL, new Object[0]);
        ((FormService)Mockito.verify((Object)this.formServiceMock)).submitStartForm("aProcDefId", null);
    }

    @Test
    public void testSubmitStartFormWithParameters() {
        Map<String, Object> variables = VariablesBuilder.create().variable("aVariable", "aStringValue").variable("anotherVariable", 42).variable("aThirdValue", Boolean.TRUE).getVariables();
        HashMap<String, Map<String, Object>> json = new HashMap<String, Map<String, Object>>();
        json.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcInstId"), new Object[0]).body("definitionId", org.hamcrest.Matchers.equalTo((Object)"aProcDefId"), new Object[0]).body("businessKey", org.hamcrest.Matchers.equalTo((Object)"aKey"), new Object[0]).body("ended", org.hamcrest.Matchers.equalTo((Object)false), new Object[0]).body("suspended", org.hamcrest.Matchers.equalTo((Object)false), new Object[0]).when().post(SUBMIT_FORM_URL, new Object[0]);
        HashMap<String, Object> expectedVariables = new HashMap<String, Object>();
        expectedVariables.put("aVariable", "aStringValue");
        expectedVariables.put("anotherVariable", 42);
        expectedVariables.put("aThirdValue", Boolean.TRUE);
        ((FormService)Mockito.verify((Object)this.formServiceMock)).submitStartForm((String)Matchers.eq((Object)"aProcDefId"), (Map)Matchers.argThat((Matcher)new EqualsMap(expectedVariables)));
    }

    @Test
    public void testSubmitStartFormWithSerializedVariableValue() {
        String jsonValue = "{}";
        Map<String, Object> variables = VariablesBuilder.create().variable("aVariable", "aStringValue").variable("aSerializedVariable", ValueType.OBJECT.getName(), jsonValue, "aFormat", "aRootType").getVariables();
        HashMap<String, Map<String, Object>> json = new HashMap<String, Map<String, Object>>();
        json.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcInstId"), new Object[0]).body("definitionId", org.hamcrest.Matchers.equalTo((Object)"aProcDefId"), new Object[0]).body("businessKey", org.hamcrest.Matchers.equalTo((Object)"aKey"), new Object[0]).body("ended", org.hamcrest.Matchers.equalTo((Object)false), new Object[0]).body("suspended", org.hamcrest.Matchers.equalTo((Object)false), new Object[0]).when().post(SUBMIT_FORM_URL, new Object[0]);
        ((FormService)Mockito.verify((Object)this.formServiceMock)).submitStartForm((String)Matchers.eq((Object)"aProcDefId"), (Map)Matchers.argThat((Matcher)new EqualsVariableMap().matcher("aVariable", (Matcher<?>)EqualsUntypedValue.matcher().value("aStringValue")).matcher("aSerializedVariable", (Matcher<?>)EqualsObjectValue.objectValueMatcher().serializedValue(jsonValue).serializationFormat("aFormat").objectTypeName("aRootType"))));
    }

    @Test
    public void testSubmitStartFormWithBase64EncodedBytes() {
        Map<String, Object> variables = VariablesBuilder.create().variable("aVariable", (Object)Base64.encodeBase64String((byte[])"someBytes".getBytes()), ValueType.BYTES.getName()).getVariables();
        HashMap<String, Map<String, Object>> json = new HashMap<String, Map<String, Object>>();
        json.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcInstId"), new Object[0]).body("definitionId", org.hamcrest.Matchers.equalTo((Object)"aProcDefId"), new Object[0]).body("businessKey", org.hamcrest.Matchers.equalTo((Object)"aKey"), new Object[0]).body("ended", org.hamcrest.Matchers.equalTo((Object)false), new Object[0]).body("suspended", org.hamcrest.Matchers.equalTo((Object)false), new Object[0]).when().post(SUBMIT_FORM_URL, new Object[0]);
        ((FormService)Mockito.verify((Object)this.formServiceMock)).submitStartForm((String)Matchers.eq((Object)"aProcDefId"), (Map)Matchers.argThat((Matcher)new EqualsVariableMap().matcher("aVariable", (Matcher<?>)EqualsPrimitiveValue.bytesValue("someBytes".getBytes()))));
    }

    @Test
    public void testSubmitStartFormWithBusinessKey() {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("businessKey", "myBusinessKey");
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcInstId"), new Object[0]).body("definitionId", org.hamcrest.Matchers.equalTo((Object)"aProcDefId"), new Object[0]).body("businessKey", org.hamcrest.Matchers.equalTo((Object)"aKey"), new Object[0]).body("ended", org.hamcrest.Matchers.equalTo((Object)false), new Object[0]).body("suspended", org.hamcrest.Matchers.equalTo((Object)false), new Object[0]).when().post(SUBMIT_FORM_URL, new Object[0]);
        ((FormService)Mockito.verify((Object)this.formServiceMock)).submitStartForm("aProcDefId", "myBusinessKey", null);
    }

    @Test
    public void testSubmitStartFormWithBusinessKeyAndParameters() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("businessKey", "myBusinessKey");
        Map<String, Object> variables = VariablesBuilder.create().variable("aVariable", "aStringValue").variable("anotherVariable", 42).variable("aThirdValue", Boolean.TRUE).getVariables();
        json.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcInstId"), new Object[0]).body("definitionId", org.hamcrest.Matchers.equalTo((Object)"aProcDefId"), new Object[0]).body("businessKey", org.hamcrest.Matchers.equalTo((Object)"aKey"), new Object[0]).body("ended", org.hamcrest.Matchers.equalTo((Object)false), new Object[0]).body("suspended", org.hamcrest.Matchers.equalTo((Object)false), new Object[0]).when().post(SUBMIT_FORM_URL, new Object[0]);
        HashMap<String, Object> expectedVariables = new HashMap<String, Object>();
        expectedVariables.put("aVariable", "aStringValue");
        expectedVariables.put("anotherVariable", 42);
        expectedVariables.put("aThirdValue", Boolean.TRUE);
        ((FormService)Mockito.verify((Object)this.formServiceMock)).submitStartForm((String)Matchers.eq((Object)"aProcDefId"), (String)Matchers.eq((Object)"myBusinessKey"), (Map)Matchers.argThat((Matcher)new EqualsMap(expectedVariables)));
    }

    @Test
    public void testSubmitStartFormWithUnparseableIntegerVariable() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Integer";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)("Cannot instantiate process definition aProcDefId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Integer.class))), new Object[0]).when().post(SUBMIT_FORM_URL, new Object[0]);
    }

    @Test
    public void testSubmitStartFormWithUnparseableShortVariable() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Short";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)("Cannot instantiate process definition aProcDefId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Short.class))), new Object[0]).when().post(SUBMIT_FORM_URL, new Object[0]);
    }

    @Test
    public void testSubmitStartFormWithUnparseableLongVariable() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Long";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)("Cannot instantiate process definition aProcDefId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Long.class))), new Object[0]).when().post(SUBMIT_FORM_URL, new Object[0]);
    }

    @Test
    public void testSubmitStartFormWithUnparseableDoubleVariable() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Double";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)("Cannot instantiate process definition aProcDefId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Double.class))), new Object[0]).when().post(SUBMIT_FORM_URL, new Object[0]);
    }

    @Test
    public void testSubmitStartFormWithUnparseableDateVariable() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Date";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)("Cannot instantiate process definition aProcDefId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Date.class))), new Object[0]).when().post(SUBMIT_FORM_URL, new Object[0]);
    }

    @Test
    public void testSubmitStartFormWithNotSupportedVariableType() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "X";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)"Cannot instantiate process definition aProcDefId: Unsupported value type 'X'"), new Object[0]).when().post(SUBMIT_FORM_URL, new Object[0]);
    }

    @Test
    public void testUnsuccessfulSubmitStartForm() {
        ((FormService)Mockito.doThrow((Throwable)new ProcessEngineException("expected exception")).when((Object)this.formServiceMock)).submitStartForm((String)Matchers.any(String.class), (Map)Matchers.any());
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)"Cannot instantiate process definition aProcDefId: expected exception"), new Object[0]).when().post(SUBMIT_FORM_URL, new Object[0]);
    }

    @Test
    public void testSubmitFormByIdThrowsAuthorizationException() {
        String message = "expected exception";
        ((FormService)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.formServiceMock)).submitStartForm((String)Matchers.any(String.class), (Map)Matchers.any());
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)message), new Object[0]).when().post(SUBMIT_FORM_URL, new Object[0]);
    }

    @Test
    public void testSubmitFormByIdThrowsFormFieldValidationException() {
        String message = "expected exception";
        ((FormService)Mockito.doThrow((Throwable)new FormFieldValidationException((Object)"form-exception", message)).when((Object)this.formServiceMock)).submitStartForm((String)Matchers.any(String.class), (Map)Matchers.any());
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)("Cannot instantiate process definition aProcDefId: " + message)), new Object[0]).when().post(SUBMIT_FORM_URL, new Object[0]);
    }

    @Test
    public void testGetStartFormVariables() {
        ((Response)RestAssured.given().pathParam("id", (Object)"aProcessDefinitionId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).body("aVariableInstanceName.value", org.hamcrest.Matchers.equalTo((Object)MockProvider.EXAMPLE_PRIMITIVE_VARIABLE_VALUE.getValue()), new Object[0]).body("aVariableInstanceName.type", org.hamcrest.Matchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName((ValueType)MockProvider.EXAMPLE_PRIMITIVE_VARIABLE_VALUE.getType())), new Object[0]).when().get(START_FORM_VARIABLES_URL, new Object[0])).body();
        ((FormService)Mockito.verify((Object)this.formServiceMock, (VerificationMode)Mockito.times((int)1))).getStartFormVariables("aProcessDefinitionId", null, true);
    }

    @Test
    public void testGetStartFormVariablesVarNames() {
        RestAssured.given().pathParam("id", (Object)"aProcessDefinitionId").queryParam("variableNames", new Object[]{"a,b,c"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(START_FORM_VARIABLES_URL, new Object[0]);
        ((FormService)Mockito.verify((Object)this.formServiceMock, (VerificationMode)Mockito.times((int)1))).getStartFormVariables("aProcessDefinitionId", Arrays.asList("a", "b", "c"), true);
    }

    @Test
    public void testGetStartFormVariablesAndDoNotDeserializeVariables() {
        ((Response)RestAssured.given().pathParam("id", (Object)"aProcessDefinitionId").queryParam("deserializeValues", new Object[]{false}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).body("aVariableInstanceName.value", org.hamcrest.Matchers.equalTo((Object)MockProvider.EXAMPLE_PRIMITIVE_VARIABLE_VALUE.getValue()), new Object[0]).body("aVariableInstanceName.type", org.hamcrest.Matchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName((ValueType)MockProvider.EXAMPLE_PRIMITIVE_VARIABLE_VALUE.getType())), new Object[0]).when().get(START_FORM_VARIABLES_URL, new Object[0])).body();
        ((FormService)Mockito.verify((Object)this.formServiceMock, (VerificationMode)Mockito.times((int)1))).getStartFormVariables("aProcessDefinitionId", null, false);
    }

    @Test
    public void testGetStartFormVariablesVarNamesAndDoNotDeserializeVariables() {
        RestAssured.given().pathParam("id", (Object)"aProcessDefinitionId").queryParam("deserializeValues", new Object[]{false}).queryParam("variableNames", new Object[]{"a,b,c"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(START_FORM_VARIABLES_URL, new Object[0]);
        ((FormService)Mockito.verify((Object)this.formServiceMock, (VerificationMode)Mockito.times((int)1))).getStartFormVariables("aProcessDefinitionId", Arrays.asList("a", "b", "c"), false);
    }

    @Test
    public void testGetStartFormVariablesThrowsAuthorizationException() {
        String message = "expected exception";
        Mockito.when((Object)this.formServiceMock.getStartFormVariables("aProcDefId", null, true)).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().pathParam("id", (Object)"aProcDefId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)message), new Object[0]).when().get(START_FORM_VARIABLES_URL, new Object[0]);
    }

    @Test
    public void testSimpleProcessInstantiation() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcInstId"), new Object[0]).when().post(START_PROCESS_INSTANCE_URL, new Object[0]);
    }

    @Test
    public void testSimpleProcessInstantiationWithVariables() {
        ProcessInstanceWithVariables mockInstance = MockProvider.createMockInstanceWithVariables();
        ProcessInstantiationBuilder mockInstantiationBuilder = this.setUpMockInstantiationBuilder();
        Mockito.when((Object)mockInstantiationBuilder.executeWithVariablesInReturn(Matchers.anyBoolean(), Matchers.anyBoolean())).thenReturn((Object)mockInstance);
        Mockito.when((Object)this.runtimeServiceMock.createProcessInstanceById(Matchers.anyString())).thenReturn((Object)mockInstantiationBuilder);
        HashMap<String, Boolean> json = new HashMap<String, Boolean>();
        json.put("withVariablesInReturn", true);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcInstId"), new Object[0]).body("variables.aVariableInstanceName.value", org.hamcrest.Matchers.equalTo((Object)"aSerializedValue"), new Object[0]).body("variables.aVariableInstanceName.type", org.hamcrest.Matchers.equalTo((Object)"Object"), new Object[0]).body("variables.aVariableInstanceName.valueInfo.objectTypeName", org.hamcrest.Matchers.equalTo((Object)ArrayList.class.getName()), new Object[0]).body("variables.aVariableInstanceName.valueInfo.serializationDataFormat", org.hamcrest.Matchers.equalTo((Object)"application/json"), new Object[0]).body("variables.aDeserializedVariableInstanceName.value", org.hamcrest.Matchers.equalTo((Object)"aSerializedValue"), new Object[0]).body("variables.aDeserializedVariableInstanceName.type", org.hamcrest.Matchers.equalTo((Object)"Object"), new Object[0]).body("variables.aDeserializedVariableInstanceName.valueInfo.objectTypeName", org.hamcrest.Matchers.equalTo((Object)Object.class.getName()), new Object[0]).body("variables.aDeserializedVariableInstanceName.valueInfo.serializationDataFormat", org.hamcrest.Matchers.equalTo((Object)"application/json"), new Object[0]).when().post(START_PROCESS_INSTANCE_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createProcessInstanceById((String)Matchers.eq((Object)"aProcDefId"));
        ((ProcessInstantiationBuilder)Mockito.verify((Object)mockInstantiationBuilder)).executeWithVariablesInReturn(Matchers.anyBoolean(), Matchers.anyBoolean());
    }

    @Test
    public void testProcessInstantiationWithParameters() throws IOException {
        Map<String, Object> parameters = VariablesBuilder.create().variable("aBoolean", Boolean.TRUE).variable("aString", "aStringVariableValue").variable("anInteger", 42).getVariables();
        HashMap<String, Map<String, Object>> json = new HashMap<String, Map<String, Object>>();
        json.put("variables", parameters);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcInstId"), new Object[0]).when().post(START_PROCESS_INSTANCE_URL, new Object[0]);
        HashMap<String, Object> expectedParameters = new HashMap<String, Object>();
        expectedParameters.put("aBoolean", Boolean.TRUE);
        expectedParameters.put("aString", "aStringVariableValue");
        expectedParameters.put("anInteger", 42);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createProcessInstanceById((String)Matchers.eq((Object)"aProcDefId"));
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).setVariables((Map)Matchers.argThat((Matcher)new EqualsMap(expectedParameters)));
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).executeWithVariablesInReturn(Matchers.anyBoolean(), Matchers.anyBoolean());
    }

    @Test
    public void testProcessInstantiationWithBusinessKey() throws IOException {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("businessKey", "myBusinessKey");
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcInstId"), new Object[0]).when().post(START_PROCESS_INSTANCE_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createProcessInstanceById((String)Matchers.eq((Object)"aProcDefId"));
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).businessKey("myBusinessKey");
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).executeWithVariablesInReturn(Matchers.anyBoolean(), Matchers.anyBoolean());
    }

    @Test
    public void testProcessInstantiationWithBusinessKeyAndParameters() throws IOException {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("businessKey", "myBusinessKey");
        Map<String, Object> parameters = VariablesBuilder.create().variable("aBoolean", Boolean.TRUE).variable("aString", "aStringVariableValue").variable("anInteger", 42).getVariables();
        json.put("variables", parameters);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcInstId"), new Object[0]).when().post(START_PROCESS_INSTANCE_URL, new Object[0]);
        HashMap<String, Object> expectedParameters = new HashMap<String, Object>();
        expectedParameters.put("aBoolean", Boolean.TRUE);
        expectedParameters.put("aString", "aStringVariableValue");
        expectedParameters.put("anInteger", 42);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createProcessInstanceById((String)Matchers.eq((Object)"aProcDefId"));
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).businessKey("myBusinessKey");
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).setVariables((Map)Matchers.argThat((Matcher)new EqualsMap(expectedParameters)));
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).executeWithVariablesInReturn(Matchers.anyBoolean(), Matchers.anyBoolean());
    }

    @Test
    public void testProcessInstantiationWithTransientVariables() throws IOException {
        HashMap<String, Map<String, Object>> json = new HashMap<String, Map<String, Object>>();
        json.put("variables", VariablesBuilder.create().variableTransient("foo", "bar", "string").getVariables());
        VariableMapImpl varMap = new VariableMapImpl();
        Mockito.when((Object)this.mockInstantiationBuilder.setVariables(Mockito.anyMapOf(String.class, Object.class))).thenAnswer((Answer)new Answer<ProcessInstantiationBuilder>((VariableMap)varMap){
            final /* synthetic */ VariableMap val$varMap;
            {
                this.val$varMap = variableMap;
            }

            public ProcessInstantiationBuilder answer(InvocationOnMock invocation) throws Throwable {
                this.val$varMap.putAll((Map)((VariableMap)invocation.getArguments()[0]));
                return ProcessDefinitionRestServiceInteractionTest.this.mockInstantiationBuilder;
            }
        });
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcInstId"), new Object[0]).when().post(START_PROCESS_INSTANCE_URL, new Object[0]);
        VariableMap expectedVariables = Variables.createVariables().putValueTyped("foo", (TypedValue)Variables.stringValue((String)"bar", (boolean)true));
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createProcessInstanceById((String)Matchers.eq((Object)"aProcDefId"));
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).setVariables((Map)expectedVariables);
        Assert.assertEquals((Object)expectedVariables.getValueTyped("foo").isTransient(), (Object)varMap.getValueTyped("foo").isTransient());
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).executeWithVariablesInReturn(Matchers.anyBoolean(), Matchers.anyBoolean());
    }

    @Test
    public void testProcessInstantiationAtActivitiesById() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("variables", VariablesBuilder.create().variable("processVariable", (Object)"aString", "String").getVariables());
        json.put("businessKey", "aBusinessKey");
        json.put("caseInstanceId", "aCaseInstanceId");
        ArrayList<Map<String, Object>> startInstructions = new ArrayList<Map<String, Object>>();
        startInstructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").variables(VariablesBuilder.create().variable("var", "value", "String", false).variable("varLocal", "valueLocal", "String", true).getVariables()).getJson());
        startInstructions.add(ModificationInstructionBuilder.startAfter().activityId("activityId").variables(VariablesBuilder.create().variable("var", 52, "Integer", false).variable("varLocal", 74, "Integer", true).getVariables()).getJson());
        startInstructions.add(ModificationInstructionBuilder.startTransition().transitionId("transitionId").variables(VariablesBuilder.create().variable("var", 53, "Integer", false).variable("varLocal", 75, "Integer", true).getVariables()).getJson());
        json.put("startInstructions", startInstructions);
        RestAssured.given().pathParam("id", (Object)"aProcessDefinitionId").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcInstId"), new Object[0]).when().post(START_PROCESS_INSTANCE_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createProcessInstanceById((String)Matchers.eq((Object)"aProcessDefinitionId"));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockInstantiationBuilder});
        ((ProcessInstantiationBuilder)inOrder.verify((Object)this.mockInstantiationBuilder)).businessKey("aBusinessKey");
        ((ProcessInstantiationBuilder)inOrder.verify((Object)this.mockInstantiationBuilder)).caseInstanceId("aCaseInstanceId");
        ((ProcessInstantiationBuilder)inOrder.verify((Object)this.mockInstantiationBuilder)).setVariables((Map)Matchers.argThat((Matcher)EqualsVariableMap.matches().matcher("processVariable", (Matcher<?>)EqualsPrimitiveValue.stringValue("aString"))));
        ((ProcessInstantiationBuilder)inOrder.verify((Object)this.mockInstantiationBuilder)).startBeforeActivity("activityId");
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).setVariableLocal((String)Matchers.eq((Object)"varLocal"), Matchers.argThat((Matcher)EqualsPrimitiveValue.stringValue("valueLocal")));
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).setVariable((String)Matchers.eq((Object)"var"), Matchers.argThat((Matcher)EqualsPrimitiveValue.stringValue("value")));
        ((ProcessInstantiationBuilder)inOrder.verify((Object)this.mockInstantiationBuilder)).startAfterActivity("activityId");
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).setVariable((String)Matchers.eq((Object)"var"), Matchers.argThat((Matcher)EqualsPrimitiveValue.integerValue(52)));
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).setVariableLocal((String)Matchers.eq((Object)"varLocal"), Matchers.argThat((Matcher)EqualsPrimitiveValue.integerValue(74)));
        ((ProcessInstantiationBuilder)inOrder.verify((Object)this.mockInstantiationBuilder)).startTransition("transitionId");
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).setVariable((String)Matchers.eq((Object)"var"), Matchers.argThat((Matcher)EqualsPrimitiveValue.integerValue(53)));
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).setVariableLocal((String)Matchers.eq((Object)"varLocal"), Matchers.argThat((Matcher)EqualsPrimitiveValue.integerValue(75)));
        ((ProcessInstantiationBuilder)inOrder.verify((Object)this.mockInstantiationBuilder)).executeWithVariablesInReturn(false, false);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testProcessInstantiationAtActivitiesByIdWithVariablesInReturn() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("variables", VariablesBuilder.create().variable("processVariable", (Object)"aString", "String").getVariables());
        json.put("businessKey", "aBusinessKey");
        json.put("caseInstanceId", "aCaseInstanceId");
        VariableMap variables = MockProvider.createMockSerializedVariables().putValueTyped("processVariable", (TypedValue)Variables.stringValue((String)"aString")).putValueTyped("var", (TypedValue)Variables.stringValue((String)"value")).putValueTyped("varLocal", (TypedValue)Variables.stringValue((String)"valueLocal"));
        ProcessInstanceWithVariables mockInstance = MockProvider.createMockInstanceWithVariables();
        Mockito.when((Object)mockInstance.getVariables()).thenReturn((Object)variables);
        ProcessInstantiationBuilder mockInstantiationBuilder = this.setUpMockInstantiationBuilder();
        Mockito.when((Object)mockInstantiationBuilder.executeWithVariablesInReturn(Matchers.anyBoolean(), Matchers.anyBoolean())).thenReturn((Object)mockInstance);
        Mockito.when((Object)this.runtimeServiceMock.createProcessInstanceById(Matchers.anyString())).thenReturn((Object)mockInstantiationBuilder);
        ArrayList<Map<String, Object>> startInstructions = new ArrayList<Map<String, Object>>();
        startInstructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").variables(VariablesBuilder.create().variable("var", "value", "String", false).variable("varLocal", "valueLocal", "String", true).getVariables()).getJson());
        json.put("startInstructions", startInstructions);
        json.put("withVariablesInReturn", true);
        RestAssured.given().pathParam("id", (Object)"aProcessDefinitionId").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcInstId"), new Object[0]).body("variables.aVariableInstanceName.value", org.hamcrest.Matchers.equalTo((Object)"aSerializedValue"), new Object[0]).body("variables.aVariableInstanceName.type", org.hamcrest.Matchers.equalTo((Object)"Object"), new Object[0]).body("variables.aVariableInstanceName.valueInfo.objectTypeName", org.hamcrest.Matchers.equalTo((Object)ArrayList.class.getName()), new Object[0]).body("variables.aVariableInstanceName.valueInfo.serializationDataFormat", org.hamcrest.Matchers.equalTo((Object)"application/json"), new Object[0]).body("variables.aDeserializedVariableInstanceName.value", org.hamcrest.Matchers.equalTo((Object)"aSerializedValue"), new Object[0]).body("variables.aDeserializedVariableInstanceName.type", org.hamcrest.Matchers.equalTo((Object)"Object"), new Object[0]).body("variables.aDeserializedVariableInstanceName.valueInfo.objectTypeName", org.hamcrest.Matchers.equalTo((Object)Object.class.getName()), new Object[0]).body("variables.aDeserializedVariableInstanceName.valueInfo.serializationDataFormat", org.hamcrest.Matchers.equalTo((Object)"application/json"), new Object[0]).body("variables.processVariable.type", org.hamcrest.Matchers.equalTo((Object)"String"), new Object[0]).body("variables.processVariable.value", org.hamcrest.Matchers.equalTo((Object)"aString"), new Object[0]).body("variables.var.type", org.hamcrest.Matchers.equalTo((Object)"String"), new Object[0]).body("variables.var.value", org.hamcrest.Matchers.equalTo((Object)"value"), new Object[0]).body("variables.varLocal.type", org.hamcrest.Matchers.equalTo((Object)"String"), new Object[0]).body("variables.varLocal.value", org.hamcrest.Matchers.equalTo((Object)"valueLocal"), new Object[0]).when().post(START_PROCESS_INSTANCE_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createProcessInstanceById((String)Matchers.eq((Object)"aProcessDefinitionId"));
    }

    @Test
    public void testProcessInstantiationAtActivitiesByKey() {
        ProcessInstantiationBuilder mockInstantiationBuilder = this.setUpMockInstantiationBuilder();
        Mockito.when((Object)this.runtimeServiceMock.createProcessInstanceById(Matchers.anyString())).thenReturn((Object)mockInstantiationBuilder);
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("variables", VariablesBuilder.create().variable("processVariable", (Object)"aString", "String").getVariables());
        json.put("businessKey", "aBusinessKey");
        json.put("caseInstanceId", "aCaseInstanceId");
        ArrayList<Map<String, Object>> startInstructions = new ArrayList<Map<String, Object>>();
        startInstructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").variables(VariablesBuilder.create().variable("var", "value", "String", false).variable("varLocal", "valueLocal", "String", true).getVariables()).getJson());
        startInstructions.add(ModificationInstructionBuilder.startAfter().activityId("activityId").variables(VariablesBuilder.create().variable("var", 52, "Integer", false).variable("varLocal", 74, "Integer", true).getVariables()).getJson());
        startInstructions.add(ModificationInstructionBuilder.startTransition().transitionId("transitionId").variables(VariablesBuilder.create().variable("var", 53, "Integer", false).variable("varLocal", 75, "Integer", true).getVariables()).getJson());
        json.put("startInstructions", startInstructions);
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcInstId"), new Object[0]).when().post(START_PROCESS_INSTANCE_BY_KEY_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createProcessInstanceById((String)Matchers.eq((Object)"aProcDefId"));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockInstantiationBuilder});
        ((ProcessInstantiationBuilder)inOrder.verify((Object)mockInstantiationBuilder)).businessKey("aBusinessKey");
        ((ProcessInstantiationBuilder)inOrder.verify((Object)mockInstantiationBuilder)).caseInstanceId("aCaseInstanceId");
        ((ProcessInstantiationBuilder)inOrder.verify((Object)mockInstantiationBuilder)).setVariables((Map)Matchers.argThat((Matcher)EqualsVariableMap.matches().matcher("processVariable", (Matcher<?>)EqualsPrimitiveValue.stringValue("aString"))));
        ((ProcessInstantiationBuilder)inOrder.verify((Object)mockInstantiationBuilder)).startBeforeActivity("activityId");
        ((ProcessInstantiationBuilder)Mockito.verify((Object)mockInstantiationBuilder)).setVariableLocal((String)Matchers.eq((Object)"varLocal"), Matchers.argThat((Matcher)EqualsPrimitiveValue.stringValue("valueLocal")));
        ((ProcessInstantiationBuilder)Mockito.verify((Object)mockInstantiationBuilder)).setVariable((String)Matchers.eq((Object)"var"), Matchers.argThat((Matcher)EqualsPrimitiveValue.stringValue("value")));
        ((ProcessInstantiationBuilder)inOrder.verify((Object)mockInstantiationBuilder)).startAfterActivity("activityId");
        ((ProcessInstantiationBuilder)Mockito.verify((Object)mockInstantiationBuilder)).setVariable((String)Matchers.eq((Object)"var"), Matchers.argThat((Matcher)EqualsPrimitiveValue.integerValue(52)));
        ((ProcessInstantiationBuilder)Mockito.verify((Object)mockInstantiationBuilder)).setVariableLocal((String)Matchers.eq((Object)"varLocal"), Matchers.argThat((Matcher)EqualsPrimitiveValue.integerValue(74)));
        ((ProcessInstantiationBuilder)inOrder.verify((Object)mockInstantiationBuilder)).startTransition("transitionId");
        ((ProcessInstantiationBuilder)Mockito.verify((Object)mockInstantiationBuilder)).setVariable((String)Matchers.eq((Object)"var"), Matchers.argThat((Matcher)EqualsPrimitiveValue.integerValue(53)));
        ((ProcessInstantiationBuilder)Mockito.verify((Object)mockInstantiationBuilder)).setVariableLocal((String)Matchers.eq((Object)"varLocal"), Matchers.argThat((Matcher)EqualsPrimitiveValue.integerValue(75)));
        ((ProcessInstantiationBuilder)inOrder.verify((Object)mockInstantiationBuilder)).executeWithVariablesInReturn(false, false);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testProcessInstantiationAtActivitiesSkipIoMappingsAndListeners() {
        ProcessInstantiationBuilder mockInstantiationBuilder = this.setUpMockInstantiationBuilder();
        Mockito.when((Object)this.runtimeServiceMock.createProcessInstanceById(Matchers.anyString())).thenReturn((Object)mockInstantiationBuilder);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        ArrayList<Map<String, Object>> startInstructions = new ArrayList<Map<String, Object>>();
        startInstructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").getJson());
        json.put("startInstructions", startInstructions);
        json.put("skipIoMappings", Boolean.valueOf(true));
        json.put("skipCustomListeners", Boolean.valueOf(true));
        RestAssured.given().pathParam("id", (Object)"aProcessDefinitionId").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcInstId"), new Object[0]).when().post(START_PROCESS_INSTANCE_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createProcessInstanceById((String)Matchers.eq((Object)"aProcessDefinitionId"));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockInstantiationBuilder});
        ((ProcessInstantiationBuilder)inOrder.verify((Object)mockInstantiationBuilder)).startBeforeActivity("activityId");
        ((ProcessInstantiationBuilder)inOrder.verify((Object)mockInstantiationBuilder)).executeWithVariablesInReturn(true, true);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testInvalidInstantiationAtActivities() {
        ProcessInstantiationBuilder mockInstantiationBuilder = this.setUpMockInstantiationBuilder();
        Mockito.when((Object)this.runtimeServiceMock.createProcessInstanceById(Matchers.anyString())).thenReturn((Object)mockInstantiationBuilder);
        HashMap json = new HashMap();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        instructions.add(ModificationInstructionBuilder.startBefore().getJson());
        json.put("startInstructions", instructions);
        RestAssured.given().pathParam("id", (Object)"aProcessDefinitionId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)"'activityId' must be set"), new Object[0]).when().post(START_PROCESS_INSTANCE_URL, new Object[0]);
        instructions = new ArrayList();
        instructions.add(ModificationInstructionBuilder.startAfter().getJson());
        json.put("startInstructions", instructions);
        RestAssured.given().pathParam("id", (Object)"aProcessDefinitionId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)"'activityId' must be set"), new Object[0]).when().post(START_PROCESS_INSTANCE_URL, new Object[0]);
        instructions = new ArrayList();
        instructions.add(ModificationInstructionBuilder.startTransition().getJson());
        json.put("startInstructions", instructions);
        RestAssured.given().pathParam("id", (Object)"aProcessDefinitionId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)"'transitionId' must be set"), new Object[0]).when().post(START_PROCESS_INSTANCE_URL, new Object[0]);
    }

    protected ProcessInstantiationBuilder setUpMockInstantiationBuilder() {
        ProcessInstanceWithVariables resultInstanceWithVariables = MockProvider.createMockInstanceWithVariables();
        ProcessInstantiationBuilder mockInstantiationBuilder = (ProcessInstantiationBuilder)Mockito.mock(ProcessInstantiationBuilder.class);
        Mockito.when((Object)mockInstantiationBuilder.startAfterActivity(Matchers.anyString())).thenReturn((Object)mockInstantiationBuilder);
        Mockito.when((Object)mockInstantiationBuilder.startBeforeActivity(Matchers.anyString())).thenReturn((Object)mockInstantiationBuilder);
        Mockito.when((Object)mockInstantiationBuilder.startTransition(Matchers.anyString())).thenReturn((Object)mockInstantiationBuilder);
        Mockito.when((Object)mockInstantiationBuilder.setVariables((Map)Matchers.any(Map.class))).thenReturn((Object)mockInstantiationBuilder);
        Mockito.when((Object)mockInstantiationBuilder.setVariablesLocal((Map)Matchers.any(Map.class))).thenReturn((Object)mockInstantiationBuilder);
        Mockito.when((Object)mockInstantiationBuilder.businessKey(Matchers.anyString())).thenReturn((Object)mockInstantiationBuilder);
        Mockito.when((Object)mockInstantiationBuilder.caseInstanceId(Matchers.anyString())).thenReturn((Object)mockInstantiationBuilder);
        Mockito.when((Object)mockInstantiationBuilder.execute(Matchers.anyBoolean(), Matchers.anyBoolean())).thenReturn((Object)resultInstanceWithVariables);
        Mockito.when((Object)mockInstantiationBuilder.executeWithVariablesInReturn(Matchers.anyBoolean(), Matchers.anyBoolean())).thenReturn((Object)resultInstanceWithVariables);
        return mockInstantiationBuilder;
    }

    @Test
    public void testUnsuccessfulInstantiation() {
        Mockito.when((Object)this.mockInstantiationBuilder.executeWithVariablesInReturn(Matchers.anyBoolean(), Matchers.anyBoolean())).thenThrow(new Throwable[]{new ProcessEngineException("expected exception")});
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)"Cannot instantiate process definition"), new Object[0]).when().post(START_PROCESS_INSTANCE_URL, new Object[0]);
    }

    @Test
    public void testStartProcessInstanceByIdThrowsAuthorizationException() {
        String message = "expected exception";
        Mockito.when((Object)this.mockInstantiationBuilder.executeWithVariablesInReturn(Matchers.anyBoolean(), Matchers.anyBoolean())).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)message), new Object[0]).when().post(START_PROCESS_INSTANCE_URL, new Object[0]);
    }

    @Test
    public void testDefinitionRetrieval() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcDefId"), new Object[0]).body("key", org.hamcrest.Matchers.equalTo((Object)"aKey"), new Object[0]).body("category", org.hamcrest.Matchers.equalTo((Object)"aCategory"), new Object[0]).body("name", org.hamcrest.Matchers.equalTo((Object)"aName"), new Object[0]).body("description", org.hamcrest.Matchers.equalTo((Object)"aDescription"), new Object[0]).body("deploymentId", org.hamcrest.Matchers.equalTo((Object)"aDeploymentId"), new Object[0]).body("version", org.hamcrest.Matchers.equalTo((Object)42), new Object[0]).body("resource", org.hamcrest.Matchers.equalTo((Object)"aResourceName"), new Object[0]).body("diagram", org.hamcrest.Matchers.equalTo((Object)"aResourceName.png"), new Object[0]).body("suspended", org.hamcrest.Matchers.equalTo((Object)true), new Object[0]).body("tenantId", CoreMatchers.nullValue(), new Object[0]).when().get(SINGLE_PROCESS_DEFINITION_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).getProcessDefinition("aProcDefId");
    }

    @Test
    public void testNonExistingProcessDefinitionRetrieval() {
        String nonExistingId = "aNonExistingDefinitionId";
        Mockito.when((Object)this.repositoryServiceMock.getProcessDefinition((String)Matchers.eq((Object)nonExistingId))).thenThrow(new Throwable[]{new ProcessEngineException("no matching definition")});
        RestAssured.given().pathParam("id", (Object)"aNonExistingDefinitionId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)("No matching definition with id " + nonExistingId)), new Object[0]).when().get(SINGLE_PROCESS_DEFINITION_URL, new Object[0]);
    }

    @Test
    public void testNonExistingProcessDefinitionBpmn20XmlRetrieval() {
        String nonExistingId = "aNonExistingDefinitionId";
        Mockito.when((Object)this.repositoryServiceMock.getProcessModel((String)Matchers.eq((Object)nonExistingId))).thenThrow(new Throwable[]{new ProcessEngineException("no matching process definition found.")});
        RestAssured.given().pathParam("id", (Object)nonExistingId).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)("No matching definition with id " + nonExistingId)), new Object[0]).when().get(XML_DEFINITION_URL, new Object[0]);
    }

    @Test
    public void testGetProcessDefinitionBpmn20XmlThrowsAuthorizationException() {
        String message = "expected exception";
        Mockito.when((Object)this.repositoryServiceMock.getProcessModel((String)Matchers.eq((Object)"aProcDefId"))).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().pathParam("id", (Object)"aProcDefId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)message), new Object[0]).when().get(XML_DEFINITION_URL, new Object[0]);
    }

    @Test
    public void testDeleteDeployment() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").expect().statusCode(Response.Status.OK.getStatusCode()).when().delete(SINGLE_PROCESS_DEFINITION_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).deleteProcessDefinition("aProcDefId", false, false, false);
    }

    @Test
    public void testDeleteDeploymentCascade() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("cascade", new Object[]{true}).expect().statusCode(Response.Status.OK.getStatusCode()).when().delete(SINGLE_PROCESS_DEFINITION_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).deleteProcessDefinition("aProcDefId", true, false, false);
    }

    @Test
    public void testDeleteDeploymentCascadeNonsense() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("cascade", new Object[]{"bla"}).expect().statusCode(Response.Status.OK.getStatusCode()).when().delete(SINGLE_PROCESS_DEFINITION_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).deleteProcessDefinition("aProcDefId", false, false, false);
    }

    @Test
    public void testDeleteDeploymentCascadeFalse() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("cascade", new Object[]{false}).expect().statusCode(Response.Status.OK.getStatusCode()).when().delete(SINGLE_PROCESS_DEFINITION_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).deleteProcessDefinition("aProcDefId", false, false, false);
    }

    @Test
    public void testDeleteDeploymentSkipCustomListeners() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("skipCustomListeners", new Object[]{true}).expect().statusCode(Response.Status.OK.getStatusCode()).when().delete(SINGLE_PROCESS_DEFINITION_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).deleteProcessDefinition("aProcDefId", false, true, false);
    }

    @Test
    public void testDeleteDeploymentSkipCustomListenersNonsense() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("skipCustomListeners", new Object[]{"bla"}).expect().statusCode(Response.Status.OK.getStatusCode()).when().delete(SINGLE_PROCESS_DEFINITION_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).deleteProcessDefinition("aProcDefId", false, false, false);
    }

    @Test
    public void testDeleteDeploymentSkipCustomListenersFalse() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("skipCustomListeners", new Object[]{false}).expect().statusCode(Response.Status.OK.getStatusCode()).when().delete(SINGLE_PROCESS_DEFINITION_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).deleteProcessDefinition("aProcDefId", false, false, false);
    }

    @Test
    public void testDeleteDeploymentSkipCustomListenersAndCascade() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("cascade", new Object[]{true}).queryParam("skipCustomListeners", new Object[]{true}).expect().statusCode(Response.Status.OK.getStatusCode()).when().delete(SINGLE_PROCESS_DEFINITION_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).deleteProcessDefinition("aProcDefId", true, true, false);
    }

    @Test
    public void testDeleteNonExistingDeployment() {
        ((RepositoryService)Mockito.doThrow((Throwable)new NotFoundException("No process definition found with id 'NON_EXISTING_ID'")).when((Object)this.repositoryServiceMock)).deleteProcessDefinition("NON_EXISTING_ID", false, false, false);
        RestAssured.given().pathParam("id", (Object)"NON_EXISTING_ID").expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(org.hamcrest.Matchers.containsString((String)"No process definition found with id 'NON_EXISTING_ID'"), new Matcher[0]).when().delete(SINGLE_PROCESS_DEFINITION_URL, new Object[0]);
    }

    @Test
    public void testDeleteDeploymentThrowsAuthorizationException() {
        String message = "expected exception";
        ((RepositoryService)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.repositoryServiceMock)).deleteProcessDefinition("aProcDefId", false, false, false);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)message), new Object[0]).when().delete(SINGLE_PROCESS_DEFINITION_URL, new Object[0]);
    }

    @Test
    public void testDeleteDefinitionSkipIoMappings() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("skipIoMappings", new Object[]{true}).expect().statusCode(Response.Status.OK.getStatusCode()).when().delete(SINGLE_PROCESS_DEFINITION_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).deleteProcessDefinition("aProcDefId", false, false, true);
    }

    @Test
    public void testDeleteDefinitionsByKey() {
        RestAssured.given().pathParam("key", (Object)"aKey").expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_PROCESS_DEFINITION_BY_KEY_DELETE_URL, new Object[0]);
        DeleteProcessDefinitionsTenantBuilder builder = this.repositoryServiceMock.deleteProcessDefinitions().byKey("aKey");
        ((DeleteProcessDefinitionsBuilder)Mockito.verify((Object)builder)).delete();
    }

    @Test
    public void testDeleteDefinitionsByKeyCascade() {
        RestAssured.given().pathParam("key", (Object)"aKey").queryParam("cascade", new Object[]{true}).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_PROCESS_DEFINITION_BY_KEY_DELETE_URL, new Object[0]);
        DeleteProcessDefinitionsBuilder builder = this.repositoryServiceMock.deleteProcessDefinitions().byKey("aKey").cascade();
        ((DeleteProcessDefinitionsBuilder)Mockito.verify((Object)builder)).delete();
    }

    @Test
    public void testDeleteDefinitionsByKeySkipCustomListeners() {
        RestAssured.given().pathParam("key", (Object)"aKey").queryParam("skipCustomListeners", new Object[]{true}).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_PROCESS_DEFINITION_BY_KEY_DELETE_URL, new Object[0]);
        DeleteProcessDefinitionsBuilder builder = this.repositoryServiceMock.deleteProcessDefinitions().byKey("aKey").skipCustomListeners();
        ((DeleteProcessDefinitionsBuilder)Mockito.verify((Object)builder)).delete();
    }

    @Test
    public void testDeleteDefinitionsByKeySkipIoMappings() {
        RestAssured.given().pathParam("key", (Object)"aKey").queryParam("skipIoMappings", new Object[]{true}).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_PROCESS_DEFINITION_BY_KEY_DELETE_URL, new Object[0]);
        DeleteProcessDefinitionsBuilder builder = this.repositoryServiceMock.deleteProcessDefinitions().byKey("aKey").skipIoMappings();
        ((DeleteProcessDefinitionsBuilder)Mockito.verify((Object)builder)).delete();
    }

    @Test
    public void testDeleteDefinitionsByKeySkipCustomListenersAndCascade() {
        RestAssured.given().pathParam("key", (Object)"aKey").queryParam("cascade", new Object[]{true}).queryParam("skipCustomListeners", new Object[]{true}).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_PROCESS_DEFINITION_BY_KEY_DELETE_URL, new Object[0]);
        DeleteProcessDefinitionsBuilder builder = this.repositoryServiceMock.deleteProcessDefinitions().byKey("aKey").skipCustomListeners().cascade();
        ((DeleteProcessDefinitionsBuilder)Mockito.verify((Object)builder)).delete();
    }

    @Test
    public void testDeleteDefinitionsByKeyNotExistingKey() {
        DeleteProcessDefinitionsTenantBuilder builder = this.repositoryServiceMock.deleteProcessDefinitions().byKey("NOT_EXISTING_KEY");
        ((DeleteProcessDefinitionsBuilder)Mockito.doThrow((Throwable)new NotFoundException("No process definition found with key 'NOT_EXISTING_KEY'")).when((Object)builder)).delete();
        RestAssured.given().pathParam("key", (Object)"NOT_EXISTING_KEY").expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(org.hamcrest.Matchers.containsString((String)"No process definition found with key 'NOT_EXISTING_KEY'"), new Matcher[0]).when().delete(SINGLE_PROCESS_DEFINITION_BY_KEY_DELETE_URL, new Object[0]);
    }

    @Test
    public void testDeleteDefinitionsByKeyWithTenantId() {
        RestAssured.given().pathParam("key", (Object)"aKey").pathParam("tenant-id", (Object)"aTenantId").expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_PROCESS_DEFINITION_BY_KEY_AND_TENANT_ID_DELETE_URL, new Object[0]);
        DeleteProcessDefinitionsBuilder builder = this.repositoryServiceMock.deleteProcessDefinitions().byKey("aKey").withTenantId("aTenantId");
        ((DeleteProcessDefinitionsBuilder)Mockito.verify((Object)builder)).delete();
    }

    @Test
    public void testDeleteDefinitionsByKeyCascadeWithTenantId() {
        RestAssured.given().pathParam("key", (Object)"aKey").pathParam("tenant-id", (Object)"aTenantId").queryParam("cascade", new Object[]{true}).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_PROCESS_DEFINITION_BY_KEY_AND_TENANT_ID_DELETE_URL, new Object[0]);
        DeleteProcessDefinitionsBuilder builder = this.repositoryServiceMock.deleteProcessDefinitions().byKey("aKey").withTenantId("aTenantId").cascade();
        ((DeleteProcessDefinitionsBuilder)Mockito.verify((Object)builder)).delete();
    }

    @Test
    public void testDeleteDefinitionsByKeySkipCustomListenersWithTenantId() {
        RestAssured.given().pathParam("key", (Object)"aKey").pathParam("tenant-id", (Object)"aTenantId").queryParam("skipCustomListeners", new Object[]{true}).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_PROCESS_DEFINITION_BY_KEY_AND_TENANT_ID_DELETE_URL, new Object[0]);
        DeleteProcessDefinitionsBuilder builder = this.repositoryServiceMock.deleteProcessDefinitions().byKey("aKey").withTenantId("aTenantId").skipCustomListeners();
        ((DeleteProcessDefinitionsBuilder)Mockito.verify((Object)builder)).delete();
    }

    @Test
    public void testDeleteDefinitionsByKeySkipCustomListenersAndCascadeWithTenantId() {
        RestAssured.given().pathParam("key", (Object)"aKey").queryParam("skipCustomListeners", new Object[]{true}).queryParam("cascade", new Object[]{true}).pathParam("tenant-id", (Object)"aTenantId").expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_PROCESS_DEFINITION_BY_KEY_AND_TENANT_ID_DELETE_URL, new Object[0]);
        DeleteProcessDefinitionsBuilder builder = this.repositoryServiceMock.deleteProcessDefinitions().byKey("aKey").withTenantId("aTenantId").skipCustomListeners().cascade();
        ((DeleteProcessDefinitionsBuilder)Mockito.verify((Object)builder)).delete();
    }

    @Test
    public void testDeleteDefinitionsByKeyNoPermissions() {
        DeleteProcessDefinitionsBuilder builder = this.repositoryServiceMock.deleteProcessDefinitions().byKey("aKey").withTenantId("aTenantId");
        ((DeleteProcessDefinitionsBuilder)Mockito.doThrow((Throwable)new AuthorizationException("No permission to delete process definitions")).when((Object)builder)).delete();
        RestAssured.given().pathParam("key", (Object)"aKey").pathParam("tenant-id", (Object)"aTenantId").expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body(org.hamcrest.Matchers.containsString((String)"No permission to delete process definitions"), new Matcher[0]).when().delete(SINGLE_PROCESS_DEFINITION_BY_KEY_AND_TENANT_ID_DELETE_URL, new Object[0]);
    }

    @Test
    public void testGetStartFormDataForNonExistingProcessDefinition() {
        Mockito.when((Object)this.formServiceMock.getStartFormData(Matchers.anyString())).thenThrow(new Throwable[]{new ProcessEngineException("expected exception")});
        RestAssured.given().pathParam("id", (Object)"aNonExistingProcessDefinitionId").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)"Cannot get start form data for process definition"), new Object[0]).when().get(START_FORM_URL, new Object[0]);
    }

    @Test
    public void testUnparseableIntegerVariable() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Integer";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)("Cannot instantiate process definition aProcDefId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Integer.class))), new Object[0]).when().post(START_PROCESS_INSTANCE_URL, new Object[0]);
    }

    @Test
    public void testUnparseableShortVariable() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Short";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)("Cannot instantiate process definition aProcDefId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Short.class))), new Object[0]).when().post(START_PROCESS_INSTANCE_URL, new Object[0]);
    }

    @Test
    public void testUnparseableLongVariable() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Long";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)("Cannot instantiate process definition aProcDefId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Long.class))), new Object[0]).when().post(START_PROCESS_INSTANCE_URL, new Object[0]);
    }

    @Test
    public void testUnparseableDoubleVariable() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Double";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)("Cannot instantiate process definition aProcDefId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Double.class))), new Object[0]).when().post(START_PROCESS_INSTANCE_URL, new Object[0]);
    }

    @Test
    public void testUnparseableDateVariable() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Date";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)("Cannot instantiate process definition aProcDefId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Date.class))), new Object[0]).when().post(START_PROCESS_INSTANCE_URL, new Object[0]);
    }

    @Test
    public void testNotSupportedTypeVariable() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "X";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)"Cannot instantiate process definition aProcDefId: Unsupported value type 'X'"), new Object[0]).when().post(START_PROCESS_INSTANCE_URL, new Object[0]);
    }

    @Test
    public void testActivateProcessDefinitionExcludingInstances() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", false);
        params.put("includeProcessInstances", false);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).activateProcessDefinitionById("aProcDefId", false, null);
    }

    @Test
    public void testDelayedActivateProcessDefinitionExcludingInstances() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("includeProcessInstances", false);
        params.put("executionDate", MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        Date executionDate = DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).activateProcessDefinitionById("aProcDefId", false, executionDate);
    }

    @Test
    public void testActivateProcessDefinitionIncludingInstances() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", false);
        params.put("includeProcessInstances", true);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).activateProcessDefinitionById("aProcDefId", true, null);
    }

    @Test
    public void testDelayedActivateProcessDefinitionIncludingInstances() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("includeProcessInstances", true);
        params.put("executionDate", MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        Date executionDate = DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).activateProcessDefinitionById("aProcDefId", true, executionDate);
    }

    @Test
    public void testActivateThrowsProcessEngineException() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", false);
        params.put("includeProcessInstances", false);
        String expectedMessage = "expectedMessage";
        ((RepositoryService)Mockito.doThrow((Throwable)new ProcessEngineException(expectedMessage)).when((Object)this.repositoryServiceMock)).activateProcessDefinitionById((String)Matchers.eq((Object)"aNonExistingProcDefId"), Matchers.eq((boolean)false), (Date)Matchers.isNull(Date.class));
        RestAssured.given().pathParam("id", (Object)"aNonExistingProcDefId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)expectedMessage), new Object[0]).when().put(SINGLE_PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateNonParseableDateFormat() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("includeProcessInstances", false);
        params.put("executionDate", "a");
        String expectedMessage = "Invalid format: \"a\"";
        String exceptionMessage = "The suspension state of Process Definition with id aNonExistingProcDefId could not be updated due to: " + expectedMessage;
        RestAssured.given().pathParam("id", (Object)"aNonExistingProcDefId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)exceptionMessage), new Object[0]).when().put(SINGLE_PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateProcessDefinitionThrowsAuthorizationException() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", false);
        String message = "expected exception";
        ((RepositoryService)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.repositoryServiceMock)).activateProcessDefinitionById("aProcDefId", false, null);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)message), new Object[0]).when().put(SINGLE_PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendProcessDefinitionExcludingInstances() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", true);
        params.put("includeProcessInstances", false);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).suspendProcessDefinitionById("aProcDefId", false, null);
    }

    @Test
    public void testDelayedSuspendProcessDefinitionExcludingInstances() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("includeProcessInstances", false);
        params.put("executionDate", MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        Date executionDate = DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).suspendProcessDefinitionById("aProcDefId", false, executionDate);
    }

    @Test
    public void testSuspendProcessDefinitionIncludingInstances() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", true);
        params.put("includeProcessInstances", true);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).suspendProcessDefinitionById("aProcDefId", true, null);
    }

    @Test
    public void testDelayedSuspendProcessDefinitionIncludingInstances() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("includeProcessInstances", true);
        params.put("executionDate", MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        Date executionDate = DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).suspendProcessDefinitionById("aProcDefId", true, executionDate);
    }

    @Test
    public void testSuspendThrowsProcessEngineException() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", true);
        params.put("includeProcessInstances", false);
        String expectedMessage = "expectedMessage";
        ((RepositoryService)Mockito.doThrow((Throwable)new ProcessEngineException(expectedMessage)).when((Object)this.repositoryServiceMock)).suspendProcessDefinitionById((String)Matchers.eq((Object)"aNonExistingProcDefId"), Matchers.eq((boolean)false), (Date)Matchers.isNull(Date.class));
        RestAssured.given().pathParam("id", (Object)"aNonExistingProcDefId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)expectedMessage), new Object[0]).when().put(SINGLE_PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendNonParseableDateFormat() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("includeProcessInstances", false);
        params.put("executionDate", "a");
        String expectedMessage = "Invalid format: \"a\"";
        String exceptionMessage = "The suspension state of Process Definition with id aNonExistingProcDefId could not be updated due to: " + expectedMessage;
        RestAssured.given().pathParam("id", (Object)"aNonExistingProcDefId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)exceptionMessage), new Object[0]).when().put(SINGLE_PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendWithMultipleByParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionKey", "aKey");
        String message = "Only one of processDefinitionId or processDefinitionKey should be set to update the suspension state.";
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)message), new Object[0]).when().put(SINGLE_PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendProcessDefinitionThrowsAuthorizationException() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", true);
        String message = "expected exception";
        ((RepositoryService)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.repositoryServiceMock)).suspendProcessDefinitionById("aProcDefId", false, null);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)message), new Object[0]).when().put(SINGLE_PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateProcessDefinitionByKey() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionKey", "aKey");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).activateProcessDefinitionByKey("aKey", false, null);
    }

    @Test
    public void testActivateProcessDefinitionByKeyIncludingInstaces() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("includeProcessInstances", true);
        params.put("processDefinitionKey", "aKey");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).activateProcessDefinitionByKey("aKey", true, null);
    }

    @Test
    public void testDelayedActivateProcessDefinitionByKey() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionKey", "aKey");
        params.put("executionDate", MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        Date executionDate = DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).activateProcessDefinitionByKey("aKey", false, executionDate);
    }

    @Test
    public void testDelayedActivateProcessDefinitionByKeyIncludingInstaces() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("includeProcessInstances", true);
        params.put("processDefinitionKey", "aKey");
        params.put("executionDate", MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        Date executionDate = DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).activateProcessDefinitionByKey("aKey", true, executionDate);
    }

    @Test
    public void testActivateProcessDefinitionByKeyWithUnparseableDate() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionKey", "aKey");
        params.put("executionDate", "a");
        String message = "Could not update the suspension state of Process Definitions due to: Invalid format: \"a\"";
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)message), new Object[0]).when().put(PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateProcessDefinitionByKeyWithException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionKey", "aKey");
        String expectedException = "expectedException";
        ((RepositoryService)Mockito.doThrow((Throwable)new ProcessEngineException(expectedException)).when((Object)this.repositoryServiceMock)).activateProcessDefinitionByKey("aKey", false, null);
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)expectedException), new Object[0]).when().put(PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateProcessDefinitionByKeyThrowsAuthorizationException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionKey", "aKey");
        String message = "expected exception";
        ((RepositoryService)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.repositoryServiceMock)).activateProcessDefinitionByKey("aKey", false, null);
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)message), new Object[0]).when().put(PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendProcessDefinitionByKey() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionKey", "aKey");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).suspendProcessDefinitionByKey("aKey", false, null);
    }

    @Test
    public void testSuspendProcessDefinitionByKeyIncludingInstaces() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("includeProcessInstances", true);
        params.put("processDefinitionKey", "aKey");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).suspendProcessDefinitionByKey("aKey", true, null);
    }

    @Test
    public void testDelayedSuspendProcessDefinitionByKey() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionKey", "aKey");
        params.put("executionDate", MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        Date executionDate = DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).suspendProcessDefinitionByKey("aKey", false, executionDate);
    }

    @Test
    public void testDelayedSuspendProcessDefinitionByKeyIncludingInstaces() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("includeProcessInstances", true);
        params.put("processDefinitionKey", "aKey");
        params.put("executionDate", MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        Date executionDate = DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).suspendProcessDefinitionByKey("aKey", true, executionDate);
    }

    @Test
    public void testSuspendProcessDefinitionByKeyWithUnparseableDate() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionKey", "aKey");
        params.put("executionDate", "a");
        String message = "Could not update the suspension state of Process Definitions due to: Invalid format: \"a\"";
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)message), new Object[0]).when().put(PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendProcessDefinitionByKeyWithException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionKey", "aKey");
        String expectedException = "expectedException";
        ((RepositoryService)Mockito.doThrow((Throwable)new ProcessEngineException(expectedException)).when((Object)this.repositoryServiceMock)).suspendProcessDefinitionByKey("aKey", false, null);
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)expectedException), new Object[0]).when().put(PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendProcessDefinitionByKeyThrowsAuthorizationException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionKey", "aKey");
        String message = "expected exception";
        ((RepositoryService)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.repositoryServiceMock)).suspendProcessDefinitionByKey("aKey", false, null);
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)message), new Object[0]).when().put(PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateProcessDefinitionByIdShouldThrowException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionId", "aProcDefId");
        String message = "Only processDefinitionKey can be set to update the suspension state.";
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)message), new Object[0]).when().put(PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateProcessDefinitionByNothing() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", false);
        String message = "Either processDefinitionId or processDefinitionKey should be set to update the suspension state.";
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)message), new Object[0]).when().put(PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendProcessDefinitionByIdShouldThrowException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionId", "aProcDefId");
        String message = "Only processDefinitionKey can be set to update the suspension state.";
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)message), new Object[0]).when().put(PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendProcessDefinitionByNothing() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", true);
        String message = "Either processDefinitionId or processDefinitionKey should be set to update the suspension state.";
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)message), new Object[0]).when().put(PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendProcessDefinitionThrowsAuthorizationExcpetion() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", true);
        String message = "Either processDefinitionId or processDefinitionKey should be set to update the suspension state.";
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)message), new Object[0]).when().put(PROCESS_DEFINITION_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testInstanceResourceLinkResult_ByKey() {
        String fullInstanceUrl = "http://localhost:" + PORT + "/rest-test" + "/process-instance/" + "aProcInstId";
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", org.hamcrest.Matchers.equalTo((Object)fullInstanceUrl), new Object[0]).when().post(START_PROCESS_INSTANCE_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testInstanceResourceLinkWithEnginePrefix_ByKey() {
        String startInstanceOnExplicitEngineUrl = "/rest-test/engine/default/process-definition/key/{key}/start";
        String fullInstanceUrl = "http://localhost:" + PORT + "/rest-test" + "/engine/default/process-instance/" + "aProcInstId";
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", org.hamcrest.Matchers.equalTo((Object)fullInstanceUrl), new Object[0]).when().post(startInstanceOnExplicitEngineUrl, new Object[0]);
    }

    @Test
    public void testProcessDefinitionBpmn20XmlRetrieval_ByKey() {
        Response response = (Response)RestAssured.given().pathParam("key", (Object)"aKey").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(XML_DEFINITION_BY_KEY_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertTrue((boolean)responseContent.contains("aProcDefId"));
        Assert.assertTrue((boolean)responseContent.contains("<?xml"));
    }

    @Test
    public void testGetProcessDefinitionBpmn20XmlThrowsAuthorizationException_ByKey() {
        String message = "expected exception";
        Mockito.when((Object)this.repositoryServiceMock.getProcessModel((String)Matchers.eq((Object)"aProcDefId"))).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().pathParam("key", (Object)"aKey").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)message), new Object[0]).when().get(XML_DEFINITION_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testGetStartFormData_ByKey() {
        RestAssured.given().pathParam("key", (Object)"aKey").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("key", org.hamcrest.Matchers.equalTo((Object)"aFormKey"), new Object[0]).when().get(START_FORM_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testGetStartFormThrowsAuthorizationException_ByKey() {
        String message = "expected exception";
        Mockito.when((Object)this.formServiceMock.getStartFormData("aProcDefId")).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().pathParam("key", (Object)"aKey").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)message), new Object[0]).when().get(START_FORM_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testGetStartForm_shouldReturnKeyContainingTaskId_ByKey() {
        ProcessDefinition mockDefinition = MockProvider.createMockDefinition();
        StartFormData mockStartFormData = MockProvider.createMockStartFormDataUsingFormFieldsWithoutFormKey(mockDefinition);
        Mockito.when((Object)this.formServiceMock.getStartFormData(mockDefinition.getId())).thenReturn((Object)mockStartFormData);
        RestAssured.given().pathParam("key", (Object)"aKey").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("key", org.hamcrest.Matchers.equalTo((Object)("embedded:engine://engine/:engine/process-definition/" + mockDefinition.getId() + "/rendered-form")), new Object[0]).body("contextPath", org.hamcrest.Matchers.equalTo((Object)"http://camunda.org/someContext"), new Object[0]).when().get(START_FORM_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testGetRenderedStartForm_ByKey() {
        String expectedResult = "<formField>anyContent</formField>";
        Mockito.when((Object)this.formServiceMock.getRenderedStartForm("aProcDefId")).thenReturn((Object)expectedResult);
        Response response = (Response)RestAssured.given().pathParam("key", (Object)"aKey").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(XHTML_XML_CONTENT_TYPE).when().get(RENDERED_FORM_BY_KEY_URL, new Object[0]);
        String responseContent = response.asString();
        Assertions.assertThat((String)responseContent).isEqualTo((Object)expectedResult);
    }

    @Test
    public void testGetRenderedStartFormReturnsNotFound_ByKey() {
        Mockito.when((Object)this.formServiceMock.getRenderedStartForm(Matchers.anyString(), Matchers.anyString())).thenReturn(null);
        RestAssured.given().pathParam("key", (Object)"aKey").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)"No matching rendered start form for process definition with the id aProcDefId found."), new Object[0]).when().get(RENDERED_FORM_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testGetRenderedStartFormThrowsAuthorizationException_ByKey() {
        String message = "expected exception";
        Mockito.when((Object)this.formServiceMock.getRenderedStartForm(Matchers.anyString())).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().pathParam("key", (Object)"aKey").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", org.hamcrest.Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)message), new Object[0]).when().get(RENDERED_FORM_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testSubmitStartForm_ByKey() {
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcInstId"), new Object[0]).body("definitionId", org.hamcrest.Matchers.equalTo((Object)"aProcDefId"), new Object[0]).body("businessKey", org.hamcrest.Matchers.equalTo((Object)"aKey"), new Object[0]).body("ended", org.hamcrest.Matchers.equalTo((Object)false), new Object[0]).body("suspended", org.hamcrest.Matchers.equalTo((Object)false), new Object[0]).when().post(SUBMIT_FORM_BY_KEY_URL, new Object[0]);
        ((FormService)Mockito.verify((Object)this.formServiceMock)).submitStartForm("aProcDefId", null);
    }

    @Test
    public void testSubmitStartFormWithParameters_ByKey() {
        Map<String, Object> variables = VariablesBuilder.create().variable("aVariable", "aStringValue").variable("anotherVariable", 42).variable("aThirdValue", Boolean.TRUE).getVariables();
        HashMap<String, Map<String, Object>> json = new HashMap<String, Map<String, Object>>();
        json.put("variables", variables);
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcInstId"), new Object[0]).body("definitionId", org.hamcrest.Matchers.equalTo((Object)"aProcDefId"), new Object[0]).body("businessKey", org.hamcrest.Matchers.equalTo((Object)"aKey"), new Object[0]).body("ended", org.hamcrest.Matchers.equalTo((Object)false), new Object[0]).body("suspended", org.hamcrest.Matchers.equalTo((Object)false), new Object[0]).when().post(SUBMIT_FORM_BY_KEY_URL, new Object[0]);
        HashMap<String, Object> expectedVariables = new HashMap<String, Object>();
        expectedVariables.put("aVariable", "aStringValue");
        expectedVariables.put("anotherVariable", 42);
        expectedVariables.put("aThirdValue", Boolean.TRUE);
        ((FormService)Mockito.verify((Object)this.formServiceMock)).submitStartForm((String)Matchers.eq((Object)"aProcDefId"), (Map)Matchers.argThat((Matcher)new EqualsMap(expectedVariables)));
    }

    @Test
    public void testSubmitStartFormWithBusinessKey_ByKey() {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("businessKey", "myBusinessKey");
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcInstId"), new Object[0]).body("definitionId", org.hamcrest.Matchers.equalTo((Object)"aProcDefId"), new Object[0]).body("businessKey", org.hamcrest.Matchers.equalTo((Object)"aKey"), new Object[0]).body("ended", org.hamcrest.Matchers.equalTo((Object)false), new Object[0]).body("suspended", org.hamcrest.Matchers.equalTo((Object)false), new Object[0]).when().post(SUBMIT_FORM_BY_KEY_URL, new Object[0]);
        ((FormService)Mockito.verify((Object)this.formServiceMock)).submitStartForm("aProcDefId", "myBusinessKey", null);
    }

    @Test
    public void testSubmitStartFormWithBusinessKeyAndParameters_ByKey() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("businessKey", "myBusinessKey");
        Map<String, Object> variables = VariablesBuilder.create().variable("aVariable", "aStringValue").variable("anotherVariable", 42).variable("aThirdValue", Boolean.TRUE).getVariables();
        json.put("variables", variables);
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcInstId"), new Object[0]).body("definitionId", org.hamcrest.Matchers.equalTo((Object)"aProcDefId"), new Object[0]).body("businessKey", org.hamcrest.Matchers.equalTo((Object)"aKey"), new Object[0]).body("ended", org.hamcrest.Matchers.equalTo((Object)false), new Object[0]).body("suspended", org.hamcrest.Matchers.equalTo((Object)false), new Object[0]).when().post(SUBMIT_FORM_BY_KEY_URL, new Object[0]);
        HashMap<String, Object> expectedVariables = new HashMap<String, Object>();
        expectedVariables.put("aVariable", "aStringValue");
        expectedVariables.put("anotherVariable", 42);
        expectedVariables.put("aThirdValue", Boolean.TRUE);
        ((FormService)Mockito.verify((Object)this.formServiceMock)).submitStartForm((String)Matchers.eq((Object)"aProcDefId"), (String)Matchers.eq((Object)"myBusinessKey"), (Map)Matchers.argThat((Matcher)new EqualsMap(expectedVariables)));
    }

    @Test
    public void testSubmitStartFormWithUnparseableIntegerVariable_ByKey() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Integer";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)("Cannot instantiate process definition aProcDefId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Integer.class))), new Object[0]).when().post(SUBMIT_FORM_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testSubmitStartFormWithUnparseableShortVariable_ByKey() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Short";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)("Cannot instantiate process definition aProcDefId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Short.class))), new Object[0]).when().post(SUBMIT_FORM_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testSubmitStartFormWithUnparseableLongVariable_ByKey() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Long";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)("Cannot instantiate process definition aProcDefId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Long.class))), new Object[0]).when().post(SUBMIT_FORM_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testSubmitStartFormWithUnparseableDoubleVariable_ByKey() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Double";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)("Cannot instantiate process definition aProcDefId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Double.class))), new Object[0]).when().post(SUBMIT_FORM_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testSubmitStartFormWithUnparseableDateVariable_ByKey() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Date";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)("Cannot instantiate process definition aProcDefId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Date.class))), new Object[0]).when().post(SUBMIT_FORM_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testSubmitStartFormWithNotSupportedVariableType_ByKey() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "X";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)"Cannot instantiate process definition aProcDefId: Unsupported value type 'X'"), new Object[0]).when().post(SUBMIT_FORM_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testUnsuccessfulSubmitStartForm_ByKey() {
        ((FormService)Mockito.doThrow((Throwable)new ProcessEngineException("expected exception")).when((Object)this.formServiceMock)).submitStartForm((String)Matchers.any(String.class), (Map)Matchers.any());
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)"Cannot instantiate process definition aProcDefId: expected exception"), new Object[0]).when().post(SUBMIT_FORM_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testSubmitFormByKeyThrowsAuthorizationException() {
        String message = "expected exception";
        ((FormService)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.formServiceMock)).submitStartForm((String)Matchers.any(String.class), (Map)Matchers.any());
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)message), new Object[0]).when().post(SUBMIT_FORM_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testSubmitFormByKeyThrowsFormFieldValidationException() {
        String message = "expected exception";
        ((FormService)Mockito.doThrow((Throwable)new FormFieldValidationException((Object)"form-exception", message)).when((Object)this.formServiceMock)).submitStartForm((String)Matchers.any(String.class), (Map)Matchers.any());
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)("Cannot instantiate process definition aProcDefId: " + message)), new Object[0]).when().post(SUBMIT_FORM_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testSimpleProcessInstantiation_ByKey() {
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcInstId"), new Object[0]).when().post(START_PROCESS_INSTANCE_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testProcessInstantiationWithParameters_ByKey() throws IOException {
        Map<String, Object> parameters = VariablesBuilder.create().variable("aBoolean", Boolean.TRUE).variable("aString", "aStringVariableValue").variable("anInteger", 42).getVariables();
        HashMap<String, Map<String, Object>> json = new HashMap<String, Map<String, Object>>();
        json.put("variables", parameters);
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcInstId"), new Object[0]).when().post(START_PROCESS_INSTANCE_BY_KEY_URL, new Object[0]);
        HashMap<String, Object> expectedParameters = new HashMap<String, Object>();
        expectedParameters.put("aBoolean", Boolean.TRUE);
        expectedParameters.put("aString", "aStringVariableValue");
        expectedParameters.put("anInteger", 42);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createProcessInstanceById((String)Matchers.eq((Object)"aProcDefId"));
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).setVariables((Map)Matchers.argThat((Matcher)new EqualsMap(expectedParameters)));
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).executeWithVariablesInReturn(Matchers.anyBoolean(), Matchers.anyBoolean());
    }

    @Test
    public void testProcessInstantiationWithBusinessKey_ByKey() throws IOException {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("businessKey", "myBusinessKey");
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcInstId"), new Object[0]).when().post(START_PROCESS_INSTANCE_BY_KEY_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createProcessInstanceById((String)Matchers.eq((Object)"aProcDefId"));
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).businessKey("myBusinessKey");
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).executeWithVariablesInReturn(Matchers.anyBoolean(), Matchers.anyBoolean());
    }

    @Test
    public void testProcessInstantiationWithBusinessKeyAndParameters_ByKey() throws IOException {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("businessKey", "myBusinessKey");
        Map<String, Object> parameters = VariablesBuilder.create().variable("aBoolean", Boolean.TRUE).variable("aString", "aStringVariableValue").variable("anInteger", 42).getVariables();
        json.put("variables", parameters);
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcInstId"), new Object[0]).when().post(START_PROCESS_INSTANCE_BY_KEY_URL, new Object[0]);
        HashMap<String, Object> expectedParameters = new HashMap<String, Object>();
        expectedParameters.put("aBoolean", Boolean.TRUE);
        expectedParameters.put("aString", "aStringVariableValue");
        expectedParameters.put("anInteger", 42);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createProcessInstanceById((String)Matchers.eq((Object)"aProcDefId"));
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).businessKey("myBusinessKey");
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).setVariables((Map)Matchers.argThat((Matcher)new EqualsMap(expectedParameters)));
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).executeWithVariablesInReturn(Matchers.anyBoolean(), Matchers.anyBoolean());
    }

    @Test
    public void testUnsuccessfulInstantiation_ByKey() {
        Mockito.when((Object)this.mockInstantiationBuilder.executeWithVariablesInReturn(Matchers.anyBoolean(), Matchers.anyBoolean())).thenThrow(new Throwable[]{new ProcessEngineException("expected exception")});
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)"Cannot instantiate process definition"), new Object[0]).when().post(START_PROCESS_INSTANCE_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testStartProcessInstanceByKeyThrowsAuthorizationException() {
        String message = "expected exception";
        Mockito.when((Object)this.mockInstantiationBuilder.executeWithVariablesInReturn(Matchers.anyBoolean(), Matchers.anyBoolean())).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)message), new Object[0]).when().post(START_PROCESS_INSTANCE_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testDefinitionRetrieval_ByKey() {
        RestAssured.given().pathParam("key", (Object)"aKey").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcDefId"), new Object[0]).body("key", org.hamcrest.Matchers.equalTo((Object)"aKey"), new Object[0]).body("category", org.hamcrest.Matchers.equalTo((Object)"aCategory"), new Object[0]).body("name", org.hamcrest.Matchers.equalTo((Object)"aName"), new Object[0]).body("description", org.hamcrest.Matchers.equalTo((Object)"aDescription"), new Object[0]).body("deploymentId", org.hamcrest.Matchers.equalTo((Object)"aDeploymentId"), new Object[0]).body("version", org.hamcrest.Matchers.equalTo((Object)42), new Object[0]).body("resource", org.hamcrest.Matchers.equalTo((Object)"aResourceName"), new Object[0]).body("diagram", org.hamcrest.Matchers.equalTo((Object)"aResourceName.png"), new Object[0]).body("suspended", org.hamcrest.Matchers.equalTo((Object)true), new Object[0]).body("tenantId", CoreMatchers.nullValue(), new Object[0]).when().get(SINGLE_PROCESS_DEFINITION_BY_KEY_URL, new Object[0]);
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.processDefinitionQueryMock)).withoutTenantId();
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).getProcessDefinition("aProcDefId");
    }

    @Test
    public void testNonExistingProcessDefinitionRetrieval_ByKey() {
        String nonExistingKey = "aNonExistingDefinitionKey";
        Mockito.when((Object)this.repositoryServiceMock.createProcessDefinitionQuery().processDefinitionKey(nonExistingKey)).thenReturn((Object)this.processDefinitionQueryMock);
        Mockito.when((Object)this.processDefinitionQueryMock.latestVersion()).thenReturn((Object)this.processDefinitionQueryMock);
        Mockito.when((Object)this.processDefinitionQueryMock.singleResult()).thenReturn(null);
        Mockito.when((Object)this.processDefinitionQueryMock.list()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.processDefinitionQueryMock.count()).thenReturn((Object)0L);
        RestAssured.given().pathParam("key", (Object)nonExistingKey).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)("No matching process definition with key: " + nonExistingKey + " and no tenant-id")), new Object[0]).when().get(SINGLE_PROCESS_DEFINITION_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testDefinitionRetrieval_ByKeyAndTenantId() {
        ProcessDefinition mockDefinition = MockProvider.mockDefinition().tenantId("aTenantId").build();
        this.setUpRuntimeDataForDefinition(mockDefinition);
        RestAssured.given().pathParam("key", (Object)"aKey").pathParam("tenant-id", (Object)"aTenantId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcDefId"), new Object[0]).body("key", org.hamcrest.Matchers.equalTo((Object)"aKey"), new Object[0]).body("category", org.hamcrest.Matchers.equalTo((Object)"aCategory"), new Object[0]).body("name", org.hamcrest.Matchers.equalTo((Object)"aName"), new Object[0]).body("description", org.hamcrest.Matchers.equalTo((Object)"aDescription"), new Object[0]).body("deploymentId", org.hamcrest.Matchers.equalTo((Object)"aDeploymentId"), new Object[0]).body("version", org.hamcrest.Matchers.equalTo((Object)42), new Object[0]).body("resource", org.hamcrest.Matchers.equalTo((Object)"aResourceName"), new Object[0]).body("diagram", org.hamcrest.Matchers.equalTo((Object)"aResourceName.png"), new Object[0]).body("suspended", org.hamcrest.Matchers.equalTo((Object)true), new Object[0]).body("tenantId", org.hamcrest.Matchers.equalTo((Object)"aTenantId"), new Object[0]).when().get(SINGLE_PROCESS_DEFINITION_BY_KEY_AND_TENANT_ID_URL, new Object[0]);
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.processDefinitionQueryMock)).tenantIdIn(new String[]{"aTenantId"});
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).getProcessDefinition("aProcDefId");
    }

    @Test
    public void testNonExistingProcessDefinitionRetrieval_ByKeyAndTenantId() {
        String nonExistingKey = "aNonExistingDefinitionKey";
        String nonExistingTenantId = "aNonExistingTenantId";
        Mockito.when((Object)this.repositoryServiceMock.createProcessDefinitionQuery().processDefinitionKey(nonExistingKey)).thenReturn((Object)this.processDefinitionQueryMock);
        Mockito.when((Object)this.processDefinitionQueryMock.singleResult()).thenReturn(null);
        RestAssured.given().pathParam("key", (Object)nonExistingKey).pathParam("tenant-id", (Object)nonExistingTenantId).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)("No matching process definition with key: " + nonExistingKey + " and tenant-id: " + nonExistingTenantId)), new Object[0]).when().get(SINGLE_PROCESS_DEFINITION_BY_KEY_AND_TENANT_ID_URL, new Object[0]);
    }

    @Test
    public void testSimpleProcessInstantiation_ByKeyAndTenantId() {
        ProcessDefinition mockDefinition = MockProvider.mockDefinition().tenantId("aTenantId").build();
        this.setUpRuntimeDataForDefinition(mockDefinition);
        RestAssured.given().pathParam("key", (Object)"aKey").pathParam("tenant-id", (Object)"aTenantId").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcInstId"), new Object[0]).when().post(START_PROCESS_INSTANCE_BY_KEY_AND_TENANT_ID_URL, new Object[0]);
        ((ProcessDefinitionQuery)Mockito.verify((Object)this.processDefinitionQueryMock)).tenantIdIn(new String[]{"aTenantId"});
    }

    @Test
    public void testUnparseableIntegerVariable_ByKey() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Integer";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)("Cannot instantiate process definition aProcDefId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Integer.class))), new Object[0]).when().post(START_PROCESS_INSTANCE_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testUnparseableShortVariable_ByKey() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Short";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)("Cannot instantiate process definition aProcDefId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Short.class))), new Object[0]).when().post(START_PROCESS_INSTANCE_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testUnparseableLongVariable_ByKey() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Long";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)("Cannot instantiate process definition aProcDefId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Long.class))), new Object[0]).when().post(START_PROCESS_INSTANCE_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testUnparseableDoubleVariable_ByKey() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Double";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)("Cannot instantiate process definition aProcDefId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Double.class))), new Object[0]).when().post(START_PROCESS_INSTANCE_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testUnparseableDateVariable_ByKey() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Date";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)("Cannot instantiate process definition aProcDefId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Date.class))), new Object[0]).when().post(START_PROCESS_INSTANCE_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testNotSupportedTypeVariable_ByKey() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "X";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)"Cannot instantiate process definition aProcDefId: Unsupported value type 'X'"), new Object[0]).when().post(START_PROCESS_INSTANCE_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testUpdateHistoryTimeToLive() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").content((Object)new HistoryTimeToLiveDto(Integer.valueOf(5))).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_DEFINITION_HISTORY_TIMETOLIVE_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).updateProcessDefinitionHistoryTimeToLive("aProcDefId", Integer.valueOf(5));
    }

    @Test
    public void testUpdateHistoryTimeToLiveNullValue() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").content((Object)new HistoryTimeToLiveDto()).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_DEFINITION_HISTORY_TIMETOLIVE_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).updateProcessDefinitionHistoryTimeToLive("aProcDefId", null);
    }

    @Test
    public void testUpdateHistoryTimeToLiveNegativeValue() {
        String expectedMessage = "expectedMessage";
        ((RepositoryService)Mockito.doThrow((Throwable)new BadUserRequestException(expectedMessage)).when((Object)this.repositoryServiceMock)).updateProcessDefinitionHistoryTimeToLive((String)Matchers.eq((Object)"aProcDefId"), Integer.valueOf(Matchers.eq((int)-1)));
        RestAssured.given().pathParam("id", (Object)"aProcDefId").content((Object)new HistoryTimeToLiveDto(Integer.valueOf(-1))).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)BadUserRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)expectedMessage), new Object[0]).when().put(SINGLE_PROCESS_DEFINITION_HISTORY_TIMETOLIVE_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).updateProcessDefinitionHistoryTimeToLive("aProcDefId", Integer.valueOf(-1));
    }

    @Test
    public void testUpdateHistoryTimeToLiveAuthorizationException() {
        String expectedMessage = "expectedMessage";
        ((RepositoryService)Mockito.doThrow((Throwable)new AuthorizationException(expectedMessage)).when((Object)this.repositoryServiceMock)).updateProcessDefinitionHistoryTimeToLive((String)Matchers.eq((Object)"aProcDefId"), Integer.valueOf(Matchers.eq((int)5)));
        RestAssured.given().pathParam("id", (Object)"aProcDefId").content((Object)new HistoryTimeToLiveDto(Integer.valueOf(5))).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)expectedMessage), new Object[0]).when().put(SINGLE_PROCESS_DEFINITION_HISTORY_TIMETOLIVE_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).updateProcessDefinitionHistoryTimeToLive("aProcDefId", Integer.valueOf(5));
    }

    @Test
    public void testActivateProcessDefinitionExcludingInstances_ByKey() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", false);
        params.put("includeProcessInstances", false);
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_DEFINITION_BY_KEY_SUSPENDED_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).activateProcessDefinitionById("aProcDefId", false, null);
    }

    @Test
    public void testDelayedActivateProcessDefinitionExcludingInstances_ByKey() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("includeProcessInstances", false);
        params.put("executionDate", MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        Date executionDate = DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_DEFINITION_BY_KEY_SUSPENDED_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).activateProcessDefinitionById("aProcDefId", false, executionDate);
    }

    @Test
    public void testActivateProcessDefinitionIncludingInstances_ByKey() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", false);
        params.put("includeProcessInstances", true);
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_DEFINITION_BY_KEY_SUSPENDED_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).activateProcessDefinitionById("aProcDefId", true, null);
    }

    @Test
    public void testDelayedActivateProcessDefinitionIncludingInstances_ByKey() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("includeProcessInstances", true);
        params.put("executionDate", MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        Date executionDate = DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_DEFINITION_BY_KEY_SUSPENDED_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).activateProcessDefinitionById("aProcDefId", true, executionDate);
    }

    @Test
    public void testActivateThrowsProcessEngineException_ByKey() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", false);
        params.put("includeProcessInstances", false);
        String expectedMessage = "expectedMessage";
        ((RepositoryService)Mockito.doThrow((Throwable)new ProcessEngineException(expectedMessage)).when((Object)this.repositoryServiceMock)).activateProcessDefinitionById((String)Matchers.eq((Object)"aProcDefId"), Matchers.eq((boolean)false), (Date)Matchers.isNull(Date.class));
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)expectedMessage), new Object[0]).when().put(SINGLE_PROCESS_DEFINITION_BY_KEY_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateNonParseableDateFormat_ByKey() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("includeProcessInstances", false);
        params.put("executionDate", "a");
        String expectedMessage = "Invalid format: \"a\"";
        String exceptionMessage = "The suspension state of Process Definition with id aProcDefId could not be updated due to: " + expectedMessage;
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)exceptionMessage), new Object[0]).when().put(SINGLE_PROCESS_DEFINITION_BY_KEY_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateProcessDefinitionThrowsAuthorizationException_ByKey() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", false);
        String message = "expected exception";
        ((RepositoryService)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.repositoryServiceMock)).activateProcessDefinitionById("aProcDefId", false, null);
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)message), new Object[0]).when().put(SINGLE_PROCESS_DEFINITION_BY_KEY_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendProcessDefinitionExcludingInstances_ByKey() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", true);
        params.put("includeProcessInstances", false);
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_DEFINITION_BY_KEY_SUSPENDED_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).suspendProcessDefinitionById("aProcDefId", false, null);
    }

    @Test
    public void testDelayedSuspendProcessDefinitionExcludingInstances_ByKey() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("includeProcessInstances", false);
        params.put("executionDate", MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        Date executionDate = DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_DEFINITION_BY_KEY_SUSPENDED_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).suspendProcessDefinitionById("aProcDefId", false, executionDate);
    }

    @Test
    public void testSuspendProcessDefinitionIncludingInstances_ByKey() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", true);
        params.put("includeProcessInstances", true);
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_DEFINITION_BY_KEY_SUSPENDED_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).suspendProcessDefinitionById("aProcDefId", true, null);
    }

    @Test
    public void testDelayedSuspendProcessDefinitionIncludingInstances_ByKey() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("includeProcessInstances", true);
        params.put("executionDate", MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        Date executionDate = DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_PROCESS_DEFINITION_DELAYED_EXECUTION);
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_DEFINITION_BY_KEY_SUSPENDED_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).suspendProcessDefinitionById("aProcDefId", true, executionDate);
    }

    @Test
    public void testSuspendThrowsProcessEngineException_ByKey() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", true);
        params.put("includeProcessInstances", false);
        String expectedMessage = "expectedMessage";
        ((RepositoryService)Mockito.doThrow((Throwable)new ProcessEngineException(expectedMessage)).when((Object)this.repositoryServiceMock)).suspendProcessDefinitionById((String)Matchers.eq((Object)"aProcDefId"), Matchers.eq((boolean)false), (Date)Matchers.isNull(Date.class));
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)expectedMessage), new Object[0]).when().put(SINGLE_PROCESS_DEFINITION_BY_KEY_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendNonParseableDateFormat_ByKey() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("includeProcessInstances", false);
        params.put("executionDate", "a");
        String expectedMessage = "Invalid format: \"a\"";
        String exceptionMessage = "The suspension state of Process Definition with id aProcDefId could not be updated due to: " + expectedMessage;
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)exceptionMessage), new Object[0]).when().put(SINGLE_PROCESS_DEFINITION_BY_KEY_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendProcessDefinitionThrowsAuthorizationException_ByKey() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", true);
        String message = "expected exception";
        ((RepositoryService)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.repositoryServiceMock)).suspendProcessDefinitionById("aProcDefId", false, null);
        RestAssured.given().pathParam("key", (Object)"aKey").contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)message), new Object[0]).when().put(SINGLE_PROCESS_DEFINITION_BY_KEY_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testProcessInstantiationWithCaseInstanceId() throws IOException {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("caseInstanceId", "myCaseInstanceId");
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcInstId"), new Object[0]).when().post(START_PROCESS_INSTANCE_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createProcessInstanceById((String)Matchers.eq((Object)"aProcDefId"));
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).caseInstanceId("myCaseInstanceId");
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).executeWithVariablesInReturn(Matchers.anyBoolean(), Matchers.anyBoolean());
    }

    @Test
    public void testProcessInstantiationWithCaseInstanceIdAndBusinessKey() throws IOException {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("caseInstanceId", "myCaseInstanceId");
        json.put("businessKey", "myBusinessKey");
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcInstId"), new Object[0]).when().post(START_PROCESS_INSTANCE_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createProcessInstanceById((String)Matchers.eq((Object)"aProcDefId"));
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).businessKey("myBusinessKey");
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).caseInstanceId("myCaseInstanceId");
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).executeWithVariablesInReturn(Matchers.anyBoolean(), Matchers.anyBoolean());
    }

    @Test
    public void testProcessInstantiationWithCaseInstanceIdAndBusinessKeyAndParameters() throws IOException {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("caseInstanceId", "myCaseInstanceId");
        json.put("businessKey", "myBusinessKey");
        Map<String, Object> parameters = VariablesBuilder.create().variable("aBoolean", Boolean.TRUE).variable("aString", "aStringVariableValue").variable("anInteger", 42).getVariables();
        json.put("variables", parameters);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aProcInstId"), new Object[0]).when().post(START_PROCESS_INSTANCE_URL, new Object[0]);
        HashMap<String, Object> expectedParameters = new HashMap<String, Object>();
        expectedParameters.put("aBoolean", Boolean.TRUE);
        expectedParameters.put("aString", "aStringVariableValue");
        expectedParameters.put("anInteger", 42);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createProcessInstanceById((String)Matchers.eq((Object)"aProcDefId"));
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).businessKey("myBusinessKey");
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).caseInstanceId("myCaseInstanceId");
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).setVariables((Map)Matchers.argThat((Matcher)new EqualsMap(expectedParameters)));
        ((ProcessInstantiationBuilder)Mockito.verify((Object)this.mockInstantiationBuilder)).executeWithVariablesInReturn(Matchers.anyBoolean(), Matchers.anyBoolean());
    }

    @Test
    public void testGetStartFormVariablesThrowsAuthorizationException_ByKey() {
        String message = "expected exception";
        Mockito.when((Object)this.formServiceMock.getStartFormVariables("aProcDefId", null, true)).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().pathParam("key", (Object)"aKey").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)message), new Object[0]).when().get(START_FORM_VARIABLES_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testGetDeployedStartForm_ByKey() {
        ByteArrayInputStream deployedStartFormMock = new ByteArrayInputStream("Test".getBytes());
        Mockito.when((Object)this.formServiceMock.getDeployedStartForm("aProcDefId")).thenReturn((Object)deployedStartFormMock);
        RestAssured.given().pathParam("key", (Object)"aKey").then().expect().statusCode(Response.Status.OK.getStatusCode()).body(org.hamcrest.Matchers.equalTo((Object)"Test"), new Matcher[0]).when().get(DEPLOYED_START_FORM_BY_KEY_URL, new Object[0]);
        ((FormService)Mockito.verify((Object)this.formServiceMock)).getDeployedStartForm("aProcDefId");
    }

    @Test
    public void testGetDeployedStartForm() {
        ByteArrayInputStream deployedStartFormMock = new ByteArrayInputStream("Test".getBytes());
        Mockito.when((Object)this.formServiceMock.getDeployedStartForm("aProcDefId")).thenReturn((Object)deployedStartFormMock);
        RestAssured.given().pathParam("id", (Object)"aProcDefId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body(org.hamcrest.Matchers.equalTo((Object)"Test"), new Matcher[0]).when().get(DEPLOYED_START_FORM_URL, new Object[0]);
        ((FormService)Mockito.verify((Object)this.formServiceMock)).getDeployedStartForm("aProcDefId");
    }

    @Test
    public void testGetDeployedStartFormWithoutAuthorization() {
        String message = "unauthorized";
        Mockito.when((Object)this.formServiceMock.getDeployedStartForm("aProcDefId")).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().pathParam("id", (Object)"aProcDefId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("message", org.hamcrest.Matchers.equalTo((Object)message), new Object[0]).when().get(DEPLOYED_START_FORM_URL, new Object[0]);
    }

    @Test
    public void testGetDeployedStartFormWithWrongFormKeyFormat() {
        String message = "wrong key format";
        Mockito.when((Object)this.formServiceMock.getDeployedStartForm("aProcDefId")).thenThrow(new Throwable[]{new BadUserRequestException(message)});
        RestAssured.given().pathParam("id", (Object)"aProcDefId").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("message", org.hamcrest.Matchers.equalTo((Object)message), new Object[0]).when().get(DEPLOYED_START_FORM_URL, new Object[0]);
    }

    @Test
    public void testGetDeployedStartFormWithUnexistingForm() {
        String message = "not found";
        Mockito.when((Object)this.formServiceMock.getDeployedStartForm("aProcDefId")).thenThrow(new Throwable[]{new NotFoundException(message)});
        RestAssured.given().pathParam("id", (Object)"aProcDefId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("message", org.hamcrest.Matchers.equalTo((Object)message), new Object[0]).when().get(DEPLOYED_START_FORM_URL, new Object[0]);
    }
}

