/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.identity.UserQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class UserRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String USER_QUERY_URL = "/rest-test/user";
    protected static final String USER_COUNT_QUERY_URL = "/rest-test/user/count";
    private UserQuery mockQuery;

    @Before
    public void setUpRuntimeData() {
        this.mockQuery = this.setUpMockUserQuery(MockProvider.createMockUsers());
    }

    private UserQuery setUpMockUserQuery(List<User> list) {
        UserQuery sampleUserQuery = (UserQuery)Mockito.mock(UserQuery.class);
        Mockito.when((Object)sampleUserQuery.list()).thenReturn(list);
        Mockito.when((Object)sampleUserQuery.count()).thenReturn((Object)list.size());
        Mockito.when((Object)processEngine.getIdentityService().createUserQuery()).thenReturn((Object)sampleUserQuery);
        return sampleUserQuery;
    }

    @Test
    public void testEmptyQuery() {
        String queryKey = "";
        RestAssured.given().queryParam("name", new Object[]{queryKey}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(USER_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().queryParam("sortBy", new Object[]{"firstName"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(USER_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(USER_QUERY_URL, new Object[0]);
    }

    @Test
    public void testNoParametersQuery() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(USER_QUERY_URL, new Object[0]);
        ((UserQuery)Mockito.verify((Object)this.mockQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockQuery});
    }

    @Test
    public void testSimpleUserQuery() {
        String queryFirstName = "firstName";
        Response response = (Response)RestAssured.given().queryParam("firstName", new Object[]{queryFirstName}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(USER_QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        ((UserQuery)inOrder.verify((Object)this.mockQuery)).userFirstName(queryFirstName);
        ((UserQuery)inOrder.verify((Object)this.mockQuery)).list();
        this.verifyExampleUserResponse(response);
    }

    @Test
    public void testCompleteGetParameters() {
        Map<String, String> queryParameters = this.getCompleteStringQueryParameters();
        RequestSpecification requestSpecification = RestAssured.given().contentType(POST_JSON_CONTENT_TYPE);
        for (Map.Entry<String, String> paramEntry : queryParameters.entrySet()) {
            requestSpecification.parameter(paramEntry.getKey(), new Object[]{paramEntry.getValue()});
        }
        requestSpecification.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(USER_QUERY_URL, new Object[0]);
        ((UserQuery)Mockito.verify((Object)this.mockQuery)).userEmail("test@example.org");
        ((UserQuery)Mockito.verify((Object)this.mockQuery)).userFirstName("firstName");
        ((UserQuery)Mockito.verify((Object)this.mockQuery)).userLastName("lastName");
        ((UserQuery)Mockito.verify((Object)this.mockQuery)).memberOfGroup("groupId1");
        ((UserQuery)Mockito.verify((Object)this.mockQuery)).memberOfTenant("aTenantId");
        ((UserQuery)Mockito.verify((Object)this.mockQuery)).list();
    }

    @Test
    public void testFirstNameLikeQuery() {
        String[] testQueries;
        for (String testQuery : testQueries = new String[]{"first%", "%Name", "%stNa%"}) {
            Response response = (Response)RestAssured.given().queryParam("firstNameLike", new Object[]{testQuery}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(USER_QUERY_URL, new Object[0]);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
            ((UserQuery)inOrder.verify((Object)this.mockQuery)).userFirstNameLike(testQuery);
            ((UserQuery)inOrder.verify((Object)this.mockQuery)).list();
            this.verifyExampleUserResponse(response);
        }
    }

    @Test
    public void testLastNameLikeQuery() {
        String[] testQueries;
        for (String testQuery : testQueries = new String[]{"last%", "%Name", "%stNa%"}) {
            Response response = (Response)RestAssured.given().queryParam("lastNameLike", new Object[]{testQuery}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(USER_QUERY_URL, new Object[0]);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
            ((UserQuery)inOrder.verify((Object)this.mockQuery)).userLastNameLike(testQuery);
            ((UserQuery)inOrder.verify((Object)this.mockQuery)).list();
            this.verifyExampleUserResponse(response);
        }
    }

    @Test
    public void testEmailLikeQuery() {
        String[] testQueries;
        for (String testQuery : testQueries = new String[]{"test@%", "%example.org", "%@%"}) {
            Response response = (Response)RestAssured.given().queryParam("emailLike", new Object[]{testQuery}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(USER_QUERY_URL, new Object[0]);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
            ((UserQuery)inOrder.verify((Object)this.mockQuery)).userEmailLike(testQuery);
            ((UserQuery)inOrder.verify((Object)this.mockQuery)).list();
            this.verifyExampleUserResponse(response);
        }
    }

    private Map<String, String> getCompleteStringQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("firstName", "firstName");
        parameters.put("lastName", "lastName");
        parameters.put("email", "test@example.org");
        parameters.put("memberOfGroup", "groupId1");
        parameters.put("memberOfTenant", "aTenantId");
        return parameters;
    }

    @Test
    public void testQueryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(USER_COUNT_QUERY_URL, new Object[0]);
        ((UserQuery)Mockito.verify((Object)this.mockQuery)).count();
    }

    @Test
    public void testSuccessfulPagination() {
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(USER_QUERY_URL, new Object[0]);
        ((UserQuery)Mockito.verify((Object)this.mockQuery)).listPage(firstResult, maxResults);
    }

    protected void verifyExampleUserResponse(Response response) {
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one user returned.", (long)1L, (long)instances.size());
        Assert.assertNotNull((String)"The returned user should not be null.", instances.get(0));
        String returendLastName = JsonPath.from((String)content).getString("[0].lastName");
        String returnedFirstName = JsonPath.from((String)content).getString("[0].firstName");
        String returnedEmail = JsonPath.from((String)content).getString("[0].email");
        Assert.assertEquals((Object)"firstName", (Object)returnedFirstName);
        Assert.assertEquals((Object)"lastName", (Object)returendLastName);
        Assert.assertEquals((Object)"test@example.org", (Object)returnedEmail);
    }
}

